/*
 * Decompiled with CFR 0.152.
 */
package me.wolfyscript.utilities.api.custom_items;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import me.wolfyscript.utilities.api.config.ConfigAPI;
import me.wolfyscript.utilities.api.custom_items.CustomConfig;
import me.wolfyscript.utilities.api.custom_items.CustomItem;
import me.wolfyscript.utilities.api.custom_items.CustomItems;
import me.wolfyscript.utilities.api.custom_items.MetaSettings;
import me.wolfyscript.utilities.api.custom_items.ParticleContent;
import me.wolfyscript.utilities.api.custom_items.custom_data.CustomData;
import org.bukkit.Material;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;

public class ItemConfig
extends CustomConfig {
    public ItemConfig(ConfigAPI configAPI, String namespace, String path, String key, String defaultPath, String defaultName, boolean override) {
        super(configAPI, namespace, key, path, defaultPath, defaultName, override);
    }

    public ItemConfig(ConfigAPI configAPI, String namespace, String path, String key, String defaultName, boolean override) {
        super(configAPI, namespace, key, path, "me/wolfyscript/utilities/custom_items/", defaultName, override);
    }

    public ItemConfig(ConfigAPI configAPI, String namespace, String path, String key, boolean override) {
        super(configAPI, namespace, key, path, "me/wolfyscript/utilities/custom_items/", "item", override);
    }

    public ItemConfig(ConfigAPI configAPI, String namespace, String path, String key) {
        super(configAPI, namespace, key, path, "me/wolfyscript/utilities/custom_items/", "item", false);
    }

    public ItemConfig(String jsonData, ConfigAPI configAPI, String namespace, String key) {
        super(jsonData, configAPI, namespace, key, "me/wolfyscript/utilities/custom_items/", "item");
    }

    public ItemConfig(ConfigAPI configAPI, String namespace, String key) {
        super(configAPI, namespace, key, "me/wolfyscript/utilities/custom_items/", "item");
    }

    public ItemConfig(String namespace, String key, String defPath, String defName, boolean override, ConfigAPI configAPI) {
        super(configAPI, namespace, key, configAPI.getApi().getPlugin().getDataFolder().getParent() + "/CustomCrafting/recipes/" + namespace + "/items", defPath, defName, override);
    }

    public ItemConfig(String namespace, String key, String defPath, String defName, ConfigAPI configAPI) {
        this(namespace, key, defPath, defName, false, configAPI);
    }

    public ItemConfig(String namespace, String key, ConfigAPI configAPI) {
        this(namespace, key, "me/wolfyscript/utilities/custom_items/", "item", false, configAPI);
    }

    public ItemConfig(String namespace, String key, boolean override, ConfigAPI configAPI) {
        this(namespace, key, "me/wolfyscript/utilities/custom_items/", "item", override, configAPI);
    }

    public ItemStack getCustomItem(boolean replaceLang) {
        return this.getItem("item", replaceLang);
    }

    public ItemStack getCustomItem() {
        return this.getCustomItem(true);
    }

    public void setCustomItem(CustomItem itemStack) {
        this.setItem("item", new ItemStack((ItemStack)itemStack));
        this.setMetaSettings(itemStack.getMetaSettings());
        this.setBurnTime(itemStack.getBurnTime());
        this.setConsumed(itemStack.isConsumed());
        this.setRarityPercentage(itemStack.getRarityPercentage());
        this.setPermission(itemStack.getPermission());
        this.setCustomData(itemStack.getCustomDataMap());
        this.setReplacementItem(itemStack.getReplacement());
        this.setDurabilityCost(itemStack.getDurabilityCost());
        this.setEquipmentSlots(itemStack.getEquipmentSlots().toArray(new EquipmentSlot[0]));
        this.setParticleData(itemStack.getParticleContent());
        if (itemStack.getAllowedBlocks().isEmpty()) {
            this.setAllowedBlocks(new ArrayList<Material>(Collections.singleton(Material.FURNACE)));
        } else {
            this.setAllowedBlocks(itemStack.getAllowedBlocks());
        }
    }

    public void setItem(ItemStack itemStack) {
        this.setItem("item", itemStack);
    }

    public void setDurabilityCost(int durabilityCost) {
        this.set("durability_cost", durabilityCost);
    }

    public int getDurabilityCost() {
        return this.getInt("durability_cost");
    }

    public void setConsumed(boolean consumed) {
        this.set("consumed", consumed);
    }

    public boolean isConsumed() {
        return this.getBoolean("consumed");
    }

    public void setReplacementItem(CustomItem customItem) {
        if (customItem != null) {
            if (!customItem.getId().isEmpty() && !customItem.getId().equals("NULL")) {
                this.set("replacement.item_key", customItem.getId());
            } else {
                this.setItem("replacement.item", new ItemStack((ItemStack)customItem));
            }
        } else {
            this.set("replacement.item", null);
        }
    }

    public CustomItem getReplacementItem() {
        String id = this.getString("replacement.item_key");
        if (id != null && !id.isEmpty()) {
            return CustomItems.getCustomItem(id);
        }
        if (this.getItem("replacement.item") != null) {
            return new CustomItem(this.getItem("replacement.item"));
        }
        return null;
    }

    public void setAllowedBlocks(ArrayList<Material> furnaces) {
        ArrayList mats = new ArrayList();
        furnaces.forEach(material -> mats.add(material.name().toLowerCase(Locale.ROOT)));
        this.set("fuel.allowed_blocks", mats);
    }

    public ArrayList<Material> getAllowedBlocks() {
        ArrayList<Material> furnaces = new ArrayList<Material>();
        if (this.getStringList("fuel.allowed_blocks") != null) {
            this.getStringList("fuel.allowed_blocks").forEach(s -> {
                Material material = Material.matchMaterial((String)s);
                if (material != null) {
                    furnaces.add(material);
                }
            });
        }
        return furnaces;
    }

    public void setBurnTime(int burntime) {
        this.set("fuel.burntime", burntime);
    }

    public int getBurnTime() {
        return this.getInt("fuel.burntime", 0);
    }

    public void setMetaSettings(MetaSettings metaSettings) {
        this.set("meta", metaSettings.toString());
    }

    public MetaSettings getMetaSettings() {
        if (this.getString("meta") != null && !this.getString("meta").isEmpty()) {
            return new MetaSettings(this.getString("meta"));
        }
        return new MetaSettings();
    }

    public void setRarityPercentage(double percentage) {
        this.set("rarity_percentage", percentage);
    }

    public double getRarityPercentage() {
        return this.getDouble("rarity_percentage", 1.0);
    }

    public void setPermission(String permission) {
        this.set("permission", permission);
    }

    public String getPermission() {
        return this.getString("permission", "");
    }

    public void setCustomData(HashMap<String, CustomData> customDataList) {
        HashMap<String, Map<String, Object>> customDatas = new HashMap<String, Map<String, Object>>();
        for (CustomData customData : customDataList.values()) {
            customDatas.put(customData.getId(), customData.toMap());
        }
        this.set("custom_data", customDatas);
    }

    public HashMap<String, CustomData> getCustomData() {
        HashMap<String, CustomData> customDataMap = new HashMap<String, CustomData>();
        for (CustomData customData : CustomItem.getAvailableCustomData().values()) {
            customDataMap.put(customData.getId(), customData.getDefaultCopy());
        }
        Object result = this.get("custom_data");
        if (result instanceof Map) {
            Map customDatas = (Map)result;
            for (Map.Entry entry : customDatas.entrySet()) {
                if (!CustomItem.getAvailableCustomData().containsKey(entry.getKey())) continue;
                customDataMap.put((String)entry.getKey(), CustomItem.getAvailableCustomData().get(entry.getKey()).fromMap((Map)entry.getValue()));
            }
        }
        return customDataMap;
    }

    public List<EquipmentSlot> getEquipmentSlots() {
        ArrayList<EquipmentSlot> slots = new ArrayList<EquipmentSlot>();
        this.getStringList("equipment_slots").forEach(s -> slots.add(EquipmentSlot.valueOf((String)s.toUpperCase(Locale.ROOT))));
        return slots;
    }

    public void setEquipmentSlots(EquipmentSlot ... slots) {
        this.set("equipment_slots", slots);
    }

    public ParticleContent getParticleData() {
        return this.get(ParticleContent.class, "particles");
    }

    public void setParticleData(ParticleContent particleContent) {
        this.set("particles", particleContent);
    }
}

