/*
 * Decompiled with CFR 0.152.
 */
package me.wolfyscript.utilities.api.inventory;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nonnull;
import me.wolfyscript.utilities.api.WolfyUtilities;
import me.wolfyscript.utilities.api.inventory.GuiCluster;
import me.wolfyscript.utilities.api.inventory.GuiHandler;
import me.wolfyscript.utilities.api.inventory.GuiItemDragEvent;
import me.wolfyscript.utilities.api.inventory.GuiWindow;
import me.wolfyscript.utilities.api.inventory.button.Button;
import me.wolfyscript.utilities.api.inventory.button.buttons.ItemInputButton;
import me.wolfyscript.utilities.api.inventory.cache.CustomCache;
import me.wolfyscript.utilities.api.utils.InventoryUtils;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.plugin.Plugin;

public class InventoryAPI<T extends CustomCache>
implements Listener {
    private Plugin plugin;
    private WolfyUtilities wolfyUtilities;
    private HashMap<String, GuiHandler> guiHandlers = new HashMap();
    private HashMap<String, GuiCluster> guiClusters = new HashMap();
    private Class<T> customCacheClass;

    public InventoryAPI(Plugin plugin, WolfyUtilities wolfyUtilities, Class<T> customCacheClass) {
        this.wolfyUtilities = wolfyUtilities;
        this.plugin = plugin;
        this.customCacheClass = customCacheClass;
        try {
            customCacheClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            e.printStackTrace();
        }
        plugin.getServer().getPluginManager().registerEvents((Listener)this, plugin);
    }

    public void registerGuiCluster(String id) {
        GuiCluster guiCluster = new GuiCluster();
        guiCluster.setId(id);
        this.guiClusters.putIfAbsent(id, guiCluster);
    }

    public void registerCustomGuiCluster(String id, GuiCluster guiCluster) {
        guiCluster.setId(id);
        this.guiClusters.putIfAbsent(id, guiCluster);
    }

    public GuiCluster getOrRegisterGuiCluster(String clusterID) {
        this.registerGuiCluster(clusterID);
        return this.getGuiCluster(clusterID);
    }

    public GuiCluster getGuiCluster(String id) {
        return this.guiClusters.get(id);
    }

    public GuiCluster getGuiCluster() {
        return this.getGuiCluster("none");
    }

    public boolean hasGuiCluster(String id) {
        return this.getGuiCluster(id) != null;
    }

    public void registerGuiWindow(String clusterID, GuiWindow guiWindow) {
        this.getGuiCluster(clusterID).registerGuiWindow(guiWindow);
    }

    public void registerGuiWindow(GuiWindow guiWindow) {
        this.registerGuiWindow("none", guiWindow);
    }

    public GuiWindow getGuiWindow(String clusterID, String guiWindowID) {
        return this.getGuiCluster(clusterID).getGuiWindow(guiWindowID);
    }

    public GuiWindow getGuiWindow(String guiWindowID) {
        return this.getGuiCluster("none").getGuiWindow(guiWindowID);
    }

    public WolfyUtilities getWolfyUtilities() {
        return this.wolfyUtilities;
    }

    public void setMainmenu(String guiWindowID) {
        this.getGuiCluster("none").setMainmenu(guiWindowID);
    }

    public void openCluster(Player player, String clusterID) {
        this.getGuiHandler(player).openCluster(clusterID);
    }

    @Deprecated
    public void openGui(Player player, String guiWindowID) {
        this.getGuiHandler(player).changeToInv(guiWindowID);
    }

    public void openGui(Player player, String clusterID, String guiWindowID) {
        this.getGuiHandler(player).changeToInv(clusterID, guiWindowID);
    }

    public void removeGui(Player player) {
        if (this.hasGuiHandler(player)) {
            this.removePlayerGuiHandler(player);
        }
    }

    @Nonnull
    public GuiHandler getGuiHandler(Player player) {
        if (!this.hasGuiHandler(player)) {
            this.createGuiHandler(player);
        }
        return this.guiHandlers.get(player.getUniqueId().toString());
    }

    private void createGuiHandler(Player player) {
        GuiHandler<T> guiHandler = new GuiHandler<T>(player, this.wolfyUtilities, this.craftCustomCache());
        this.setPlayerGuiStudio(player, guiHandler);
    }

    private void setPlayerGuiStudio(Player player, GuiHandler guiStudio) {
        this.guiHandlers.put(player.getUniqueId().toString(), guiStudio);
    }

    private void removePlayerGuiHandler(Player player, GuiHandler guiStudio) {
        this.guiHandlers.remove(player.getUniqueId().toString(), guiStudio);
    }

    private void removePlayerGuiHandler(Player player) {
        this.guiHandlers.remove(player.getUniqueId().toString());
    }

    public boolean hasGuiHandler(Player player) {
        return this.guiHandlers.containsKey(player.getUniqueId().toString()) && this.guiHandlers.get(player.getUniqueId().toString()) != null;
    }

    public boolean hasGuiHandlerAndInv(Player player) {
        return this.guiHandlers.containsKey(player.getUniqueId().toString()) && this.guiHandlers.get(player.getUniqueId().toString()) != null && this.guiHandlers.get(player.getUniqueId().toString()).getCurrentInv() != null;
    }

    public Plugin getPlugin() {
        return this.plugin;
    }

    public void reset() {
        for (Player player : this.plugin.getServer().getOnlinePlayers()) {
            player.closeInventory();
            this.removeGui(player);
        }
        this.guiHandlers.clear();
    }

    public T craftCustomCache() {
        try {
            return (T)((CustomCache)this.customCacheClass.newInstance());
        }
        catch (IllegalAccessException | InstantiationException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void registerButton(String clusterID, Button button) {
        this.getGuiCluster(clusterID).registerButton(button, this.getWolfyUtilities());
    }

    public Button getButton(String clusterID, String buttonID) {
        return this.getGuiCluster(clusterID).getButton(buttonID);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onInvClick(InventoryClickEvent event) {
        GuiHandler guiHandler;
        if (event.getClickedInventory() != null && this.hasGuiHandler((Player)event.getWhoClicked()) && (guiHandler = this.getGuiHandler((Player)event.getWhoClicked())).verifyInventory(event.getView().getTopInventory())) {
            GuiWindow guiWindow = guiHandler.getCurrentInv();
            if (event.getAction().equals((Object)InventoryAction.COLLECT_TO_CURSOR)) {
                event.setCancelled(true);
                for (Map.Entry<Integer, String> buttonEntry : ((CustomCache)guiHandler.getCustomCache()).getButtons(guiWindow).entrySet()) {
                    Button button = guiWindow.getButton(buttonEntry.getValue());
                    if (!(button instanceof ItemInputButton)) continue;
                    event.setCancelled(button.execute(guiHandler, (Player)event.getWhoClicked(), guiWindow.getInventory(guiHandler), buttonEntry.getKey(), event));
                }
                return;
            }
            if (event.getClickedInventory().equals(event.getView().getTopInventory())) {
                event.setCancelled(true);
                Button button = guiHandler.getButton(guiWindow, event.getSlot());
                if (button != null) {
                    event.setCancelled(button.execute(guiHandler, (Player)event.getWhoClicked(), guiWindow.getInventory(guiHandler), event.getSlot(), event));
                    guiHandler.getCurrentInv().update(guiHandler);
                }
            } else if (event.getAction().equals((Object)InventoryAction.MOVE_TO_OTHER_INVENTORY)) {
                Button button;
                int slot = -1;
                if (event.getCurrentItem() != null) {
                    slot = InventoryUtils.firstSimilar(event.getView().getTopInventory(), event.getCurrentItem());
                }
                if (slot == -1) {
                    slot = event.getView().getTopInventory().firstEmpty();
                }
                if ((button = guiHandler.getButton(guiWindow, slot)) != null) {
                    event.setCancelled(button.execute(guiHandler, (Player)event.getWhoClicked(), guiWindow.getInventory(guiHandler), slot, event));
                    guiHandler.getCurrentInv().update(guiHandler);
                } else {
                    event.setCancelled(true);
                }
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onItemDrag(InventoryDragEvent event) {
        GuiHandler guiHandler;
        if (event.getInventory() != null && this.hasGuiHandler((Player)event.getWhoClicked()) && (guiHandler = this.getGuiHandler((Player)event.getWhoClicked())).verifyInventory(event.getView().getTopInventory())) {
            Iterator iterator = event.getRawSlots().iterator();
            while (iterator.hasNext()) {
                int rawSlot = (Integer)iterator.next();
                if (guiHandler.verifyInventory(event.getView().getInventory(rawSlot))) continue;
                event.setCancelled(true);
                return;
            }
            GuiWindow guiWindow = guiHandler.getCurrentInv();
            GuiItemDragEvent guiItemDragEvent = new GuiItemDragEvent(guiHandler, event);
            Bukkit.getPluginManager().callEvent((Event)guiItemDragEvent);
            if (guiItemDragEvent.isCancelled()) {
                event.setCancelled(true);
            }
            HashMap<Button, Integer> buttons = new HashMap<Button, Integer>();
            Iterator<Object> iterator2 = event.getInventorySlots().iterator();
            while (iterator2.hasNext()) {
                int n = (Integer)iterator2.next();
                Button button = guiHandler.getButton(guiWindow, n);
                if (button == null) {
                    event.setCancelled(true);
                    return;
                }
                buttons.put(button, n);
            }
            for (Map.Entry entry : buttons.entrySet()) {
                event.setCancelled(((Button)entry.getKey()).execute(guiHandler, (Player)event.getWhoClicked(), guiWindow.getInventory(guiHandler), (Integer)entry.getValue(), new InventoryClickEvent(event.getView(), event.getView().getSlotType(((Integer)entry.getValue()).intValue()), ((Integer)entry.getValue()).intValue(), ClickType.RIGHT, InventoryAction.PLACE_SOME)));
            }
            guiHandler.getCurrentInv().update(guiHandler);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPreChat(AsyncPlayerChatEvent event) {
        GuiHandler guiHandler;
        if (event.getMessage() != null && this.hasGuiHandler(event.getPlayer()) && (guiHandler = this.getGuiHandler(event.getPlayer())).isChatEventActive()) {
            String message = event.getMessage();
            Bukkit.getScheduler().runTask(this.getPlugin(), () -> Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)("wui " + this.getPlugin().getName() + " " + event.getPlayer().getUniqueId().toString() + " " + message)));
            event.setCancelled(true);
        }
    }
}

