/*
 * Decompiled with CFR 0.152.
 */
package me.wolfyscript.utilities.main.listeners;

import me.wolfyscript.utilities.api.custom_items.CustomItem;
import me.wolfyscript.utilities.api.custom_items.CustomItems;
import me.wolfyscript.utilities.api.custom_items.ParticleContent;
import me.wolfyscript.utilities.api.custom_items.equipment.ArmorEquipEvent;
import me.wolfyscript.utilities.api.custom_items.equipment.ArmorType;
import me.wolfyscript.utilities.api.utils.ItemUtils;
import me.wolfyscript.utilities.api.utils.NamespacedKey;
import me.wolfyscript.utilities.api.utils.particles.ParticleEffect;
import me.wolfyscript.utilities.api.utils.particles.ParticleEffects;
import me.wolfyscript.utilities.main.Main;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.block.Dispenser;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockDispenseEvent;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class EquipListener
implements Listener {
    @EventHandler
    public void dispenseArmorEvent(BlockDispenseEvent event) {
        CustomItem customItem = CustomItem.getByItemStack(event.getItem());
        if (customItem != null && customItem.hasID() && customItem.hasEquipmentSlot()) {
            Location location = event.getBlock().getLocation();
            Dispenser dispenser = (Dispenser)event.getBlock().getState();
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onArmorEquip(ArmorEquipEvent event) {
        ArmorType type = event.getType();
        EquipmentSlot equipmentSlot = type.getEquipmentSlot();
        CustomItem newArmorPiece = event.getNewCustomArmorPiece();
        if (!ItemUtils.isAirOrNull(newArmorPiece)) {
            if (ItemUtils.isEquipable(newArmorPiece.getType())) {
                if (!ItemUtils.isEquipable(newArmorPiece.getType(), type) && !newArmorPiece.isBlockVanillaEquip()) {
                    event.setCancelled(true);
                }
            } else {
                event.setCancelled(true);
            }
            if (newArmorPiece.hasID() && newArmorPiece.getEquipmentSlots().contains(equipmentSlot)) {
                NamespacedKey particleID;
                CustomItems.stopActiveParticleEffect(event.getPlayer(), equipmentSlot);
                ParticleContent particleContent = newArmorPiece.getParticleContent();
                if (particleContent != null && (particleID = particleContent.getParticleEffect(ParticleEffect.Action.valueOf(equipmentSlot.name()))) != null) {
                    CustomItems.setActiveParticleEffect(event.getPlayer(), equipmentSlot, ParticleEffects.spawnEffectOnPlayer(particleID, equipmentSlot, event.getPlayer()));
                }
                event.setCancelled(false);
            }
        } else {
            CustomItems.stopActiveParticleEffect(event.getPlayer(), equipmentSlot);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onClickInventory(InventoryClickEvent event) {
        boolean shift = event.isShiftClick();
        boolean numberkey = event.getClick().equals((Object)ClickType.NUMBER_KEY);
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        if (event.getClickedInventory() != null && !event.getClickedInventory().getType().equals((Object)InventoryType.PLAYER)) {
            return;
        }
        CustomItem item = CustomItem.getByItemStack(event.isShiftClick() ? event.getCurrentItem() : event.getCursor());
        if (item == null) {
            return;
        }
        if (shift) {
            if (!event.getSlotType().equals((Object)InventoryType.SlotType.ARMOR)) {
                CustomItem newArmorPiece = CustomItem.getByItemStack(event.getCurrentItem());
                if (!ItemUtils.isAirOrNull(newArmorPiece) && newArmorPiece.hasEquipmentSlot()) {
                    int slot = -1;
                    for (int i = 39; i > 36; --i) {
                        if (!ItemUtils.isAirOrNull(event.getClickedInventory().getItem(i)) || !newArmorPiece.hasEquipmentSlot(ArmorType.getBySlot(i).getEquipmentSlot())) continue;
                        slot = i;
                    }
                    event.setCancelled(true);
                    if (slot == -1) {
                        return;
                    }
                    ArmorEquipEvent equipEvent = new ArmorEquipEvent(player, ArmorEquipEvent.EquipMethod.SHIFT_CLICK, ArmorType.getBySlot(slot), null, event.getCurrentItem(), null, newArmorPiece);
                    Bukkit.getPluginManager().callEvent((Event)equipEvent);
                    if (equipEvent.isCancelled()) {
                        return;
                    }
                    int finalSlot = slot;
                    ItemStack newArmor = equipEvent.getNewArmorPiece();
                    ItemStack oldArmorPiece = equipEvent.getOldArmorPiece();
                    Bukkit.getScheduler().runTask((Plugin)Main.getInstance(), () -> {
                        event.getClickedInventory().setItem(finalSlot, ItemUtils.isAirOrNull(newArmor) ? null : newArmor);
                        event.getClickedInventory().setItem(event.getSlot(), ItemUtils.isAirOrNull(oldArmorPiece) ? null : oldArmorPiece);
                    });
                }
            } else {
                CustomItem oldArmorPiece = CustomItem.getByItemStack(event.getCurrentItem());
                ArmorEquipEvent equipEvent = new ArmorEquipEvent(player, ArmorEquipEvent.EquipMethod.SHIFT_CLICK, ArmorType.getBySlot(event.getSlot()), event.getCurrentItem(), null, oldArmorPiece, null);
                Bukkit.getPluginManager().callEvent((Event)equipEvent);
                if (equipEvent.isCancelled()) {
                    event.setCancelled(true);
                }
            }
        } else {
            ItemStack newArmorPiece = event.getCursor();
            ItemStack oldArmorPiece = event.getCurrentItem();
            CustomItem newCustomArmorPiece = CustomItem.getByItemStack(newArmorPiece);
            CustomItem oldCustomArmorPiece = CustomItem.getByItemStack(oldArmorPiece);
            if (numberkey) {
                if (event.getClickedInventory().getType().equals((Object)InventoryType.PLAYER)) {
                    ItemStack hotbarItem = event.getClickedInventory().getItem(event.getHotbarButton());
                    CustomItem customHotbarItem = CustomItem.getByItemStack(hotbarItem);
                    ArmorType type = ArmorType.getBySlot(event.getSlot());
                    if (type == null) {
                        return;
                    }
                    if (!ItemUtils.isAirOrNull(hotbarItem)) {
                        newArmorPiece = hotbarItem;
                        newCustomArmorPiece = customHotbarItem;
                        oldArmorPiece = event.getClickedInventory().getItem(event.getSlot());
                        oldCustomArmorPiece = CustomItem.getByItemStack(oldArmorPiece);
                    }
                    ArmorEquipEvent equipEvent = new ArmorEquipEvent(player, ArmorEquipEvent.EquipMethod.HOTBAR_SWAP, ArmorType.getBySlot(event.getSlot()), oldArmorPiece, newArmorPiece, oldCustomArmorPiece, newCustomArmorPiece);
                    Bukkit.getPluginManager().callEvent((Event)equipEvent);
                    if (equipEvent.isCancelled()) {
                        event.setCancelled(true);
                        return;
                    }
                    ItemStack newArmor = equipEvent.getNewArmorPiece();
                    ItemStack oldArmor = equipEvent.getOldArmorPiece();
                    if (newArmor != null && ItemUtils.isEquipable(newArmor.getType()) && newArmor.getType().name().endsWith("_" + equipEvent.getType().name())) {
                        return;
                    }
                    event.setCancelled(true);
                    Bukkit.getScheduler().runTask((Plugin)Main.getInstance(), () -> {
                        event.getClickedInventory().setItem(event.getSlot(), newArmor);
                        event.getClickedInventory().setItem(event.getHotbarButton(), ItemUtils.isAirOrNull(oldArmor) ? null : oldArmor);
                        player.updateInventory();
                    });
                }
            } else if (event.getSlotType().equals((Object)InventoryType.SlotType.ARMOR)) {
                if (ItemUtils.isAirOrNull(newArmorPiece) && ItemUtils.isAirOrNull(oldArmorPiece)) {
                    return;
                }
                ArmorType armorType = ArmorType.getBySlot(event.getSlot());
                if (!ItemUtils.isAirOrNull(newArmorPiece) && ItemUtils.isAirOrNull(oldArmorPiece)) {
                    armorType = ArmorType.getBySlot(event.getSlot());
                    if (!ItemUtils.isAirOrNull(oldArmorPiece) && event.isRightClick()) {
                        return;
                    }
                }
                ArmorEquipEvent equipEvent = new ArmorEquipEvent(player, ArmorEquipEvent.EquipMethod.PICK_DROP, ArmorType.getBySlot(event.getSlot()), oldArmorPiece, newArmorPiece, oldCustomArmorPiece, newCustomArmorPiece);
                Bukkit.getPluginManager().callEvent((Event)equipEvent);
                event.setCancelled(true);
                if (equipEvent.isCancelled()) {
                    return;
                }
                event.getClickedInventory().setItem(event.getSlot(), equipEvent.getNewArmorPiece());
                event.setCursor(equipEvent.getOldArmorPiece());
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void playerInteractEvent(PlayerInteractEvent e) {
        if (e.getAction() == Action.PHYSICAL) {
            return;
        }
        if (e.getAction() == Action.RIGHT_CLICK_AIR || e.getAction() == Action.RIGHT_CLICK_BLOCK) {
            Player player = e.getPlayer();
            if (e.getClickedBlock() != null && e.getAction() == Action.RIGHT_CLICK_BLOCK && !player.isSneaking() && e.getClickedBlock().getType().isInteractable()) {
                return;
            }
            CustomItem customItem = CustomItem.getByItemStack(e.getItem());
            if (customItem == null || !customItem.hasID() || customItem.hasEquipmentSlot()) {
                // empty if block
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void inventoryDrag(InventoryDragEvent event) {
    }
}

