/*
 * Decompiled with CFR 0.152.
 */
package me.wolfyscript.utilities.api.config;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonIOException;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.google.gson.internal.bind.TypeAdapters;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import me.wolfyscript.utilities.api.WolfyUtilities;
import me.wolfyscript.utilities.api.config.ConfigAPI;
import me.wolfyscript.utilities.api.config.Configuration;
import me.wolfyscript.utilities.api.config.FileConfiguration;
import me.wolfyscript.utilities.api.utils.GsonUtil;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.util.NumberConversions;

public class JsonConfiguration
extends FileConfiguration {
    private final Gson gson = GsonUtil.getGson();
    private JsonObject root;
    private String defJsonString;
    private char pathSeparator = (char)46;

    public JsonConfiguration(ConfigAPI configAPI, String path, String name, String defPath, String defFileName, boolean overwrite) {
        super(configAPI, path, name, defPath, defFileName, Configuration.Type.JSON);
        this.map = new HashMap();
        this.root = new JsonObject();
        if (!this.configFile.exists()) {
            try {
                this.configFile.getParentFile().mkdirs();
                this.configFile.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.onFirstInit();
        }
        this.load();
        this.loadDefaults(overwrite);
        this.reload();
        this.init();
    }

    public JsonConfiguration(ConfigAPI configAPI, String fileName) {
        this(configAPI, "{}", fileName);
    }

    public JsonConfiguration(ConfigAPI configAPI, String jsonString, String path, String name, boolean overwrite) {
        this(configAPI, path, name, "", "", overwrite);
        this.defJsonString = jsonString;
    }

    public JsonConfiguration(ConfigAPI configAPI, String jsonData, String name) {
        super(configAPI, "", name, "", "", Configuration.Type.JSON);
        this.map = new HashMap();
        this.root = new JsonObject();
        this.defJsonString = jsonData;
        this.loadFromString(jsonData);
    }

    public JsonConfiguration(ConfigAPI configAPI, String name, String defPath, String defFileName) {
        this("{}", configAPI, name, defPath, defFileName);
        this.map = new HashMap();
        this.root = new JsonObject();
        this.loadDefaults();
    }

    public JsonConfiguration(String jsonData, ConfigAPI configAPI, String name, String defPath, String defFileName) {
        super(configAPI, "", name, defPath, defFileName, Configuration.Type.JSON);
        this.map = new HashMap();
        this.root = new JsonObject();
        this.loadFromString(jsonData);
        this.loadDefaults();
    }

    @Override
    public void onFirstInit() {
    }

    @Override
    public void init() {
    }

    @Override
    public boolean hasPathSeparator() {
        return this.pathSeparator != '\u0000';
    }

    @Override
    public void setPathSeparator(char pathSeparator) {
        this.pathSeparator = pathSeparator;
    }

    @Override
    public char getPathSeparator() {
        return this.pathSeparator;
    }

    @Override
    public void loadDefaults() {
        this.loadDefaults(false);
    }

    public void loadDefaults(boolean overwrite) {
        this.gson.fieldNamingStrategy();
        if (this.defPath != null && this.defFileName != null && !this.defPath.isEmpty() && !this.defFileName.isEmpty()) {
            if (this.plugin.getResource(this.defPath + "/" + this.defFileName + ".json") != null) {
                HashMap defMap = null;
                try {
                    JsonObject jsonObject = (JsonObject)TypeAdapters.JSON_ELEMENT.fromJson((Reader)new InputStreamReader(this.plugin.getResource(this.defPath + "/" + this.defFileName + ".json"), "UTF-8"));
                    defMap = (HashMap)this.gson.fromJson((Reader)new InputStreamReader(this.plugin.getResource(this.defPath + "/" + this.defFileName + ".json"), "UTF-8"), new HashMap().getClass());
                    if (overwrite) {
                        this.map.putAll(defMap);
                        this.root = jsonObject;
                    }
                    this.applyDefaults("", jsonObject);
                    for (Map.Entry entry : defMap.entrySet()) {
                        this.map.putIfAbsent((String)entry.getKey(), entry.getValue());
                    }
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        } else {
            try {
                PrintWriter pw = new PrintWriter(this.configFile, "UTF-8");
                pw.write(this.defJsonString);
                pw.close();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
    }

    public void applyDefaults(String pathKey, JsonObject jsonObject) {
        for (Map.Entry entry : jsonObject.entrySet()) {
            String subPath = (pathKey.isEmpty() ? "" : pathKey + this.getPathSeparator()) + (String)entry.getKey();
            if (entry.getValue() instanceof JsonObject) {
                this.applyDefaults(subPath, (JsonObject)entry.getValue());
                continue;
            }
            if (this.get(subPath) != null) continue;
            this.set(subPath, entry.getValue());
        }
    }

    public void loadFromString(String json) {
        this.root = (JsonObject)this.gson.fromJson(json, JsonObject.class);
        this.map = (HashMap)this.gson.fromJson(json, new HashMap().getClass());
    }

    public String toString(boolean prettyPrinting) {
        return GsonUtil.getGson(prettyPrinting).toJson((JsonElement)this.root);
    }

    public String toString() {
        return this.toString(false);
    }

    @Override
    public void load() {
        if (this.linkedToFile()) {
            try {
                try {
                    JsonElement object = (JsonElement)this.gson.fromJson((Reader)new InputStreamReader((InputStream)new FileInputStream(this.configFile), "UTF-8"), JsonElement.class);
                    if (object instanceof JsonObject) {
                        this.root = (JsonObject)object;
                        if (this.root == null) {
                            this.root = new JsonObject();
                        }
                    }
                }
                catch (JsonIOException | JsonSyntaxException | IOException ex) {
                    ex.printStackTrace();
                }
                this.map = (HashMap)this.gson.fromJson((Reader)new InputStreamReader((InputStream)new FileInputStream(this.configFile), "UTF-8"), new HashMap().getClass());
                if (this.map == null) {
                    this.map = new HashMap();
                }
            }
            catch (FileNotFoundException | UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
    }

    public void save(boolean prettyPrinting) {
        if (this.linkedToFile()) {
            String json = this.toString(prettyPrinting);
            try {
                PrintWriter pw = new PrintWriter(this.configFile, "UTF-8");
                pw.close();
            }
            catch (FileNotFoundException | UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            try {
                Files.write(this.configFile.toPath(), json.getBytes("UTF-8"), StandardOpenOption.CREATE, StandardOpenOption.WRITE);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void save() {
        this.save(this.configAPI.isPrettyPrinting());
    }

    @Override
    public void reload() {
        this.save();
        this.load();
    }

    public void reload(boolean prettyPrinting) {
        this.save(prettyPrinting);
        this.load();
    }

    public void linkToFile(String path) {
        this.configFile = new File(path + ".json");
        if (!this.configFile.exists()) {
            this.configFile.getParentFile().mkdirs();
            this.loadDefaults();
            this.onFirstInit();
        }
    }

    public void linkToFile(String path, String fileName) {
        this.linkToFile(path + "/" + fileName);
    }

    public boolean linkedToFile() {
        return this.configFile != null;
    }

    public HashMap<String, Object> getValues() {
        return this.map;
    }

    @Override
    public Set<String> getKeys() {
        return this.getKeys(false);
    }

    @Override
    public Set<String> getKeys(boolean deep) {
        if (deep) {
            return this.parse("", this.root, new HashSet<String>());
        }
        HashSet<String> keys = new HashSet<String>();
        this.root.entrySet().forEach(entry -> keys.add((String)entry.getKey()));
        return keys;
    }

    public Set<String> parse(String currentPath, JsonObject jsonObject, Set<String> out) {
        for (Map.Entry entry : jsonObject.entrySet()) {
            String path = (currentPath.isEmpty() ? "" : currentPath + this.getPathSeparator()) + (String)entry.getKey();
            if (entry.getValue() instanceof JsonObject) {
                this.parse(path, (JsonObject)entry.getValue(), out);
                continue;
            }
            out.add(path);
        }
        return out;
    }

    @Override
    public Map<String, Object> getMap() {
        return this.map;
    }

    @Override
    public Object get(String path) {
        return this.get(path, null);
    }

    public <T> T get(Class<T> type, String path) {
        return this.get(type, path, null);
    }

    @Override
    public Object get(String path, @Nullable Object def) {
        return this.get(Object.class, path, def);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public <T> T get(Class<T> type, String path, @Nullable T def) {
        String[] pathKeys = path.split(this.pathSeparator == '.' ? "\\." : this.pathSeparator + "");
        JsonObject jsonObject = this.root;
        for (int i = 0; i < pathKeys.length; ++i) {
            if (!jsonObject.has(pathKeys[i])) return def;
            JsonElement element = jsonObject.get(pathKeys[i]);
            if (i == pathKeys.length - 1) return (T)this.gson.fromJson(element, type);
            if (!(element instanceof JsonObject)) {
                return null;
            }
            jsonObject = (JsonObject)element;
        }
        return def;
    }

    @Override
    public void set(String path, Object value) {
        String[] pathKeys = path.split(this.pathSeparator == '.' ? "\\." : this.pathSeparator + "");
        JsonObject jsonObject = this.root;
        for (int i = 0; i < pathKeys.length; ++i) {
            if (!jsonObject.has(pathKeys[i]) && i != pathKeys.length - 1) {
                jsonObject.add(pathKeys[i], (JsonElement)new JsonObject());
                jsonObject = jsonObject.getAsJsonObject(pathKeys[i]);
                continue;
            }
            JsonElement element = jsonObject.get(pathKeys[i]);
            if (i == pathKeys.length - 1) {
                jsonObject.add(pathKeys[i], this.gson.toJsonTree(value));
                if (!this.saveAfterValueSet) continue;
                this.reload();
                continue;
            }
            if (!(element instanceof JsonObject)) continue;
            jsonObject = (JsonObject)element;
        }
    }

    @Override
    public String getString(String path) {
        return this.getString(path, "");
    }

    @Override
    public String getString(String path, String def) {
        if (this.get(path) != null) {
            return this.get(path).toString();
        }
        return def;
    }

    @Override
    public int getInt(String path) {
        return this.getInt(path, 0);
    }

    @Override
    public int getInt(String path, int def) {
        Object val = this.get(path);
        return val instanceof Number ? NumberConversions.toInt((Object)this.get(path)) : def;
    }

    @Override
    public boolean getBoolean(String path) {
        Object val = this.get(path);
        return val instanceof Boolean && (Boolean)val != false;
    }

    @Override
    public double getDouble(String path) {
        return this.getDouble(path, 0.0);
    }

    @Override
    public double getDouble(String path, double def) {
        Object val = this.get(path);
        return val instanceof Number ? NumberConversions.toDouble((Object)val) : def;
    }

    @Override
    public long getLong(String path) {
        return this.getLong(path, 0L);
    }

    @Override
    public long getLong(String path, long def) {
        Object val = this.get(path);
        return val instanceof Number ? NumberConversions.toLong((Object)val) : def;
    }

    @Override
    public List<?> getList(String path) {
        Object val = this.get(path);
        return (List)(val instanceof List ? val : null);
    }

    @Override
    public List<String> getStringList(String path) {
        List<?> list = this.getList(path);
        if (list == null) {
            return new ArrayList<String>();
        }
        ArrayList<String> result = new ArrayList<String>();
        Iterator<?> var5 = list.iterator();
        while (var5.hasNext()) {
            Object object = var5.next();
            if (!(object instanceof String) && !this.isPrimitiveWrapper(object)) continue;
            result.add(String.valueOf(object));
        }
        return result;
    }

    @Override
    @Deprecated
    public void saveItem(String path, ItemStack item) {
        this.setItem(path, item);
    }

    @Override
    @Deprecated
    public void saveItem(String path, String name, ItemStack itemStack) {
        this.setItem(path, name, itemStack);
    }

    @Override
    public void setItem(String path, ItemStack itemStack) {
        this.set(path, itemStack);
    }

    @Override
    public void setItem(String path, String name, ItemStack itemStack) {
        this.setItem(path + "." + name, itemStack);
    }

    @Override
    public ItemStack getItem(String path) {
        return this.getItem(path, true);
    }

    @Override
    @Nullable
    public ItemStack getItem(String path, boolean replaceKeys) {
        ItemStack itemStack = this.get(ItemStack.class, path);
        if (itemStack != null) {
            if (itemStack.hasItemMeta()) {
                ItemMeta itemMeta = itemStack.getItemMeta();
                if (itemMeta.hasDisplayName()) {
                    String displayName = itemMeta.getDisplayName();
                    if (replaceKeys && this.api.getLanguageAPI().getActiveLanguage() != null) {
                        displayName = this.api.getLanguageAPI().getActiveLanguage().replaceKeys(displayName);
                    }
                    itemMeta.setDisplayName(WolfyUtilities.translateColorCodes(displayName));
                }
                if (itemMeta.hasLore() && replaceKeys && this.api.getLanguageAPI().getActiveLanguage() != null) {
                    ArrayList<String> newLore = new ArrayList<String>();
                    for (String row : itemMeta.getLore()) {
                        if (row.startsWith("[WU]")) {
                            newLore.add(this.api.getLanguageAPI().getActiveLanguage().replaceKeys(row.substring("[WU]".length())));
                            continue;
                        }
                        if (row.startsWith("[WU!]")) {
                            for (String newRow : this.api.getLanguageAPI().getActiveLanguage().replaceKey(row.substring("[WU!]".length()))) {
                                newLore.add(WolfyUtilities.translateColorCodes(newRow));
                            }
                            continue;
                        }
                        newLore.add(row);
                    }
                    itemMeta.setLore(newLore);
                }
                itemStack.setItemMeta(itemMeta);
            }
            return itemStack;
        }
        return null;
    }

    @Override
    public Map<String, Object> getValues(String path) {
        if (path.isEmpty()) {
            return this.getValues();
        }
        return (Map)this.get(path, new HashMap());
    }

    protected boolean isPrimitiveWrapper(@Nullable Object input) {
        return input instanceof Integer || input instanceof Boolean || input instanceof Character || input instanceof Byte || input instanceof Short || input instanceof Double || input instanceof Long || input instanceof Float;
    }
}

