/*
 * Decompiled with CFR 0.152.
 */
package me.wolfyscript.utilities.api.inventory;

import javax.annotation.Nonnull;
import me.wolfyscript.utilities.api.WolfyUtilities;
import me.wolfyscript.utilities.api.inventory.GuiHandler;
import me.wolfyscript.utilities.api.inventory.GuiWindow;
import me.wolfyscript.utilities.api.inventory.InventoryAPI;
import me.wolfyscript.utilities.api.inventory.button.Button;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;

public class GuiUpdateEvent
extends Event {
    private static final HandlerList handlers = new HandlerList();
    private GuiHandler guiHandler;
    private InventoryAPI inventoryAPI;
    private WolfyUtilities wolfyUtilities;
    private Player player;
    private Inventory inventory;
    private GuiWindow guiWindow;

    public GuiUpdateEvent(GuiHandler guiHandler, GuiWindow guiWindow) {
        this.guiHandler = guiHandler;
        this.inventoryAPI = guiHandler.getApi().getInventoryAPI();
        this.wolfyUtilities = guiHandler.getApi();
        this.player = guiHandler.getPlayer();
        this.guiWindow = guiWindow;
        if (!guiWindow.hasCachedInventory(guiHandler)) {
            String guiName = guiWindow.getInventoryName();
            guiName = guiName.replace("%plugin.version%", this.wolfyUtilities.getPlugin().getDescription().getVersion()).replace("%plugin.author%", this.wolfyUtilities.getPlugin().getDescription().getAuthors().toString()).replace("%plugin.name%", this.wolfyUtilities.getPlugin().getDescription().getName());
            this.inventory = guiWindow.getInventoryType() == null ? Bukkit.createInventory(null, (int)guiWindow.getSize(), (String)guiName) : Bukkit.createInventory(null, (InventoryType)guiWindow.getInventoryType(), (String)guiName);
        } else {
            this.inventory = guiWindow.getInventory(guiHandler);
        }
    }

    public boolean verify(GuiWindow guiWindow) {
        return guiWindow.equals(this.guiWindow);
    }

    public GuiHandler getGuiHandler() {
        return this.guiHandler;
    }

    public Player getPlayer() {
        return this.player;
    }

    public WolfyUtilities getWolfyUtilities() {
        return this.wolfyUtilities;
    }

    public GuiWindow getGuiWindow() {
        return this.guiWindow;
    }

    public InventoryAPI getInventoryAPI() {
        return this.inventoryAPI;
    }

    public ItemStack getItem(int slot) {
        return this.getInventory().getItem(slot);
    }

    public void setItem(int slot, ItemStack itemStack) {
        this.getInventory().setItem(slot, itemStack);
    }

    public void setButton(int slot, String id) {
        Button button = this.guiWindow.getButton(id);
        if (button != null) {
            this.guiHandler.setButton(this.guiWindow, slot, id);
            button.render(this.guiHandler, this.player, this.inventory, slot, this.guiHandler.isHelpEnabled());
        }
    }

    public void setLocalOrGlobalButton(int slot, String id) {
        Button button = this.guiWindow.getButton(id);
        if (button == null) {
            button = this.inventoryAPI.getButton(this.guiWindow.getClusterID(), id);
        }
        if (button != null) {
            this.guiHandler.setButton(this.guiWindow, slot, id);
            button.render(this.guiHandler, this.player, this.inventory, slot, this.guiHandler.isHelpEnabled());
        }
    }

    public void setButton(int slot, @Nonnull Button button) {
        if (button != null) {
            this.guiHandler.setButton(this.guiWindow, slot, button.getId());
            button.render(this.guiHandler, this.player, this.inventory, slot, this.guiHandler.isHelpEnabled());
        }
    }

    public void setButton(int slot, String namespace, String key) {
        Button button = this.inventoryAPI.getButton(namespace, key);
        if (button != null) {
            this.guiHandler.setButton(this.guiWindow, slot, namespace + ":" + key);
            button.render(this.guiHandler, this.player, this.inventory, slot, this.guiHandler.isHelpEnabled());
        }
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    public Inventory createInventory(InventoryHolder owner, int size) {
        return Bukkit.createInventory((InventoryHolder)owner, (int)size, (String)this.guiWindow.getInventoryName());
    }

    public Inventory createInventory(InventoryHolder owner, InventoryType type) {
        return Bukkit.createInventory((InventoryHolder)owner, (InventoryType)type, (String)this.guiWindow.getInventoryName());
    }

    public HandlerList getHandlers() {
        return handlers;
    }

    public static HandlerList getHandlerList() {
        return handlers;
    }
}

