/*
 * Decompiled with CFR 0.152.
 */
package me.wolfyscript.utilities.api.custom_items;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import me.wolfyscript.utilities.api.WolfyUtilities;
import me.wolfyscript.utilities.api.custom_items.CustomItems;
import me.wolfyscript.utilities.api.custom_items.ItemConfig;
import me.wolfyscript.utilities.api.custom_items.MetaSettings;
import me.wolfyscript.utilities.api.custom_items.ParticleContent;
import me.wolfyscript.utilities.api.custom_items.custom_data.CustomData;
import me.wolfyscript.utilities.api.utils.InventoryUtils;
import me.wolfyscript.utilities.api.utils.ItemUtils;
import me.wolfyscript.utilities.main.Main;
import org.apache.commons.lang.WordUtils;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class CustomItem
extends ItemStack
implements Cloneable {
    private static HashMap<String, CustomData> availableCustomData = new HashMap();
    private HashMap<String, CustomData> customDataMap = new HashMap();
    private ItemConfig config;
    private String id;
    private String permission;
    private double rarityPercentage;
    private int burnTime;
    private ArrayList<Material> allowedBlocks;
    private boolean consumed;
    private CustomItem replacement;
    private int durabilityCost;
    private MetaSettings metaSettings;
    private boolean blockVanillaEquip;
    private List<EquipmentSlot> equipmentSlots;
    private ParticleContent particleContent;

    public CustomItem(ItemConfig config, boolean replace) {
        super(config.getCustomItem(replace));
        this.config = config;
        this.id = config.getId();
        this.burnTime = config.getBurnTime();
        this.allowedBlocks = config.getAllowedBlocks();
        this.replacement = config.getReplacementItem();
        this.durabilityCost = config.getDurabilityCost();
        this.consumed = config.isConsumed();
        this.metaSettings = config.getMetaSettings();
        this.permission = config.getPermission();
        this.rarityPercentage = config.getRarityPercentage();
        this.customDataMap = config.getCustomData();
        this.equipmentSlots = config.getEquipmentSlots();
        this.particleContent = config.getParticleData();
        this.blockVanillaEquip = false;
    }

    public CustomItem(ItemConfig config) {
        this(config, false);
    }

    public CustomItem(ItemStack itemStack) {
        super(itemStack);
        this.config = null;
        this.id = "";
        this.burnTime = 0;
        this.allowedBlocks = new ArrayList();
        this.replacement = null;
        this.durabilityCost = 0;
        this.consumed = true;
        this.metaSettings = new MetaSettings();
        this.permission = "";
        this.rarityPercentage = 1.0;
        for (CustomData customData : CustomItem.getAvailableCustomData().values()) {
            this.customDataMap.put(customData.getId(), customData.getDefaultCopy());
        }
        this.equipmentSlots = new ArrayList<EquipmentSlot>();
        this.particleContent = new ParticleContent();
        this.blockVanillaEquip = false;
    }

    public CustomItem(Material material) {
        this(new ItemStack(material));
    }

    public String getId() {
        return this.id;
    }

    public boolean hasReplacement() {
        return this.replacement != null && !this.replacement.getType().equals((Object)Material.AIR);
    }

    @Nullable
    public CustomItem getReplacement() {
        return this.hasReplacement() ? this.replacement.getRealItem() : null;
    }

    public void setReplacement(@Nullable CustomItem replacement) {
        this.replacement = replacement;
    }

    public int getDurabilityCost() {
        return this.durabilityCost;
    }

    public void setDurabilityCost(int durabilityCost) {
        this.durabilityCost = durabilityCost;
    }

    public boolean isConsumed() {
        return this.consumed;
    }

    public void setConsumed(boolean consumed) {
        this.consumed = consumed;
    }

    public MetaSettings getMetaSettings() {
        return this.metaSettings;
    }

    public void setMetaSettings(MetaSettings metaSettings) {
        this.metaSettings = metaSettings;
    }

    public boolean hasID() {
        return !this.id.isEmpty();
    }

    public boolean hasConfig() {
        return this.config != null;
    }

    public ItemConfig getConfig() {
        return this.config;
    }

    public ItemStack getIDItem(int amount) {
        if (this.getType().equals((Object)Material.AIR)) {
            return new ItemStack(Material.AIR);
        }
        ItemStack idItem = new ItemStack((ItemStack)this.clone());
        if (!this.id.isEmpty()) {
            ItemMeta idItemMeta = idItem.getItemMeta();
            if (idItemMeta.hasDisplayName() && !WolfyUtilities.unhideString(idItemMeta.getDisplayName()).endsWith(":id_item")) {
                idItemMeta.setDisplayName(idItemMeta.getDisplayName() + WolfyUtilities.hideString(":id_item"));
            } else {
                idItemMeta.setDisplayName(WolfyUtilities.hideString("%NO_NAME%") + "\u00a7r" + WordUtils.capitalizeFully((String)idItem.getType().name().replace("_", " ")) + WolfyUtilities.hideString(":id_item"));
            }
            List lore = idItemMeta.hasLore() ? idItemMeta.getLore() : new ArrayList();
            lore.add("");
            lore.add("\u00a77[\u00a73\u00a7lID_ITEM\u00a7r\u00a77]");
            lore.add("\u00a73" + this.id);
            idItemMeta.setLore(lore);
            idItem.setItemMeta(idItemMeta);
        }
        idItem.setAmount(amount);
        return idItem;
    }

    public ItemStack getIDItem() {
        return this.getIDItem(this.getAmount());
    }

    public int getBurnTime() {
        return this.burnTime;
    }

    public void setBurnTime(int burnTime) {
        this.burnTime = burnTime;
    }

    public ArrayList<Material> getAllowedBlocks() {
        return this.allowedBlocks;
    }

    public List<EquipmentSlot> getEquipmentSlots() {
        return this.equipmentSlots;
    }

    public boolean hasEquipmentSlot() {
        return !this.getEquipmentSlots().isEmpty();
    }

    public boolean hasEquipmentSlot(EquipmentSlot slot) {
        return this.hasEquipmentSlot() && this.getEquipmentSlots().contains(slot);
    }

    public boolean isBlockVanillaEquip() {
        return this.blockVanillaEquip;
    }

    public void setBlockVanillaEquip(boolean blockVanillaEquip) {
        this.blockVanillaEquip = blockVanillaEquip;
    }

    public void addEquipmentSlots(EquipmentSlot ... slots) {
        for (EquipmentSlot slot : slots) {
            if (this.equipmentSlots.contains(slot)) continue;
            this.equipmentSlots.add(slot);
        }
    }

    public void removeEquipmentSlots(EquipmentSlot ... slots) {
        this.equipmentSlots.removeAll(Arrays.asList(slots));
    }

    public boolean isSimilar(ItemStack stack) {
        return this.isSimilar(stack, true);
    }

    public boolean isSimilar(ItemStack stack, boolean exactMeta) {
        if (stack == null) {
            return false;
        }
        if (stack == this) {
            return true;
        }
        if (stack.getType().equals((Object)this.getType()) && stack.getAmount() >= this.getAmount()) {
            if (exactMeta || this.hasItemMeta()) {
                if (this.hasItemMeta() && !stack.hasItemMeta()) {
                    return false;
                }
                if (!this.hasItemMeta() && stack.hasItemMeta()) {
                    return false;
                }
                ItemMeta stackMeta = stack.getItemMeta();
                ItemMeta currentMeta = this.getItemMeta();
                if (!this.getMetaSettings().checkMeta(stackMeta, currentMeta)) {
                    return false;
                }
                return stackMeta.equals(currentMeta) || currentMeta.equals(stackMeta);
            }
            return true;
        }
        return false;
    }

    public CustomItem clone() {
        CustomItem customItem = this.hasConfig() ? new CustomItem(this.getConfig()) : new CustomItem(this);
        customItem.setAmount(this.getAmount());
        return customItem;
    }

    @Deprecated
    public ItemStack getAsItemStack() {
        return super.clone();
    }

    public ItemStack getItemStack() {
        return this.getRealItem();
    }

    public CustomItem getRealItem() {
        if (this.hasConfig()) {
            CustomItem customItem = new CustomItem(this.config, true);
            if (customItem.getType().equals((Object)this.getType())) {
                customItem.setAmount(this.getAmount());
            }
            ItemMeta itemMeta = customItem.getItemMeta();
            if (WolfyUtilities.hasVillagePillageUpdate()) {
                itemMeta.getPersistentDataContainer().set(new NamespacedKey((Plugin)Main.getInstance(), "custom_item"), PersistentDataType.STRING, (Object)customItem.getId());
            } else {
                ItemUtils.setToItemSettings(itemMeta, "custom_item", (Object)customItem.getId());
            }
            customItem.setItemMeta(itemMeta);
            return customItem;
        }
        return this.clone();
    }

    public static CustomItem getByItemStack(ItemStack itemStack) {
        if (itemStack != null) {
            ItemMeta itemMeta = itemStack.getItemMeta();
            if (itemMeta != null) {
                CustomItem customItem = null;
                if (WolfyUtilities.hasVillagePillageUpdate()) {
                    if (itemMeta.getPersistentDataContainer().has(new NamespacedKey((Plugin)Main.getInstance(), "custom_item"), PersistentDataType.STRING)) {
                        customItem = CustomItems.getCustomItem((String)itemMeta.getPersistentDataContainer().get(new NamespacedKey((Plugin)Main.getInstance(), "custom_item"), PersistentDataType.STRING));
                    }
                } else if (ItemUtils.isInItemSettings(itemMeta, "custom_item")) {
                    customItem = CustomItems.getCustomItem((String)ItemUtils.getFromItemSettings(itemMeta, "custom_item"));
                }
                if (customItem != null) {
                    customItem.setAmount(itemStack.getAmount());
                    return customItem;
                }
                return new CustomItem(itemStack);
            }
            return new CustomItem(itemStack);
        }
        return null;
    }

    private static boolean isIDItem(ItemStack itemStack) {
        if (itemStack.hasItemMeta() && itemStack.getItemMeta().hasDisplayName()) {
            String name = WolfyUtilities.unhideString(itemStack.getItemMeta().getDisplayName());
            return name.endsWith(":id_item");
        }
        return false;
    }

    public void consumeItem(ItemStack input, int totalAmount, Inventory inventory, Location location) {
        if (this.getMaxStackSize() > 1) {
            int amount = input.getAmount() - this.getAmount() * totalAmount;
            if (this.isConsumed()) {
                input.setAmount(amount);
            }
            if (this.hasReplacement()) {
                CustomItem replacement = this.getReplacement();
                replacement.setAmount(replacement.getAmount() * totalAmount);
                if (location == null) {
                    if (InventoryUtils.hasInventorySpace(inventory, (ItemStack)replacement)) {
                        inventory.addItem(new ItemStack[]{replacement});
                    } else {
                        inventory.getLocation().getWorld().dropItemNaturally(inventory.getLocation().add(0.5, 1.0, 0.5), (ItemStack)replacement);
                    }
                } else {
                    location.getWorld().dropItemNaturally(location.add(0.5, 1.0, 0.5), (ItemStack)replacement);
                }
            }
        } else {
            this.consumeUnstackableItem(input);
        }
    }

    public void consumeItem(ItemStack input, int totalAmount, Inventory inventory) {
        this.consumeItem(input, totalAmount, inventory, null);
    }

    public ItemStack consumeItem(ItemStack input, int totalAmount, Location location) {
        this.consumeItem(input, totalAmount, null, location);
        return input;
    }

    public void consumeUnstackableItem(ItemStack input) {
        if (this.hasConfig()) {
            if (this.isConsumed()) {
                input.setAmount(0);
            } else {
                switch (input.getType()) {
                    case LAVA_BUCKET: 
                    case MILK_BUCKET: 
                    case WATER_BUCKET: 
                    case COD_BUCKET: 
                    case SALMON_BUCKET: 
                    case PUFFERFISH_BUCKET: 
                    case TROPICAL_FISH_BUCKET: {
                        input.setType(Material.BUCKET);
                        break;
                    }
                    case POTION: {
                        input.setType(Material.GLASS_BOTTLE);
                        break;
                    }
                    case BEETROOT_SOUP: 
                    case MUSHROOM_STEW: 
                    case RABBIT_STEW: {
                        input.setType(Material.BOWL);
                    }
                }
                if (WolfyUtilities.hasBuzzyBeesUpdate() && input.getType().equals((Object)Material.HONEY_BOTTLE)) {
                    input.setType(Material.GLASS_BOTTLE);
                }
            }
            if (this.hasReplacement()) {
                CustomItem replace = this.getReplacement();
                input.setType(replace.getType());
                input.setItemMeta(replace.getItemMeta());
                input.setData(replace.getData());
                input.setAmount(replace.getAmount());
                return;
            }
            if (this.getDurabilityCost() != 0) {
                ItemMeta itemMeta;
                if (WolfyUtilities.hasVillagePillageUpdate()) {
                    if (CustomItem.hasCustomDurability(input)) {
                        CustomItem.setCustomDamage(input, CustomItem.getCustomDamage(input) + this.getDurabilityCost());
                        return;
                    }
                } else if (ItemUtils.hasCustomDurability(input)) {
                    ItemUtils.setDamage(input, ItemUtils.getDamage(input) + this.getDurabilityCost());
                    return;
                }
                if ((itemMeta = input.getItemMeta()) instanceof Damageable) {
                    int damage = ((Damageable)itemMeta).getDamage() + this.getDurabilityCost();
                    if (damage > this.getType().getMaxDurability()) {
                        input.setAmount(0);
                    } else {
                        ((Damageable)itemMeta).setDamage(damage);
                    }
                }
                input.setItemMeta(itemMeta);
            }
        } else {
            switch (input.getType()) {
                case LAVA_BUCKET: 
                case MILK_BUCKET: 
                case WATER_BUCKET: 
                case COD_BUCKET: 
                case SALMON_BUCKET: 
                case PUFFERFISH_BUCKET: 
                case TROPICAL_FISH_BUCKET: {
                    input.setType(Material.BUCKET);
                    return;
                }
                case POTION: {
                    input.setType(Material.GLASS_BOTTLE);
                    return;
                }
                case BEETROOT_SOUP: 
                case MUSHROOM_STEW: 
                case RABBIT_STEW: {
                    input.setType(Material.BOWL);
                    return;
                }
            }
            if (WolfyUtilities.hasBuzzyBeesUpdate() && input.getType().equals((Object)Material.HONEY_BOTTLE)) {
                input.setType(Material.GLASS_BOTTLE);
                return;
            }
            input.setAmount(0);
        }
    }

    public boolean hasPermission() {
        return !this.permission.isEmpty();
    }

    public String getPermission() {
        return this.permission;
    }

    public void setPermission(String permission) {
        this.permission = permission;
    }

    public double getRarityPercentage() {
        return this.rarityPercentage;
    }

    public void setRarityPercentage(double rarityPercentage) {
        this.rarityPercentage = rarityPercentage;
    }

    public CustomData getCustomData(String id) {
        return this.customDataMap.get(id);
    }

    public HashMap<String, CustomData> getCustomDataMap() {
        return this.customDataMap;
    }

    public void addCustomData(String id, CustomData customData) {
        this.customDataMap.put(id, customData);
    }

    public static HashMap<String, CustomData> getAvailableCustomData() {
        return availableCustomData;
    }

    public static void registerCustomData(CustomData customData) {
        availableCustomData.put(customData.getId(), customData);
    }

    public static boolean hasCustomDurability(ItemStack itemStack) {
        return CustomItem.hasCustomDurability(itemStack.getItemMeta());
    }

    public static boolean hasCustomDurability(ItemMeta itemMeta) {
        if (itemMeta != null) {
            PersistentDataContainer dataContainer = itemMeta.getPersistentDataContainer();
            return dataContainer.has(new NamespacedKey((Plugin)Main.getInstance(), "customDurability.value"), PersistentDataType.INTEGER);
        }
        return false;
    }

    public static void setCustomDurability(ItemStack itemStack, int durability) {
        ItemMeta itemMeta = itemStack.getItemMeta();
        if (itemMeta != null) {
            CustomItem.setCustomDurability(itemMeta, durability);
        }
        itemStack.setItemMeta(itemMeta);
    }

    public static void setCustomDurability(ItemMeta itemMeta, int durability) {
        if (itemMeta != null) {
            PersistentDataContainer dataContainer = itemMeta.getPersistentDataContainer();
            dataContainer.set(new NamespacedKey((Plugin)Main.getInstance(), "customDurability.value"), PersistentDataType.INTEGER, (Object)durability);
            if (!dataContainer.has(new NamespacedKey((Plugin)Main.getInstance(), "customDurability.damage"), PersistentDataType.INTEGER)) {
                dataContainer.set(new NamespacedKey((Plugin)Main.getInstance(), "customDurability.damage"), PersistentDataType.INTEGER, (Object)0);
            }
            CustomItem.setDurabilityTag(itemMeta);
        }
    }

    public static void removeCustomDurability(ItemStack itemStack) {
        ItemMeta itemMeta = itemStack.getItemMeta();
        CustomItem.removeCustomDurability(itemMeta);
        itemStack.setItemMeta(itemMeta);
    }

    public static void removeCustomDurability(ItemMeta itemMeta) {
        if (itemMeta != null) {
            PersistentDataContainer dataContainer = itemMeta.getPersistentDataContainer();
            dataContainer.remove(new NamespacedKey((Plugin)Main.getInstance(), "customDurability.value"));
            dataContainer.remove(new NamespacedKey((Plugin)Main.getInstance(), "customDurability.damage"));
            dataContainer.remove(new NamespacedKey((Plugin)Main.getInstance(), "customDurability.tag"));
        }
    }

    public static int getCustomDurability(ItemStack itemStack) {
        return CustomItem.getCustomDurability(itemStack.getItemMeta());
    }

    public static int getCustomDurability(ItemMeta itemMeta) {
        PersistentDataContainer dataContainer;
        if (itemMeta != null && (dataContainer = itemMeta.getPersistentDataContainer()).has(new NamespacedKey((Plugin)Main.getInstance(), "customDurability.value"), PersistentDataType.INTEGER)) {
            return (Integer)dataContainer.get(new NamespacedKey((Plugin)Main.getInstance(), "customDurability.value"), PersistentDataType.INTEGER);
        }
        return 0;
    }

    public static void setCustomDamage(ItemStack itemStack, int damage) {
        ItemMeta itemMeta = itemStack.getItemMeta();
        CustomItem.setCustomDamage(itemMeta, damage);
        if (itemMeta instanceof Damageable) {
            ((Damageable)itemMeta).setDamage((int)((double)itemStack.getType().getMaxDurability() * ((double)damage / (double)CustomItem.getCustomDurability(itemStack))));
        }
        itemStack.setItemMeta(itemMeta);
    }

    public static void setCustomDamage(ItemMeta itemMeta, int damage) {
        if (itemMeta != null) {
            PersistentDataContainer dataContainer = itemMeta.getPersistentDataContainer();
            dataContainer.set(new NamespacedKey((Plugin)Main.getInstance(), "customDurability.damage"), PersistentDataType.INTEGER, (Object)damage);
            CustomItem.setDurabilityTag(itemMeta);
        }
    }

    public static int getCustomDamage(ItemStack itemStack) {
        return CustomItem.getCustomDamage(itemStack.getItemMeta());
    }

    public static int getCustomDamage(ItemMeta itemMeta) {
        PersistentDataContainer dataContainer;
        if (itemMeta != null && (dataContainer = itemMeta.getPersistentDataContainer()).has(new NamespacedKey((Plugin)Main.getInstance(), "customDurability.damage"), PersistentDataType.INTEGER)) {
            return (Integer)dataContainer.get(new NamespacedKey((Plugin)Main.getInstance(), "customDurability.damage"), PersistentDataType.INTEGER);
        }
        return 0;
    }

    public static void setCustomDurabilityTag(ItemStack itemStack, String tag) {
        ItemMeta itemMeta = itemStack.getItemMeta();
        CustomItem.setCustomDurabilityTag(itemMeta, tag);
        itemStack.setItemMeta(itemMeta);
    }

    public static void setCustomDurabilityTag(ItemMeta itemMeta, String tag) {
        if (itemMeta != null) {
            PersistentDataContainer dataContainer = itemMeta.getPersistentDataContainer();
            dataContainer.set(new NamespacedKey((Plugin)Main.getInstance(), "customDurability.tag"), PersistentDataType.STRING, (Object)tag);
            CustomItem.setDurabilityTag(itemMeta);
        }
    }

    public static String getCustomDurabilityTag(ItemStack itemStack) {
        return CustomItem.getCustomDurabilityTag(itemStack.getItemMeta());
    }

    public static String getCustomDurabilityTag(ItemMeta itemMeta) {
        PersistentDataContainer dataContainer;
        if (itemMeta != null && (dataContainer = itemMeta.getPersistentDataContainer()).has(new NamespacedKey((Plugin)Main.getInstance(), "customDurability.tag"), PersistentDataType.STRING)) {
            return (String)dataContainer.get(new NamespacedKey((Plugin)Main.getInstance(), "customDurability.tag"), PersistentDataType.STRING);
        }
        return "";
    }

    public static void setDurabilityTag(ItemStack itemStack) {
        ItemMeta itemMeta = itemStack.getItemMeta();
        CustomItem.setDurabilityTag(itemMeta);
        itemStack.setItemMeta(itemMeta);
    }

    public static void setDurabilityTag(ItemMeta itemMeta) {
        if (itemMeta != null) {
            String tag = WolfyUtilities.hideString("WU_Durability") + WolfyUtilities.translateColorCodes(CustomItem.getCustomDurabilityTag(itemMeta).replace("%dur%", String.valueOf(CustomItem.getCustomDurability(itemMeta) - CustomItem.getCustomDamage(itemMeta))).replace("%max_dur%", String.valueOf(CustomItem.getCustomDurability(itemMeta))));
            List lore = itemMeta.getLore() != null ? itemMeta.getLore() : new ArrayList();
            for (int i = 0; i < lore.size(); ++i) {
                String line = WolfyUtilities.unhideString((String)lore.get(i));
                if (!line.startsWith("WU_Durability")) continue;
                lore.set(i, tag);
                itemMeta.setLore(lore);
                return;
            }
            lore.add(tag);
            itemMeta.setLore(lore);
        }
    }

    public ParticleContent getParticleContent() {
        return this.particleContent;
    }

    public void setParticleContent(ParticleContent particleContent) {
        this.particleContent = particleContent;
    }
}

