/*
 * Decompiled with CFR 0.152.
 */
package me.wolfyscript.utilities.api.config.serialization;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import me.wolfyscript.utilities.api.utils.ItemUtils;
import org.bukkit.inventory.ItemStack;

public class ItemStackSerialization
implements JsonSerializer<ItemStack>,
JsonDeserializer<ItemStack> {
    public ItemStack deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
        if (jsonElement instanceof JsonPrimitive) {
            String value = jsonElement.getAsString();
            if (!value.startsWith("{")) {
                return ItemUtils.deserializeItemStack(jsonElement.getAsString());
            }
            if (value == null || value.equals("empty")) {
                return null;
            }
            return ItemUtils.convertJsontoItemStack(value);
        }
        return null;
    }

    public JsonElement serialize(ItemStack itemStack, Type type, JsonSerializationContext jsonSerializationContext) {
        if (itemStack != null) {
            return new JsonPrimitive(ItemUtils.convertItemStackToJson(itemStack));
        }
        return null;
    }
}

