/*
 * Decompiled with CFR 0.152.
 */
package me.wolfyscript.utilities.main.listeners;

import me.wolfyscript.utilities.api.WolfyUtilities;
import me.wolfyscript.utilities.api.custom_items.CustomItem;
import me.wolfyscript.utilities.api.custom_items.CustomItemBreakEvent;
import me.wolfyscript.utilities.api.custom_items.CustomItemPlaceEvent;
import me.wolfyscript.utilities.api.custom_items.CustomItems;
import me.wolfyscript.utilities.api.utils.ItemUtils;
import me.wolfyscript.utilities.main.Main;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.data.Bisected;
import org.bukkit.block.data.type.Bed;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockFadeEvent;
import org.bukkit.event.block.BlockMultiPlaceEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class BlockListener
implements Listener {
    @EventHandler(priority=EventPriority.HIGH)
    public void onBlockBreak(BlockBreakEvent event) {
        Block block;
        CustomItem storedItem;
        if (!event.isCancelled() && (storedItem = CustomItems.getStoredBlockItem((block = event.getBlock()).getLocation())) != null) {
            event.setDropItems(false);
            CustomItemBreakEvent event1 = new CustomItemBreakEvent(storedItem, event);
            Bukkit.getPluginManager().callEvent((Event)event1);
            event.setCancelled(event1.isCancelled());
            event.setDropItems(event1.isDropItems());
            storedItem = event1.getCustomItem();
            if (!event1.isCancelled() && storedItem != null) {
                if (!event.getPlayer().getGameMode().equals((Object)GameMode.CREATIVE)) {
                    block.getWorld().dropItemNaturally(block.getLocation(), (ItemStack)storedItem);
                }
                CustomItems.removeStoredBlockItem(block.getLocation());
                if (block.getBlockData() instanceof Bisected) {
                    if (((Bisected)block.getBlockData()).getHalf().equals((Object)Bisected.Half.BOTTOM)) {
                        CustomItems.removeStoredBlockItem(block.getLocation().add(0.0, 1.0, 0.0));
                    } else {
                        CustomItems.removeStoredBlockItem(block.getLocation().subtract(0.0, 1.0, 0.0));
                    }
                } else if (block.getBlockData() instanceof Bed) {
                    Bed bed = (Bed)block.getBlockData();
                    CustomItems.removeStoredBlockItem(block.getLocation().add(bed.getFacing().getDirection()));
                }
            }
        }
    }

    @EventHandler
    public void onBlockFade(BlockFadeEvent event) {
        Block block;
        CustomItem storedItem;
        if (!event.isCancelled() && event.getNewState().getType().equals((Object)Material.AIR) && (storedItem = CustomItems.getStoredBlockItem((block = event.getBlock()).getLocation())) != null) {
            CustomItems.removeStoredBlockItem(block.getLocation());
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onBlockPlace(BlockPlaceEvent event) {
        String customItemID;
        if (!event.isCancelled() && (customItemID = this.getCustomItemID(event.getItemInHand())) != null && !customItemID.isEmpty()) {
            CustomItem customItem = CustomItems.getCustomItem(customItemID);
            CustomItemPlaceEvent event1 = new CustomItemPlaceEvent(customItem, event);
            Bukkit.getPluginManager().callEvent((Event)event1);
            customItem = event1.getCustomItem();
            if (!event1.isCancelled()) {
                if (customItem != null) {
                    CustomItems.setStoredBlockItem(event.getBlockPlaced().getLocation(), customItem);
                }
            } else {
                event.setCancelled(true);
            }
        }
    }

    private String getCustomItemID(ItemStack itemStack) {
        ItemMeta itemMeta = itemStack.getItemMeta();
        if (WolfyUtilities.hasVillagePillageUpdate()) {
            if (itemMeta.getPersistentDataContainer().has(new NamespacedKey((Plugin)Main.getInstance(), "custom_item"), PersistentDataType.STRING)) {
                return (String)itemMeta.getPersistentDataContainer().get(new NamespacedKey((Plugin)Main.getInstance(), "custom_item"), PersistentDataType.STRING);
            }
        } else if (ItemUtils.isInItemSettings(itemMeta, "custom_item")) {
            return (String)ItemUtils.getFromItemSettings(itemMeta, "custom_item");
        }
        return "";
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onBlockPlaceMulti(BlockMultiPlaceEvent event) {
        String customItemID;
        if (!event.isCancelled() && (customItemID = this.getCustomItemID(event.getItemInHand())) != null && !customItemID.isEmpty()) {
            CustomItem customItem = CustomItems.getCustomItem(customItemID);
            for (BlockState state : event.getReplacedBlockStates()) {
                CustomItems.setStoredBlockItem(state.getLocation(), customItem);
            }
        }
    }
}

