/*
 * Decompiled with CFR 0.152.
 */
package me.wolfyscript.utilities.api.inventory.button;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.wolfyscript.utilities.api.WolfyUtilities;
import me.wolfyscript.utilities.api.inventory.GuiHandler;
import me.wolfyscript.utilities.api.inventory.GuiWindow;
import me.wolfyscript.utilities.api.inventory.button.ButtonActionRender;
import me.wolfyscript.utilities.api.inventory.button.ButtonState;
import me.wolfyscript.utilities.api.inventory.button.ButtonType;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public abstract class Button {
    private String id;
    private ButtonType type;

    public Button(String id, ButtonType type) {
        this.id = id;
        this.type = type;
    }

    public Button(String id) {
        this(id, ButtonType.NORMAL);
    }

    public abstract void init(GuiWindow var1);

    public abstract void init(String var1, WolfyUtilities var2);

    public abstract boolean execute(GuiHandler var1, Player var2, Inventory var3, int var4, InventoryClickEvent var5);

    public abstract void render(GuiHandler var1, Player var2, Inventory var3, int var4, boolean var5);

    public ButtonType getType() {
        return this.type;
    }

    public String getId() {
        return this.id;
    }

    protected void applyItem(GuiHandler guiHandler, Player player, Inventory inventory, ButtonState state, int slot, boolean help) {
        ItemStack item = state.getIcon(help);
        HashMap<String, Object> values = new HashMap<String, Object>();
        values.put("%wolfyutilities.help%", guiHandler.getCurrentInv().getHelpInformation());
        values.put("%plugin.version%", guiHandler.getApi().getPlugin().getDescription().getVersion());
        if (state.getAction() instanceof ButtonActionRender) {
            item = ((ButtonActionRender)state.getAction()).render(values, guiHandler, player, item, slot, help);
        } else if (state.getRenderAction() != null) {
            item = state.getRenderAction().render(values, guiHandler, player, item, slot, help);
        }
        inventory.setItem(slot, this.replaceKeysWithValue(item, values));
    }

    protected ItemStack replaceKeysWithValue(ItemStack itemStack, HashMap<String, Object> values) {
        ItemMeta meta;
        if (itemStack != null && (meta = itemStack.getItemMeta()) != null && meta.hasDisplayName()) {
            String name = meta.getDisplayName();
            List lore = meta.getLore();
            for (Map.Entry<String, Object> entry : values.entrySet()) {
                if (entry.getValue() instanceof List) {
                    List list = (List)entry.getValue();
                    if (!meta.hasLore()) continue;
                    for (int i = 0; i < lore.size(); ++i) {
                        if (!((String)lore.get(i)).contains(entry.getKey())) continue;
                        if (list.size() > 0) {
                            lore.set(i, ((String)lore.get(i)).replace(entry.getKey(), WolfyUtilities.translateColorCodes(String.valueOf(list.get(list.size() - 1)))));
                        } else {
                            lore.set(i, "");
                        }
                        if (list.size() <= 1) continue;
                        for (int j = list.size() - 2; j >= 0; --j) {
                            lore.add(i, WolfyUtilities.translateColorCodes(String.valueOf(list.get(j))));
                        }
                    }
                    continue;
                }
                if (entry.getValue() == null) continue;
                name = name.replace(entry.getKey(), WolfyUtilities.translateColorCodes(String.valueOf(entry.getValue())));
                if (!meta.hasLore()) continue;
                for (int i = 0; i < lore.size(); ++i) {
                    lore.set(i, ((String)lore.get(i)).replace(entry.getKey(), WolfyUtilities.translateColorCodes(String.valueOf(entry.getValue()))));
                }
            }
            meta.setDisplayName(name);
            meta.setLore(lore);
            itemStack.setItemMeta(meta);
        }
        return itemStack;
    }
}

