/*
 * Decompiled with CFR 0.152.
 */
package me.wolfyscript.utilities.api.config.serialization;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;
import me.wolfyscript.utilities.api.WolfyUtilities;
import me.wolfyscript.utilities.api.utils.NamespacedKey;
import me.wolfyscript.utilities.api.utils.particles.Particle;
import me.wolfyscript.utilities.api.utils.particles.Particles;
import org.bukkit.Material;

public class ParticleSerialization
implements JsonSerializer<Particle>,
JsonDeserializer<Particle> {
    public Particle deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
        if (jsonElement instanceof JsonObject) {
            JsonObject relative;
            JsonObject object = (JsonObject)jsonElement;
            Particle resultParticle = new Particle();
            if (object.has("particle")) {
                String particle = object.getAsJsonPrimitive("particle").getAsString();
                NamespacedKey namespacedKey = null;
                namespacedKey = particle.contains(":") && particle.split(":").length > 1 ? new NamespacedKey(particle.split(":")[0].toLowerCase(Locale.ROOT).replace(" ", "_"), particle.split(":")[1].toLowerCase(Locale.ROOT).replace(" ", "_")) : new NamespacedKey("wolfyutilities", particle);
                if (namespacedKey.getNamespace().equalsIgnoreCase("minecraft")) {
                    Iterator particleType = org.bukkit.Particle.valueOf((String)namespacedKey.getKey().toUpperCase(Locale.ROOT));
                    resultParticle.setParticle((org.bukkit.Particle)particleType);
                } else {
                    resultParticle = new Particle(Particles.getParticles().get(namespacedKey));
                    resultParticle.setSuperParticle(Particles.getParticles().get(namespacedKey));
                }
                resultParticle.setNamespacedKey(namespacedKey);
            }
            if (object.has("icon")) {
                resultParticle.setIcon(Material.matchMaterial((String)object.get("icon").getAsString()));
            }
            if (object.has("name")) {
                resultParticle.setName(WolfyUtilities.translateColorCodes(object.get("name").getAsString()));
            }
            if (object.has("description")) {
                ArrayList<String> description = new ArrayList<String>();
                JsonArray lore = object.getAsJsonArray("description");
                for (JsonElement line : lore) {
                    description.add(WolfyUtilities.translateColorCodes(line.getAsString()));
                }
                resultParticle.setDescription(description);
            }
            if (object.has("count")) {
                resultParticle.setCount(object.getAsJsonPrimitive("count").getAsInt());
            }
            if (object.has("extra")) {
                resultParticle.setExtra(object.getAsJsonPrimitive("extra").getAsDouble());
            }
            if (object.has("relative")) {
                relative = object.getAsJsonObject("relative");
                resultParticle.setRelativeX(relative.get("x").getAsDouble());
                resultParticle.setRelativeY(relative.get("y").getAsDouble());
                resultParticle.setRelativeZ(relative.get("z").getAsDouble());
            }
            if (object.has("offset")) {
                relative = object.getAsJsonObject("offset");
                resultParticle.setOffsetX(relative.get("x").getAsDouble());
                resultParticle.setOffsetY(relative.get("y").getAsDouble());
                resultParticle.setOffsetZ(relative.get("z").getAsDouble());
            }
            if (object.has("scripts")) {
                JsonArray jsonArray = object.getAsJsonArray("scripts");
                for (JsonElement element : jsonArray) {
                    if (!(element instanceof JsonPrimitive)) continue;
                    resultParticle.addScript(element.getAsString());
                }
            }
            return resultParticle;
        }
        return null;
    }

    public JsonElement serialize(Particle particle, Type type, JsonSerializationContext jsonSerializationContext) {
        JsonObject particleObject = new JsonObject();
        if (particle.hasSuperParticle()) {
            particleObject.addProperty("particle", particle.getSuperParticle().getNamespacedKey().toString());
        } else {
            particleObject.addProperty("particle", "minecraft:" + particle.getParticle().name().toLowerCase(Locale.ROOT));
        }
        if (particle.hasIcon()) {
            particleObject.addProperty("icon", particle.getIcon().getKey().toString());
        }
        if (particle.hasName()) {
            particleObject.addProperty("name", particle.getName());
        }
        if (particle.hasDescription()) {
            JsonArray description = new JsonArray();
            for (String line : particle.getDescription()) {
                description.add(line);
            }
            particleObject.add("description", (JsonElement)description);
        }
        if (particle.hasCount()) {
            particleObject.addProperty("count", (Number)particle.getCount());
        }
        if (particle.hasExtra()) {
            particleObject.addProperty("extra", (Number)particle.getExtra());
        }
        if (particle.hasRelativeX() || particle.hasRelativeY() || particle.hasRelativeZ()) {
            JsonObject relative = new JsonObject();
            if (particle.hasRelativeX()) {
                relative.addProperty("x", (Number)particle.getRelativeX());
            }
            if (particle.hasRelativeY()) {
                relative.addProperty("y", (Number)particle.getRelativeY());
            }
            if (particle.hasRelativeZ()) {
                relative.addProperty("z", (Number)particle.getRelativeZ());
            }
            particleObject.add("relative", (JsonElement)relative);
        }
        if (particle.hasOffsetX() || particle.hasOffsetY() || particle.hasOffsetZ()) {
            JsonObject offset = new JsonObject();
            if (particle.hasOffsetX()) {
                offset.addProperty("x", (Number)particle.getOffsetX());
            }
            if (particle.hasOffsetY()) {
                offset.addProperty("y", (Number)particle.getOffsetY());
            }
            if (particle.hasOffsetZ()) {
                offset.addProperty("z", (Number)particle.getOffsetZ());
            }
            particleObject.add("offset", (JsonElement)offset);
        }
        if (particle.hasScripts()) {
            JsonArray array = new JsonArray();
            for (String script : particle.getScripts()) {
                array.add(script);
            }
            particleObject.add("scripts", (JsonElement)array);
        }
        return particleObject;
    }
}

