/*
 * Decompiled with CFR 0.152.
 */
package me.wolfyscript.utilities.api.config;

import java.io.File;
import me.wolfyscript.utilities.api.config.ConfigAPI;
import me.wolfyscript.utilities.api.config.Configuration;
import me.wolfyscript.utilities.api.config.MemoryConfiguration;

public abstract class FileConfiguration
extends MemoryConfiguration {
    protected File configFile;
    protected String defPath;
    protected String defFileName;
    protected boolean saveAfterValueSet = false;

    public FileConfiguration(ConfigAPI configAPI, String path, String name, String defPath, String defFileName, Configuration.Type type) {
        super(configAPI, name, type);
        this.defPath = defPath;
        this.defFileName = defFileName;
        if (!path.isEmpty() && !name.isEmpty()) {
            this.configFile = new File(path, name + "." + (type.equals((Object)Configuration.Type.YAML) ? "yml" : "json"));
        }
    }

    public abstract void save();

    public abstract void load();

    public abstract void reload();

    public abstract void loadDefaults();

    public abstract void onFirstInit();

    public abstract void init();

    public File getConfigFile() {
        return this.configFile;
    }

    public void setConfigFile(File configFile) {
        this.configFile = configFile;
    }

    public boolean isSaveAfterValueSet() {
        return this.saveAfterValueSet;
    }

    public void setSaveAfterValueSet(boolean saveAfterValueSet) {
        this.saveAfterValueSet = saveAfterValueSet;
    }
}

