/*
 * Decompiled with CFR 0.152.
 */
package me.wolfyscript.utilities.api.config;

import java.util.List;
import java.util.Map;
import java.util.Set;
import me.wolfyscript.utilities.api.config.ConfigAPI;
import me.wolfyscript.utilities.api.config.Configuration;
import me.wolfyscript.utilities.api.config.ConfigurationSection;
import me.wolfyscript.utilities.api.config.FileConfiguration;
import me.wolfyscript.utilities.api.config.JsonConfiguration;
import me.wolfyscript.utilities.api.config.YamlConfiguration;
import org.bukkit.inventory.ItemStack;

public class Config
extends FileConfiguration
implements ConfigurationSection {
    public FileConfiguration configuration;

    public Config(ConfigAPI configAPI, String path, String name, String defPath, String defFileName, String fileType, boolean overwrite) {
        super(configAPI, path, name, defPath, defFileName, fileType.equalsIgnoreCase("json") ? Configuration.Type.JSON : Configuration.Type.YAML);
        this.configuration = this.getType().equals((Object)Configuration.Type.JSON) ? new JsonConfiguration(configAPI, path, name, defPath, defFileName, overwrite) : new YamlConfiguration(configAPI, path, name, defPath, defFileName, overwrite);
        this.setPathSeparator('.');
    }

    public Config(ConfigAPI configAPI, String name, String defPath, String defFileName) {
        super(configAPI, "", name, defPath, defFileName, Configuration.Type.JSON);
        this.configuration = new JsonConfiguration(configAPI, name, defPath, defFileName);
    }

    public Config(String jsonData, ConfigAPI configAPI, String name, String defPath, String defFileName) {
        super(configAPI, "", name, defPath, defFileName, Configuration.Type.JSON);
        this.configuration = new JsonConfiguration(jsonData, configAPI, name, defPath, defFileName);
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean prettyPrinting) {
        if (this.getType().equals((Object)Configuration.Type.YAML)) {
            return ((YamlConfiguration)this.configuration).getBukkitConfig().saveToString();
        }
        return ((JsonConfiguration)this.configuration).toString(prettyPrinting);
    }

    @Override
    public void save() {
        this.configuration.save();
    }

    public void save(boolean prettyPrinting) {
        if (this.configuration instanceof JsonConfiguration) {
            ((JsonConfiguration)this.configuration).save(prettyPrinting);
        } else {
            this.save();
        }
    }

    @Override
    public void load() {
        this.configuration.load();
    }

    @Override
    public void reload() {
        this.configuration.reload();
    }

    public void reload(boolean prettyPrinting) {
        if (this.configuration instanceof JsonConfiguration) {
            ((JsonConfiguration)this.configuration).reload(prettyPrinting);
        } else {
            this.reload();
        }
    }

    @Override
    public void loadDefaults() {
        this.configuration.loadDefaults();
    }

    @Override
    public void onFirstInit() {
        this.configuration.onFirstInit();
    }

    @Override
    public void init() {
        this.configuration.init();
    }

    @Override
    public Set<String> getKeys() {
        return this.configuration.getKeys();
    }

    @Override
    public Set<String> getKeys(boolean deep) {
        return this.configuration.getKeys(deep);
    }

    @Override
    public Map<String, Object> getMap() {
        return this.configuration.getMap();
    }

    @Override
    public boolean hasPathSeparator() {
        return this.configuration.hasPathSeparator();
    }

    @Override
    public void setPathSeparator(char pathSeparator) {
        this.configuration.setPathSeparator(pathSeparator);
    }

    @Override
    public char getPathSeparator() {
        return this.configuration.getPathSeparator();
    }

    @Override
    public void set(String path, Object value) {
        this.configuration.set(path, value);
    }

    @Override
    public Object get(String path) {
        return this.configuration.get(path);
    }

    @Override
    public Object get(String path, Object def) {
        return this.configuration.get(path, def);
    }

    @Override
    public String getString(String path) {
        return this.configuration.getString(path);
    }

    @Override
    public String getString(String path, String def) {
        return this.configuration.getString(path, def);
    }

    @Override
    public int getInt(String path) {
        return this.configuration.getInt(path);
    }

    @Override
    public int getInt(String path, int def) {
        return this.configuration.getInt(path, def);
    }

    @Override
    public boolean getBoolean(String path) {
        return this.configuration.getBoolean(path);
    }

    @Override
    public double getDouble(String path) {
        return this.configuration.getDouble(path);
    }

    @Override
    public double getDouble(String path, double def) {
        return this.configuration.getDouble(path, def);
    }

    @Override
    public long getLong(String path) {
        return this.configuration.getLong(path);
    }

    @Override
    public long getLong(String path, long def) {
        return this.configuration.getLong(path, def);
    }

    @Override
    public List<?> getList(String path) {
        return this.configuration.getList(path);
    }

    @Override
    public List<String> getStringList(String path) {
        return this.configuration.getStringList(path);
    }

    @Override
    public void setItem(String path, ItemStack itemStack) {
        this.configuration.setItem(path, itemStack);
    }

    @Override
    public void setItem(String path, String name, ItemStack itemStack) {
        this.configuration.setItem(path, name, itemStack);
    }

    @Override
    @Deprecated
    public void saveItem(String path, ItemStack item) {
        this.configuration.saveItem(path, item);
    }

    @Override
    @Deprecated
    public void saveItem(String path, String name, ItemStack itemStack) {
        this.configuration.saveItem(path, name, itemStack);
    }

    @Override
    public ItemStack getItem(String path) {
        return this.configuration.getItem(path);
    }

    @Override
    public ItemStack getItem(String path, boolean replaceKeys) {
        return this.configuration.getItem(path, replaceKeys);
    }

    @Override
    public Map<String, Object> getValues(String path) {
        return this.configuration.getValues(path);
    }
}

