/*
 * Decompiled with CFR 0.152.
 */
package me.wolfyscript.utilities.api.utils.particles;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import me.wolfyscript.utilities.api.utils.NamespacedKey;
import me.wolfyscript.utilities.api.utils.item_builder.ItemBuilder;
import me.wolfyscript.utilities.main.Main;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;

public class Particle {
    private NamespacedKey namespacedKey;
    private Particle superParticle;
    private org.bukkit.Particle particle;
    private ItemStack iconItem;
    private Class<?> dataClass;
    private Object data;
    private double relativeX;
    private double relativeY;
    private double relativeZ;
    private double offsetX;
    private double offsetY;
    private double offsetZ;
    private int count;
    private double extra;
    private List<String> scripts = new ArrayList<String>();
    private Context context = Context.enter();
    private Scriptable scope = this.context.initSafeStandardObjects();

    public Particle(Particle preset) {
        this.particle = preset.getParticle();
        this.dataClass = this.particle.getDataType();
        this.data = this.dataClass.isInstance(preset.getData()) ? preset.getData() : null;
        this.iconItem = preset.getIconItem();
        this.relativeX = preset.getRelativeX();
        this.relativeY = preset.getRelativeY();
        this.relativeZ = preset.getRelativeZ();
        this.offsetX = preset.getOffsetX();
        this.offsetY = preset.getOffsetY();
        this.offsetZ = preset.getOffsetZ();
        this.count = preset.getCount();
        this.extra = preset.getExtra();
    }

    public Particle() {
        this(org.bukkit.Particle.BARRIER);
    }

    public Particle(org.bukkit.Particle particle) {
        this(particle, null);
    }

    public Particle(org.bukkit.Particle particle, Object data) {
        this(particle, 1, 1.0, data);
    }

    public Particle(org.bukkit.Particle particle, int count) {
        this(particle, count, 1.0, null);
    }

    public Particle(org.bukkit.Particle particle, int count, Object data) {
        this(particle, count, 1.0, data);
    }

    public Particle(org.bukkit.Particle particle, int count, double extra) {
        this(particle, count, extra, null);
    }

    public Particle(org.bukkit.Particle particle, int count, double extra, Object data) {
        this(particle, count, 0.0, 0.0, 0, extra, data);
    }

    public Particle(org.bukkit.Particle particle, double relativeX, double relativeY, double relativeZ, int count) {
        this(particle, relativeX, relativeY, relativeZ, count, 1.0, null);
    }

    public Particle(org.bukkit.Particle particle, double relativeX, double relativeY, double relativeZ, int count, double extra) {
        this(particle, relativeX, relativeY, relativeZ, count, 1.0, extra);
    }

    public Particle(org.bukkit.Particle particle, double relativeX, double relativeY, double relativeZ, int count, Object data) {
        this(particle, relativeX, relativeY, relativeZ, count, 1.0, data);
    }

    public Particle(org.bukkit.Particle particle, double relativeX, double relativeY, double relativeZ, int count, double extra, Object data) {
        this(particle, relativeX, relativeY, relativeZ, count, 0.0, 0.0, 0.0, extra, data);
    }

    public Particle(org.bukkit.Particle particle, double relativeX, double relativeY, double relativeZ, int count, double offsetX, double offsetY, double offsetZ) {
        this(particle, relativeX, relativeY, relativeZ, count, offsetX, offsetY, offsetZ, 1.0, null);
    }

    public Particle(org.bukkit.Particle particle, double relativeX, double relativeY, double relativeZ, int count, double offsetX, double offsetY, double offsetZ, double extra) {
        this(particle, relativeX, relativeY, relativeZ, count, offsetX, offsetY, offsetZ, extra, null);
    }

    public Particle(org.bukkit.Particle particle, double relativeX, double relativeY, double relativeZ, int count, double offsetX, double offsetY, double offsetZ, Object data) {
        this(particle, relativeX, relativeY, relativeZ, count, offsetX, offsetY, offsetZ, 1.0, data);
    }

    public Particle(org.bukkit.Particle particle, double relativeX, double relativeY, double relativeZ, int count, double offsetX, double offsetY, double offsetZ, double extra, Object data) {
        this.particle = particle;
        this.dataClass = particle.getDataType();
        this.data = this.dataClass.isInstance(data) ? data : null;
        this.iconItem = new ItemBuilder(Material.FIREWORK_STAR).setDisplayName(particle.name()).create();
        this.relativeX = relativeX;
        this.relativeY = relativeY;
        this.relativeZ = relativeZ;
        this.offsetX = offsetX;
        this.offsetY = offsetY;
        this.offsetZ = offsetZ;
        this.count = count;
        this.extra = extra;
    }

    public NamespacedKey getNamespacedKey() {
        return this.namespacedKey;
    }

    public void setNamespacedKey(NamespacedKey namespacedKey) {
        this.namespacedKey = namespacedKey;
    }

    public void setSuperParticle(Particle superParticle) {
        this.superParticle = superParticle;
    }

    public Particle getSuperParticle() {
        return this.superParticle;
    }

    public boolean hasSuperParticle() {
        return this.superParticle != null;
    }

    public org.bukkit.Particle getParticle() {
        return this.hasParticle() ? this.particle : this.getSuperParticle().getParticle();
    }

    public void setParticle(org.bukkit.Particle particle) {
        this.particle = particle;
    }

    public Object getData() {
        return this.hasData() ? this.data : this.getSuperParticle().getData();
    }

    public void setData(Object data) {
        this.data = data;
    }

    public ItemStack getIconItem() {
        return this.iconItem;
    }

    public void setIconItem(ItemStack iconItem) {
        this.iconItem = iconItem;
    }

    public Class<?> getDataClass() {
        return this.hasDataClass() ? this.dataClass : this.getSuperParticle().getDataClass();
    }

    public double getRelativeX() {
        return this.hasRelativeX() ? this.relativeX : this.getSuperParticle().getRelativeX();
    }

    public void setRelativeX(double relativeX) {
        this.relativeX = relativeX;
    }

    public double getRelativeY() {
        return this.hasRelativeY() ? this.relativeY : this.getSuperParticle().getRelativeY();
    }

    public void setRelativeY(double relativeY) {
        this.relativeY = relativeY;
    }

    public double getRelativeZ() {
        return this.hasRelativeZ() ? this.relativeZ : this.getSuperParticle().getRelativeZ();
    }

    public void setRelativeZ(double relativeZ) {
        this.relativeZ = relativeZ;
    }

    public double getOffsetX() {
        return this.hasOffsetX() ? this.offsetX : this.getSuperParticle().getOffsetX();
    }

    public void setOffsetX(double offsetX) {
        this.offsetX = offsetX;
    }

    public double getOffsetY() {
        return this.hasOffsetY() ? this.offsetY : this.getSuperParticle().getOffsetY();
    }

    public void setOffsetY(double offsetY) {
        this.offsetY = offsetY;
    }

    public double getOffsetZ() {
        return this.hasOffsetZ() ? this.offsetZ : this.getSuperParticle().getOffsetZ();
    }

    public void setOffsetZ(double offsetZ) {
        this.offsetZ = offsetZ;
    }

    public int getCount() {
        return this.hasCount() ? this.count : this.getSuperParticle().getCount();
    }

    public void setCount(int count) {
        this.count = count;
    }

    public double getExtra() {
        return this.hasExtra() ? this.extra : this.getSuperParticle().getExtra();
    }

    public void setExtra(double extra) {
        this.extra = extra;
    }

    public List<String> getScripts() {
        return this.hasScripts() ? this.scripts : this.getSuperParticle().getScripts();
    }

    public boolean hasRelativeX() {
        return !this.hasSuperParticle() || this.relativeX != this.getSuperParticle().relativeX;
    }

    public boolean hasRelativeY() {
        return !this.hasSuperParticle() || this.relativeY != this.getSuperParticle().relativeY;
    }

    public boolean hasRelativeZ() {
        return !this.hasSuperParticle() || this.relativeZ != this.getSuperParticle().relativeZ;
    }

    public boolean hasOffsetX() {
        return !this.hasSuperParticle() || this.offsetX != this.getSuperParticle().offsetX;
    }

    public boolean hasOffsetY() {
        return !this.hasSuperParticle() || this.offsetY != this.getSuperParticle().offsetY;
    }

    public boolean hasOffsetZ() {
        return !this.hasSuperParticle() || this.offsetZ != this.getSuperParticle().offsetZ;
    }

    public boolean hasCount() {
        return !this.hasSuperParticle() || this.count != this.getSuperParticle().count;
    }

    public boolean hasExtra() {
        return !this.hasSuperParticle() || this.extra != this.getSuperParticle().extra;
    }

    public boolean hasParticle() {
        return !this.hasSuperParticle() || this.particle != this.getSuperParticle().particle;
    }

    public boolean hasData() {
        return !this.hasSuperParticle() || this.data != this.getSuperParticle().data;
    }

    public boolean hasDataClass() {
        return !this.hasSuperParticle() || this.dataClass != this.getSuperParticle().dataClass;
    }

    public boolean hasScripts() {
        if (!this.hasSuperParticle()) {
            return true;
        }
        if (this.scripts.isEmpty()) {
            return this.getSuperParticle().getScripts().isEmpty();
        }
        return !this.scripts.equals(this.getSuperParticle().scripts);
    }

    public void addScript(String script) {
        this.scripts.add(script);
    }

    public String toString() {
        return "Particle[" + this.namespacedKey + ", " + this.particle.name() + "]";
    }

    void prepare(String referencePath) {
        this.context = Context.enter();
        for (String script : this.getScripts()) {
            if (script.startsWith("file=")) {
                try {
                    FileInputStream inputStream = new FileInputStream(referencePath + File.separator + script.substring("file=".length()));
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                    this.context.evaluateReader(this.scope, bufferedReader, "<cmd>", 1, null);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                continue;
            }
            this.context.evaluateString(this.scope, script, "<cmd>", 1, null);
        }
    }

    public void spawnOnLocation(Location location, int tick) {
        Object function;
        Data particleData = new Data(this);
        if (!this.getScripts().isEmpty() && (function = this.scope.get("onLocation", this.scope)) instanceof Function) {
            Function f = (Function)function;
            f.call(Context.enter(), this.scope, this.scope, new Object[]{location, particleData, tick});
            Context.exit();
        }
        this.spawn(location, particleData);
    }

    public void spawnOnBlock(Block block, int tick) {
        Object function;
        Location location = block.getLocation();
        Data particleData = new Data(this);
        if (!this.getScripts().isEmpty() && (function = this.scope.get("onBlock", this.scope)) instanceof Function) {
            Function f = (Function)function;
            f.call(Context.enter(), this.scope, this.scope, new Object[]{block, location, particleData, tick});
            Context.exit();
        }
        this.spawn(location, particleData);
    }

    public void spawnOnPlayer(Player player, EquipmentSlot slot, int tick) {
        Object function;
        Location location = player.getLocation();
        Data particleData = new Data(this);
        if (!this.getScripts().isEmpty() && (function = this.scope.get("onPlayer", this.scope)) instanceof Function) {
            Function f = (Function)function;
            f.call(Context.enter(), this.scope, this.scope, new Object[]{player, slot, location, particleData, tick});
            Context.exit();
        }
        this.spawn(location, particleData);
    }

    private void spawn(Location location, Data particleData) {
        this.spawn(location, particleData.relativeX, particleData.relativeY, particleData.relativeZ, particleData.count, particleData.offsetX, particleData.offsetY, particleData.offsetZ, particleData.extra, particleData.data);
    }

    private void spawn(Location location, double x, double y, double z, int count, double offsetX, double offsetY, double offsetZ, double extra, @Nullable Object data) {
        Bukkit.getScheduler().runTask((Plugin)Main.getInstance(), () -> {
            if (location.getWorld() != null) {
                if (data == null || !this.getDataClass().isInstance(data)) {
                    location.getWorld().spawnParticle(this.particle, location.add(x, y, z), count, offsetX, offsetY, offsetZ, extra);
                } else {
                    location.getWorld().spawnParticle(this.particle, location.add(x, y, z), count, offsetX, offsetY, offsetZ, extra, data);
                }
            }
        });
    }

    public static class Data {
        private Class<?> dataClass;
        private Object data;
        private double relativeX;
        private double relativeY;
        private double relativeZ;
        private double offsetX;
        private double offsetY;
        private double offsetZ;
        private int count;
        private double extra;

        public Data(Particle particle) {
            this.dataClass = particle.getDataClass();
            this.data = particle.dataClass.isInstance(particle.getData()) ? particle.getData() : null;
            this.relativeX = particle.getRelativeX();
            this.relativeY = particle.getRelativeY();
            this.relativeZ = particle.getRelativeZ();
            this.offsetX = particle.getOffsetX();
            this.offsetY = particle.getOffsetY();
            this.offsetZ = particle.getOffsetZ();
            this.count = particle.getCount();
            this.extra = particle.getExtra();
        }

        public Object getData() {
            return this.data;
        }

        public void setData(Object data) {
            if (this.dataClass.isInstance(data)) {
                this.data = data;
            }
        }

        public double getRelativeX() {
            return this.relativeX;
        }

        public void setRelativeX(double relativeX) {
            this.relativeX = relativeX;
        }

        public double getRelativeY() {
            return this.relativeY;
        }

        public void setRelativeY(double relativeY) {
            this.relativeY = relativeY;
        }

        public double getRelativeZ() {
            return this.relativeZ;
        }

        public void setRelativeZ(double relativeZ) {
            this.relativeZ = relativeZ;
        }

        public double getOffsetX() {
            return this.offsetX;
        }

        public void setOffsetX(double offsetX) {
            this.offsetX = offsetX;
        }

        public double getOffsetY() {
            return this.offsetY;
        }

        public void setOffsetY(double offsetY) {
            this.offsetY = offsetY;
        }

        public double getOffsetZ() {
            return this.offsetZ;
        }

        public void setOffsetZ(double offsetZ) {
            this.offsetZ = offsetZ;
        }

        public int getCount() {
            return this.count;
        }

        public void setCount(int count) {
            this.count = count;
        }

        public double getExtra() {
            return this.extra;
        }

        public void setExtra(double extra) {
            this.extra = extra;
        }
    }
}

