/*
 * Decompiled with CFR 0.152.
 */
package me.wolfyscript.utilities.api.config.serialization;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.Locale;
import java.util.Map;
import me.wolfyscript.utilities.api.custom_items.ParticleData;
import me.wolfyscript.utilities.api.utils.NamespacedKey;
import me.wolfyscript.utilities.api.utils.particles.ParticleEffect;

public class ParticleDataSerialization
implements JsonSerializer<ParticleData>,
JsonDeserializer<ParticleData> {
    public ParticleData deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
        if (jsonElement instanceof JsonObject) {
            ParticleData particleData = new ParticleData();
            JsonObject particles = (JsonObject)jsonElement;
            for (ParticleEffect.Action action : ParticleEffect.Action.values()) {
                JsonObject particle;
                String id = action.name().toLowerCase(Locale.ROOT);
                if (!particles.has(id) || !(particles.get(id) instanceof JsonObject) || !(particle = (JsonObject)particles.get(id)).has("effect")) continue;
                String effect = particle.get("effect").getAsString();
                NamespacedKey namespacedKey = effect.split(":").length > 1 ? new NamespacedKey(effect.split(":")[0], effect.split(":")[1]) : new NamespacedKey("wolfyutilities", effect);
                particleData.addParticleEffect(action, namespacedKey);
            }
            return particleData;
        }
        return null;
    }

    public JsonElement serialize(ParticleData particleData, Type type, JsonSerializationContext jsonSerializationContext) {
        JsonObject result = new JsonObject();
        for (Map.Entry entry : particleData.entrySet()) {
            JsonObject particle = new JsonObject();
            particle.addProperty("effect", ((NamespacedKey)entry.getValue()).toString());
            result.add(((ParticleEffect.Action)((Object)entry.getKey())).name().toLowerCase(Locale.ROOT), (JsonElement)particle);
        }
        return result;
    }
}

