/*
 * Decompiled with CFR 0.152.
 */
package me.wolfyscript.utilities.api.config.serialization;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.UUID;
import me.wolfyscript.utilities.main.Main;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;

public class LocationSerialization
implements JsonSerializer<Location>,
JsonDeserializer<Location> {
    public Location deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
        if (jsonElement instanceof JsonObject) {
            UUID uuid = UUID.fromString(((JsonObject)jsonElement).getAsJsonPrimitive("world").getAsString());
            World world = Bukkit.getWorld((UUID)uuid);
            if (world != null) {
                JsonArray jsonArray = ((JsonObject)jsonElement).getAsJsonArray("pos");
                if (jsonArray.size() == 5) {
                    double x = jsonArray.get(0).getAsDouble();
                    double y = jsonArray.get(1).getAsDouble();
                    double z = jsonArray.get(2).getAsDouble();
                    float yaw = jsonArray.get(3).getAsFloat();
                    float pitch = jsonArray.get(4).getAsFloat();
                    return new Location(world, x, y, z, yaw, pitch);
                }
                Main.getMainUtil().sendConsoleWarning("Error Deserializing Location! Invalid Position: expected array size 5 got " + jsonArray.size());
            } else {
                Main.getMainUtil().sendConsoleWarning("Error Deserializing Location! Missing World with uid " + uuid.toString());
            }
        } else {
            Main.getMainUtil().sendConsoleWarning("Error Deserializing Location! Invalid Location object!");
        }
        return null;
    }

    public JsonElement serialize(Location location, Type type, JsonSerializationContext jsonSerializationContext) {
        JsonObject locObject = new JsonObject();
        locObject.addProperty("world", location.getWorld().getUID().toString());
        JsonArray posObject = new JsonArray();
        posObject.add((Number)location.getX());
        posObject.add((Number)location.getY());
        posObject.add((Number)location.getZ());
        posObject.add((Number)Float.valueOf(location.getYaw()));
        posObject.add((Number)Float.valueOf(location.getPitch()));
        locObject.add("pos", (JsonElement)posObject);
        return locObject;
    }
}

