/*
 * Decompiled with CFR 0.152.
 */
package de.iani.treasurechest.commands;

import de.iani.cubesideutils.bukkit.commands.SubCommand;
import de.iani.cubesideutils.bukkit.commands.exceptions.DisallowsCommandBlockException;
import de.iani.cubesideutils.bukkit.commands.exceptions.IllegalSyntaxException;
import de.iani.cubesideutils.bukkit.commands.exceptions.InternalCommandException;
import de.iani.cubesideutils.bukkit.commands.exceptions.NoPermissionException;
import de.iani.cubesideutils.bukkit.commands.exceptions.RequiresPlayerException;
import de.iani.cubesideutils.commands.ArgsParser;
import de.iani.playerUUIDCache.CachedPlayer;
import de.iani.treasurechest.TreasureChest;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;

public class TransferCommand
extends SubCommand {
    private TreasureChest plugin;

    public TransferCommand(TreasureChest plugin) {
        this.plugin = plugin;
    }

    public String getRequiredPermission() {
        return "treasurechest.transfer";
    }

    public boolean requiresPlayer() {
        return false;
    }

    public String getUsage() {
        return "<fromplayer> <toplayer> CONFIRM";
    }

    public boolean onCommand(CommandSender sender, Command command, String alias, String commandString, ArgsParser args) throws DisallowsCommandBlockException, RequiresPlayerException, NoPermissionException, IllegalSyntaxException, InternalCommandException {
        if (args.remaining() != 3) {
            this.plugin.sendMessage(sender, commandString + this.getUsage(), true);
            return true;
        }
        CachedPlayer fromPlayer = this.plugin.getPlayerUUIDCache().getPlayerFromNameOrUUID(args.getNext(), true);
        if (fromPlayer == null) {
            this.plugin.sendMessage(sender, "Unknown old player!", true);
            return true;
        }
        CachedPlayer toPlayer = this.plugin.getPlayerUUIDCache().getPlayerFromNameOrUUID(args.getNext(), true);
        if (toPlayer == null) {
            this.plugin.sendMessage(sender, "Unknown new player!", true);
            return true;
        }
        if (!args.getNext().equals("CONFIRM")) {
            this.plugin.sendMessage(sender, commandString + this.getUsage(), true);
            return true;
        }
        try {
            int transfered = this.plugin.getDatabase().transferItems(fromPlayer.getUniqueId(), toPlayer.getUniqueId());
            if (this.plugin.getServer().getPlayer(fromPlayer.getUniqueId()) != null) {
                this.plugin.getData().reloadTreasureChest(fromPlayer.getUniqueId());
            } else {
                this.plugin.getData().unloadTreasureChest(fromPlayer.getUniqueId());
            }
            if (this.plugin.getServer().getPlayer(toPlayer.getUniqueId()) != null) {
                this.plugin.getData().reloadTreasureChest(toPlayer.getUniqueId());
            } else {
                this.plugin.getData().unloadTreasureChest(toPlayer.getUniqueId());
            }
            this.plugin.sendMessage(sender, transfered == 0 ? fromPlayer.getName() + " hatte keine Items in seiner Schatztruhe!" : transfered + " Items wurden von " + fromPlayer.getName() + " zu " + toPlayer.getName() + " \u00fcbertragen!");
        }
        catch (SQLException e) {
            this.plugin.sendMessage(sender, "Datenbankfehler", true);
            this.plugin.getLogger().log(Level.SEVERE, "Could not transfer items from " + String.valueOf(fromPlayer.getUniqueId()) + " to " + String.valueOf(toPlayer.getUniqueId()) + ": " + e.getMessage(), e);
            return true;
        }
        return true;
    }

    public Collection<String> onTabComplete(CommandSender sender, Command command, String alias, ArgsParser args) {
        if (args.remaining() < 3) {
            return null;
        }
        return List.of();
    }
}

