/*
 * Decompiled with CFR 0.152.
 */
package de.iani.treasurechest.commands;

import de.iani.cubesideutils.bukkit.commands.SubCommand;
import de.iani.cubesideutils.bukkit.commands.exceptions.DisallowsCommandBlockException;
import de.iani.cubesideutils.bukkit.commands.exceptions.IllegalSyntaxException;
import de.iani.cubesideutils.bukkit.commands.exceptions.InternalCommandException;
import de.iani.cubesideutils.bukkit.commands.exceptions.NoPermissionException;
import de.iani.cubesideutils.bukkit.commands.exceptions.RequiresPlayerException;
import de.iani.cubesideutils.commands.ArgsParser;
import de.iani.treasurechest.TreasureChest;
import de.iani.treasurechest.TreasureChestItem;
import java.util.Collection;
import java.util.List;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class AddMoneyCommand
extends SubCommand {
    private TreasureChest plugin;

    public AddMoneyCommand(TreasureChest plugin) {
        this.plugin = plugin;
    }

    public String getRequiredPermission() {
        return "treasurechest.create";
    }

    public boolean requiresPlayer() {
        return true;
    }

    public String getUsage() {
        return "<amount>";
    }

    public boolean onCommand(CommandSender sender, Command command, String alias, String commandString, ArgsParser args) throws DisallowsCommandBlockException, RequiresPlayerException, NoPermissionException, IllegalSyntaxException, InternalCommandException {
        if (args.remaining() != 1) {
            this.plugin.sendMessage(sender, commandString + this.getUsage(), true);
            return true;
        }
        int amount = args.getNext(0);
        Player player = (Player)sender;
        TreasureChestItem activeItem = this.plugin.getData().getActiveItem(player.getUniqueId());
        if (activeItem == null) {
            this.plugin.sendMessage(sender, "You have no active item!", true);
            return true;
        }
        activeItem.setPriceMoney(activeItem.getPriceMoney() + amount);
        this.plugin.sendMessage(sender, "Set the money to " + activeItem.getPriceMoney());
        return true;
    }

    public Collection<String> onTabComplete(CommandSender sender, Command command, String alias, ArgsParser args) {
        return List.of();
    }
}

