/*
 * Decompiled with CFR 0.152.
 */
package de.iani.treasurechest;

import de.iani.treasurechest.ListedItemsData;
import de.iani.treasurechest.PlayerTreasureChestContent;
import de.iani.treasurechest.TreasureChest;
import de.iani.treasurechest.TreasureChestItem;
import java.util.HashMap;
import java.util.Iterator;
import java.util.UUID;

public class TreasureChestData {
    private HashMap<UUID, TreasureChestItem> activeItems = new HashMap();
    private HashMap<UUID, PlayerTreasureChestContent> loadedChests = new HashMap();
    private HashMap<UUID, ListedItemsData> listedItems = new HashMap();
    private TreasureChest plugin;

    public TreasureChestData(TreasureChest plugin) {
        this.plugin = plugin;
    }

    public TreasureChestItem getActiveItem(UUID playerUUID) {
        return this.activeItems.get(playerUUID);
    }

    public TreasureChestItem setActiveItem(UUID playerUUID, TreasureChestItem item) {
        if (item == null) {
            return this.removeActiveItem(playerUUID);
        }
        return this.activeItems.put(playerUUID, item);
    }

    public TreasureChestItem removeActiveItem(UUID owner) {
        return this.activeItems.remove(owner);
    }

    public PlayerTreasureChestContent getOrCreateChestContent(UUID owner) {
        PlayerTreasureChestContent content = this.loadedChests.get(owner);
        if (content == null) {
            content = new PlayerTreasureChestContent(owner, this.plugin);
            this.loadedChests.put(owner, content);
        }
        return content;
    }

    public PlayerTreasureChestContent getChestContent(UUID owner) {
        return this.loadedChests.get(owner);
    }

    public void reloadTreasureChest(UUID owner) {
        this.loadedChests.put(owner, new PlayerTreasureChestContent(owner, this.plugin));
    }

    public void unloadTreasureChest(UUID owner) {
        this.loadedChests.remove(owner);
    }

    public ListedItemsData getListedItems(UUID owner) {
        return this.listedItems.get(owner);
    }

    public void setListedItems(UUID owner, ListedItemsData data) {
        this.listedItems.put(owner, data);
    }

    public void removeListedItems(UUID owner) {
        this.listedItems.remove(owner);
    }

    public void doGC() {
        Iterator<PlayerTreasureChestContent> it = this.loadedChests.values().iterator();
        while (it.hasNext()) {
            PlayerTreasureChestContent c = it.next();
            if (this.plugin.getServer().getPlayer(c.getOwner()) != null) continue;
            it.remove();
        }
    }
}

