/*
 * Decompiled with CFR 0.152.
 */
package de.iani.treasurechest;

import de.iani.playerUUIDCache.CachedPlayer;
import de.iani.treasurechest.ListedItemsData;
import de.iani.treasurechest.PlayerTreasureChestContent;
import de.iani.treasurechest.TreasureChest;
import de.iani.treasurechest.TreasureChestItem;
import de.iani.treasurechest.database.DatabaseTreasureChestItem;
import java.sql.SQLException;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import org.bukkit.ChatColor;
import org.bukkit.Effect;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class TreasureChestCommandExecutor
implements CommandExecutor {
    private TreasureChest plugin;

    public TreasureChestCommandExecutor(TreasureChest plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(final CommandSender sender, Command command, String label, String[] args) {
        if (args.length == 0) {
            this.displayHelp(sender, label);
        } else {
            String subcommand = args[0].toLowerCase();
            if (subcommand.equals("setchest")) {
                if (!this.checkPlayer(sender) || !this.checkPermission(sender, "treasurechest.setchest")) {
                    return true;
                }
                Player player = (Player)sender;
                Block target = player.getTargetBlock((Set)null, 5);
                this.plugin.setChestLocation(target == null ? null : target.getLocation());
                if (target != null) {
                    player.playEffect(target.getLocation(), Effect.MOBSPAWNER_FLAMES, null);
                    player.playEffect(target.getLocation(), Effect.MOBSPAWNER_FLAMES, null);
                    player.playEffect(target.getLocation(), Effect.MOBSPAWNER_FLAMES, null);
                    this.plugin.sendMessage(sender, "Treasurechest location set!");
                } else {
                    this.plugin.sendMessage(sender, "Treasurechest location removed!");
                }
            } else if (subcommand.equals("create")) {
                if (!this.checkPlayer(sender) || !this.checkPermission(sender, "treasurechest.create")) {
                    return true;
                }
                Player player = (Player)sender;
                ItemStack inHand = player.getInventory().getItemInMainHand();
                if (inHand == null || inHand.getType() == Material.AIR || inHand.getAmount() == 0) {
                    this.plugin.sendMessage(sender, "You have to hold the display item in hand!", true);
                    return true;
                }
                TreasureChestItem newItem = new TreasureChestItem(inHand.clone(), null, 0);
                this.plugin.getData().setActiveItem(player.getUniqueId(), newItem);
                this.plugin.sendMessage(sender, "Created a new Treasurechest item!");
            } else if (subcommand.equals("addmoney")) {
                if (!this.checkPlayer(sender) || !this.checkPermission(sender, "treasurechest.create")) {
                    return true;
                }
                if (args.length < 2) {
                    this.plugin.sendMessage(sender, "/" + label + " addmoney <amount>", true);
                    return true;
                }
                int amount = this.getIntArgument(args[1], 0);
                Player player = (Player)sender;
                TreasureChestItem activeItem = this.plugin.getData().getActiveItem(player.getUniqueId());
                if (activeItem == null) {
                    this.plugin.sendMessage(sender, "You have no active item!", true);
                    return true;
                }
                activeItem.setPriceMoney(activeItem.getPriceMoney() + amount);
                this.plugin.sendMessage(sender, "Set the money to " + activeItem.getPriceMoney());
            } else if (subcommand.equals("additem")) {
                if (!this.checkPlayer(sender) || !this.checkPermission(sender, "treasurechest.create")) {
                    return true;
                }
                Player player = (Player)sender;
                ItemStack inHand = player.getInventory().getItemInMainHand();
                if (inHand == null || inHand.getType() == Material.AIR || inHand.getAmount() == 0) {
                    this.plugin.sendMessage(sender, "You have to hold the item in hand!", true);
                    return true;
                }
                TreasureChestItem activeItem = this.plugin.getData().getActiveItem(player.getUniqueId());
                if (activeItem == null) {
                    this.plugin.sendMessage(sender, "You have no active item!", true);
                    return true;
                }
                activeItem.addPriceItem(inHand.clone());
                this.plugin.sendMessage(sender, "Item added: " + inHand.getAmount() + " " + TreasureChest.capitalize(inHand.getType().name(), true));
            } else {
                if (subcommand.equals("give")) {
                    if (!this.checkPlayer(sender) || !this.checkPermission(sender, "treasurechest.give")) {
                        return true;
                    }
                    if (args.length < 2) {
                        this.plugin.sendMessage(sender, "/" + label + " give <player>", true);
                        return true;
                    }
                    Player player = (Player)sender;
                    TreasureChestItem activeItem = this.plugin.getData().getActiveItem(player.getUniqueId());
                    if (activeItem == null) {
                        this.plugin.sendMessage(sender, "You have no active item!", true);
                        return true;
                    }
                    for (int arg = 1; arg < args.length; ++arg) {
                        String nameOrId = args[arg].replace(",", "").trim();
                        CachedPlayer target = this.plugin.getPlayerUUIDCache().getPlayerFromNameOrUUID(nameOrId);
                        if (target == null) {
                            this.plugin.sendMessage(sender, "Unknown player!", true);
                            continue;
                        }
                        this.plugin.addItem((OfflinePlayer)target, activeItem.getDisplayItem(), activeItem.getPriceItems(), activeItem.getPriceMoney());
                        this.plugin.sendMessage(sender, "Item given to: " + target.getName());
                    }
                    return true;
                }
                if (subcommand.equals("list")) {
                    if (!this.checkPermission(sender, "treasurechest.list")) {
                        return true;
                    }
                    if (args.length < 2) {
                        this.plugin.sendMessage(sender, "/" + label + " list <player>", true);
                        return true;
                    }
                    final CachedPlayer target = this.plugin.getPlayerUUIDCache().getPlayerFromNameOrUUID(args[1], true);
                    if (target == null) {
                        this.plugin.sendMessage(sender, "Unknown player!", true);
                        return true;
                    }
                    final PlayerTreasureChestContent content = this.plugin.getData().getOrCreateChestContent(target.getUniqueId());
                    content.loadAsync(new Runnable(){

                        @Override
                        public void run() {
                            TreasureChestCommandExecutor.this.plugin.sendMessage(sender, ChatColor.GRAY + "Preise von " + target.getName() + " (" + target.getUniqueId().toString() + "):");
                            List<DatabaseTreasureChestItem> items = content.getItems();
                            if (items.isEmpty()) {
                                TreasureChestCommandExecutor.this.plugin.sendMessage(sender, "keine Preise vorhanden");
                            } else {
                                ListedItemsData lid = new ListedItemsData(target.getUniqueId());
                                int nr = 1;
                                for (DatabaseTreasureChestItem i : items) {
                                    TreasureChestCommandExecutor.this.plugin.sendMessage(sender, nr + ": " + i.getDisplayItem().getItemMeta().getDisplayName());
                                    lid.addItem(nr, i.getId());
                                    ++nr;
                                }
                                if (sender instanceof Player) {
                                    Player player = (Player)sender;
                                    TreasureChestCommandExecutor.this.plugin.getData().setListedItems(player.getUniqueId(), lid);
                                } else {
                                    TreasureChestCommandExecutor.this.plugin.getData().setListedItems(null, lid);
                                }
                            }
                        }
                    });
                } else if (subcommand.equals("remove")) {
                    block45: {
                        ListedItemsData lid;
                        if (!this.checkPermission(sender, "treasurechest.remove")) {
                            return true;
                        }
                        if (args.length < 3) {
                            this.plugin.sendMessage(sender, "/" + label + " remove <player> <nr>", true);
                            return true;
                        }
                        CachedPlayer target = this.plugin.getPlayerUUIDCache().getPlayerFromNameOrUUID(args[1], true);
                        if (target == null) {
                            this.plugin.sendMessage(sender, "Unknown player!", true);
                            return true;
                        }
                        int nr = this.getIntArgument(args[2], -1);
                        if (sender instanceof Player) {
                            Player player = (Player)sender;
                            lid = this.plugin.getData().getListedItems(player.getUniqueId());
                        } else {
                            lid = this.plugin.getData().getListedItems(null);
                        }
                        if (lid == null || !lid.getOwner().equals(target.getUniqueId())) {
                            this.plugin.sendMessage(sender, "Nicht der gelistete Spieler", true);
                            return true;
                        }
                        Integer key = lid.getItemDatabaseKey(nr);
                        if (key == null) {
                            this.plugin.sendMessage(sender, "Ung\u00fcltige ID", true);
                            return true;
                        }
                        try {
                            if (this.plugin.getDatabase().deleteItem(target.getUniqueId(), key)) {
                                PlayerTreasureChestContent content = this.plugin.getData().getChestContent(target.getUniqueId());
                                if (content != null && content.getLoadState() == PlayerTreasureChestContent.LoadState.LOADED) {
                                    content.removeItem(key);
                                }
                                break block45;
                            }
                            this.plugin.sendMessage(sender, "Ung\u00fcltige ID", true);
                            return true;
                        }
                        catch (SQLException e) {
                            this.plugin.sendMessage(sender, ChatColor.DARK_RED + "Datenbankfehler");
                            this.plugin.getLogger().log(Level.SEVERE, "Could not delete item " + key + " for " + target.getName() + ": " + e.getMessage(), e);
                            return true;
                        }
                    }
                    this.plugin.sendMessage(sender, "Der Preis wurde entfernt!");
                } else {
                    this.plugin.sendMessage(sender, "Unknown subcommand!", true);
                    return true;
                }
            }
        }
        return true;
    }

    private void displayHelp(CommandSender sender, String label) {
        this.plugin.sendMessage(sender, ChatColor.GREEN + "Commands");
        if (this.checkPlayer(sender, true) && this.checkPermission(sender, "treasurechest.setchest", true)) {
            this.plugin.sendMessage(sender, "/" + label + " setchest");
            this.plugin.sendMessage(sender, ChatColor.GREEN + "  Set the treasure chest location to the location you are looking at.");
        }
        if (this.checkPlayer(sender, true) && this.checkPermission(sender, "treasurechest.create", true)) {
            this.plugin.sendMessage(sender, "/" + label + " create");
            this.plugin.sendMessage(sender, ChatColor.GREEN + "  Creates a price with the item in hand as display item.");
            this.plugin.sendMessage(sender, "/" + label + " additem");
            this.plugin.sendMessage(sender, ChatColor.GREEN + "  Adds the item in hand to the price.");
            this.plugin.sendMessage(sender, "/" + label + " addmoney <amount>");
            this.plugin.sendMessage(sender, ChatColor.GREEN + "  Adds money to a price.");
        }
        if (this.checkPlayer(sender, true) && this.checkPermission(sender, "treasurechest.give", true)) {
            this.plugin.sendMessage(sender, "/" + label + " give <player>");
            this.plugin.sendMessage(sender, ChatColor.GREEN + "  Gives a price to a player.");
        }
        if (this.checkPermission(sender, "treasurechest.list")) {
            this.plugin.sendMessage(sender, "/" + label + " list <player>");
            this.plugin.sendMessage(sender, ChatColor.GREEN + "  Gives price for a player.");
        }
        if (this.checkPermission(sender, "treasurechest.remove")) {
            this.plugin.sendMessage(sender, "/" + label + " remove <player> <id>");
            this.plugin.sendMessage(sender, ChatColor.GREEN + "  Removes a price from a players chest.");
        }
    }

    private int getIntArgument(String value, int defaultValue) {
        try {
            return Integer.parseInt(value);
        }
        catch (Exception exception) {
            return defaultValue;
        }
    }

    private boolean checkPermission(CommandSender sender, String perm) {
        return this.checkPermission(sender, perm, false);
    }

    private boolean checkPermission(CommandSender sender, String perm, boolean silent) {
        boolean hasPermission = sender.hasPermission(perm);
        if (!silent && !hasPermission) {
            this.plugin.sendMessage(sender, "No permission!", true);
        }
        return hasPermission;
    }

    private boolean checkPlayer(CommandSender sender) {
        return this.checkPlayer(sender, false);
    }

    private boolean checkPlayer(CommandSender sender, boolean silent) {
        boolean isPlayer = sender instanceof Player;
        if (!isPlayer && !silent) {
            this.plugin.sendMessage(sender, "You must be a player!", true);
        }
        return isPlayer;
    }
}

