/*
 * Decompiled with CFR 0.152.
 */
package de.iani.playerUUIDCache.util.fetcher;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import de.iani.playerUUIDCache.NameHistory;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.UUID;
import java.util.concurrent.Callable;

public class NameHistoryFetcher
implements Callable<NameHistory> {
    private static final String PROFILE_URL_PREFIX = "https://api.mojang.com/user/profiles/";
    private static final String PROFILE_URL_SUFFIX = "/names";
    private final JsonParser jsonParser = new JsonParser();
    private UUID uuid;

    public NameHistoryFetcher(UUID uuid) {
        this.uuid = uuid;
    }

    @Override
    public NameHistory call() throws Exception {
        HttpURLConnection connection = (HttpURLConnection)new URL(PROFILE_URL_PREFIX + this.uuid.toString().replace("-", "") + PROFILE_URL_SUFFIX).openConnection();
        connection.setConnectTimeout(5000);
        long time = System.currentTimeMillis();
        InputStream is = connection.getInputStream();
        if (is == null) {
            return null;
        }
        JsonElement response = this.jsonParser.parse((Reader)new InputStreamReader(is));
        if (response.isJsonNull()) {
            return null;
        }
        JsonArray array = (JsonArray)response;
        String firstName = null;
        ArrayList<NameHistory.NameChange> changes = new ArrayList<NameHistory.NameChange>();
        for (JsonElement element : array) {
            JsonObject object = (JsonObject)element;
            String name = object.get("name").getAsString();
            if (object.has("changedToAt")) {
                changes.add(new NameHistory.NameChange(name, object.get("changedToAt").getAsLong()));
                continue;
            }
            if (firstName != null) {
                throw new RuntimeException("illegal response from mojang");
            }
            firstName = name;
        }
        return new NameHistory(this.uuid, firstName, changes, time);
    }
}

