/*
 * Decompiled with CFR 0.152.
 */
package com.griefcraft.modules.doors;

import com.griefcraft.bukkit.EntityBlock;
import com.griefcraft.lwc.LWC;
import com.griefcraft.model.Flag;
import com.griefcraft.model.Protection;
import com.griefcraft.scripting.JavaModule;
import com.griefcraft.scripting.Module;
import com.griefcraft.scripting.event.LWCProtectionInteractEvent;
import com.griefcraft.util.config.Configuration;
import com.griefcraft.util.matchers.DoorMatcher;
import java.util.HashSet;
import java.util.UUID;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.Bisected;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Openable;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class DoorsModule
extends JavaModule {
    private static final int TICKS_PER_SECOND = 20;
    private final Configuration configuration = Configuration.load("doors.yml");
    private LWC lwc;
    private Action action = Action.TOGGLE;
    private HashSet<UUID> hasInteractedThisTick;

    @Override
    public void load(LWC lwc) {
        this.lwc = lwc;
        this.hasInteractedThisTick = new HashSet();
        lwc.getPlugin().getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)lwc.getPlugin(), new Runnable(){

            @Override
            public void run() {
                if (!DoorsModule.this.hasInteractedThisTick.isEmpty()) {
                    DoorsModule.this.hasInteractedThisTick.clear();
                }
            }
        }, 1L, 1L);
        this.loadAction();
    }

    @Override
    public void onProtectionInteract(LWCProtectionInteractEvent event) {
        if (event.getResult() == Module.Result.CANCEL || !this.isEnabled() || event.getEvent().getAction() != org.bukkit.event.block.Action.RIGHT_CLICK_BLOCK || event.getPlayer().isSneaking()) {
            return;
        }
        if (!event.canAccess()) {
            return;
        }
        Protection protection = event.getProtection();
        Block block = event.getEvent().getClickedBlock();
        Player player = event.getPlayer();
        if (block instanceof EntityBlock) {
            return;
        }
        if (!this.isValid(block.getType())) {
            return;
        }
        Block doubleDoorBlock = null;
        if (DoorMatcher.PROTECTABLES_DOORS.contains(block.getType())) {
            Protection other;
            if (((Bisected)block.getBlockData()).getHalf() == Bisected.Half.TOP && !this.isValid((block = block.getRelative(BlockFace.DOWN)).getType())) {
                return;
            }
            boolean doubleDoors = this.usingDoubleDoors();
            if (doubleDoors && (doubleDoorBlock = this.getDoubleDoor(block)) != null && !this.lwc.canAccessProtection(player, other = this.lwc.findProtection(doubleDoorBlock.getLocation()))) {
                doubleDoorBlock = null;
            }
        }
        if (!this.hasInteractedThisTick.add(event.getPlayer().getUniqueId())) {
            event.setResult(CANCEL);
            event.getEvent().setCancelled(true);
            return;
        }
        boolean opensWhenClicked = DoorMatcher.WOODEN_DOORS.contains(block.getType()) || DoorMatcher.FENCE_GATES.contains(block.getType()) || DoorMatcher.TRAPDOORS.contains(block.getType());
        this.changeDoorStates(true, opensWhenClicked ? null : block, doubleDoorBlock);
        if (!opensWhenClicked && !event.getPlayer().isSneaking()) {
            event.getEvent().setCancelled(true);
        }
        if (this.action == Action.OPEN_AND_CLOSE || protection.hasFlag(Flag.Type.AUTOCLOSE)) {
            final Block finalBlock = block;
            final Block finalDoubleDoorBlock = doubleDoorBlock;
            int wait = this.getAutoCloseInterval() * 20;
            this.lwc.getPlugin().getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.lwc.getPlugin(), new Runnable(){

                @Override
                public void run() {
                    DoorsModule.this.changeDoorStates(false, new Block[]{finalBlock, finalDoubleDoorBlock});
                }
            }, (long)wait);
        }
    }

    private void changeDoorStates(boolean allowDoorToOpen, Block ... doors) {
        for (Block door : doors) {
            Block topHalf;
            boolean wasClosed;
            if (door == null || !(door.getBlockData() instanceof Openable)) continue;
            Openable doorBlock = (Openable)door.getBlockData();
            boolean bl = wasClosed = !doorBlock.isOpen();
            if (!allowDoorToOpen && wasClosed) continue;
            doorBlock.setOpen(wasClosed);
            door.setBlockData((BlockData)doorBlock);
            Sound s = null;
            Material type = door.getType();
            if (DoorMatcher.WOODEN_DOORS.contains(type)) {
                s = wasClosed ? Sound.BLOCK_WOODEN_DOOR_OPEN : Sound.BLOCK_WOODEN_DOOR_CLOSE;
            } else if (DoorMatcher.PROTECTABLES_DOORS.contains(type)) {
                s = wasClosed ? Sound.BLOCK_IRON_DOOR_OPEN : Sound.BLOCK_IRON_DOOR_CLOSE;
            } else if (DoorMatcher.FENCE_GATES.contains(type)) {
                s = wasClosed ? Sound.BLOCK_FENCE_GATE_OPEN : Sound.BLOCK_FENCE_GATE_CLOSE;
            } else if (type == Material.IRON_TRAPDOOR) {
                s = wasClosed ? Sound.BLOCK_IRON_TRAPDOOR_OPEN : Sound.BLOCK_IRON_TRAPDOOR_CLOSE;
            } else if (DoorMatcher.TRAPDOORS.contains(type)) {
                Sound sound = s = wasClosed ? Sound.BLOCK_WOODEN_TRAPDOOR_OPEN : Sound.BLOCK_WOODEN_TRAPDOOR_CLOSE;
            }
            if (s != null) {
                door.getWorld().playSound(door.getLocation(), s, SoundCategory.BLOCKS, 1.0f, 1.0f);
            }
            if (!DoorMatcher.PROTECTABLES_DOORS.contains(type) || type != (topHalf = door.getRelative(BlockFace.UP)).getType()) continue;
            Openable topHalfData = (Openable)topHalf.getBlockData();
            topHalfData.setOpen(doorBlock.isOpen());
            topHalf.setBlockData((BlockData)topHalfData);
        }
    }

    private Block getDoubleDoor(Block block) {
        if (!this.isValid(block.getType())) {
            return null;
        }
        for (Material material : DoorMatcher.PROTECTABLES_DOORS) {
            Block found = this.lwc.findAdjacentBlock(block, material, new Block[0]);
            if (found == null) continue;
            return found;
        }
        return null;
    }

    public boolean isEnabled() {
        return this.configuration.getBoolean("doors.enabled", true);
    }

    private boolean isValid(Material material) {
        if (DoorMatcher.PROTECTABLES_DOORS.contains(material)) {
            return true;
        }
        if (DoorMatcher.FENCE_GATES.contains(material)) {
            return true;
        }
        return DoorMatcher.TRAPDOORS.contains(material) || material == Material.IRON_TRAPDOOR;
    }

    private int getAutoCloseInterval() {
        return this.configuration.getInt("doors.interval", 3);
    }

    private boolean usingDoubleDoors() {
        return this.configuration.getBoolean("doors.doubleDoors", true);
    }

    private void loadAction() {
        String strAction = this.configuration.getString("doors.action");
        this.action = strAction.equalsIgnoreCase("openAndClose") ? Action.OPEN_AND_CLOSE : Action.TOGGLE;
    }

    private static enum Action {
        OPEN_AND_CLOSE,
        TOGGLE;

    }
}

