/*
 * Decompiled with CFR 0.152.
 */
package de.iani.cubesideutils.nbt.io;

import de.iani.cubesideutils.nbt.BaseTag;
import de.iani.cubesideutils.nbt.ByteArrayTag;
import de.iani.cubesideutils.nbt.ByteTag;
import de.iani.cubesideutils.nbt.CompoundTag;
import de.iani.cubesideutils.nbt.DoubleTag;
import de.iani.cubesideutils.nbt.FloatTag;
import de.iani.cubesideutils.nbt.IntArrayTag;
import de.iani.cubesideutils.nbt.IntTag;
import de.iani.cubesideutils.nbt.ListTag;
import de.iani.cubesideutils.nbt.LongArrayTag;
import de.iani.cubesideutils.nbt.LongTag;
import de.iani.cubesideutils.nbt.ShortTag;
import de.iani.cubesideutils.nbt.StringTag;
import de.iani.cubesideutils.nbt.TagType;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;

public class NbtOutputStream
extends DataOutputStream {
    public NbtOutputStream(OutputStream out) {
        super(out);
    }

    public void writeNbt(CompoundTag nbt) throws IOException {
        this.writeByte(nbt.getType().ordinal());
        this.writeUTF("");
        this.writeInternal(nbt);
    }

    private void writeInternal(BaseTag<?> tag) throws IOException {
        switch (tag.getType()) {
            case BYTE: {
                this.writeByte(((ByteTag)tag).getData());
                break;
            }
            case SHORT: {
                this.writeShort(((ShortTag)tag).getData());
                break;
            }
            case INT: {
                this.writeInt(((IntTag)tag).getData());
                break;
            }
            case LONG: {
                this.writeLong(((LongTag)tag).getData());
                break;
            }
            case FLOAT: {
                this.writeFloat(((FloatTag)tag).getData());
                break;
            }
            case DOUBLE: {
                this.writeDouble(((DoubleTag)tag).getData());
                break;
            }
            case BYTE_ARRAY: {
                byte[] data = ((ByteArrayTag)tag).getData();
                this.writeInt(data.length);
                this.write(data);
                break;
            }
            case STRING: {
                this.writeUTF(((StringTag)tag).getData());
                break;
            }
            case LIST: {
                ListTag list = (ListTag)tag;
                this.writeByte(list.getElementType().ordinal());
                int size = list.size();
                this.writeInt(size);
                for (int i = 0; i < size; ++i) {
                    this.writeInternal((BaseTag)list.get(i));
                }
                break;
            }
            case COMPOUND: {
                CompoundTag compound = (CompoundTag)tag;
                for (Map.Entry entry : compound.entrySet()) {
                    this.writeByte(((BaseTag)entry.getValue()).getType().ordinal());
                    this.writeUTF((String)entry.getKey());
                    this.writeInternal((BaseTag)entry.getValue());
                }
                this.writeByte(TagType.END.ordinal());
                break;
            }
            case INT_ARRAY: {
                int[] data = ((IntArrayTag)tag).getData();
                int length = data.length;
                this.writeInt(length);
                for (int i = 0; i < length; ++i) {
                    this.writeInt(data[i]);
                }
                break;
            }
            case LONG_ARRAY: {
                long[] data = ((LongArrayTag)tag).getData();
                int length = data.length;
                this.writeInt(length);
                for (int i = 0; i < length; ++i) {
                    this.writeLong(data[i]);
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown tag type: " + String.valueOf((Object)tag.getType()));
            }
        }
    }
}

