/*
 * Decompiled with CFR 0.152.
 */
package de.iani.cubesideutils.bukkit.items;

import de.iani.cubesideutils.ComponentUtilAdventure;
import de.iani.cubesideutils.StringUtil;
import de.iani.cubesideutils.adventure.translations.CubesideTranslations;
import de.iani.cubesideutils.bukkit.StringUtilBukkit;
import de.iani.cubesideutils.bukkit.items.Enchantments;
import de.iani.cubesideutils.bukkit.items.ItemGroups;
import de.iani.cubesideutils.bukkit.items.ItemStackAndAmount;
import de.iani.cubesideutils.bukkit.items.ItemStackPrepareForSerializationEvent;
import de.iani.cubesideutils.bukkit.items.ItemStackRestoreAfterDeserializationEvent;
import io.papermc.paper.datacomponent.DataComponentType;
import io.papermc.paper.datacomponent.DataComponentTypes;
import io.papermc.paper.datacomponent.item.TooltipDisplay;
import io.papermc.paper.registry.RegistryAccess;
import io.papermc.paper.registry.RegistryKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.Style;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.kyori.adventure.translation.Translatable;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.block.BlockState;
import org.bukkit.block.Container;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EquipmentSlotGroup;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BlockStateMeta;
import org.bukkit.inventory.meta.BookMeta;
import org.bukkit.inventory.meta.BundleMeta;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionType;

public class ItemStacks {
    private static final NamespacedKey attackSpeedKey = NamespacedKey.fromString((String)"cubesideutils:attackspeed");
    private static final NamespacedKey attackDamageKey = NamespacedKey.fromString((String)"cubesideutils:attackdamage");

    private ItemStacks() {
        throw new UnsupportedOperationException("No instance for you, Sir!");
    }

    public static ItemStack unbreakable(ItemStack itemStack) {
        ItemMeta meta = itemStack.getItemMeta();
        meta.setUnbreakable(true);
        itemStack.setItemMeta(meta);
        return itemStack;
    }

    public static ItemStack hideProperties(ItemStack itemStack) {
        TooltipDisplay existing = (TooltipDisplay)itemStack.getData(DataComponentTypes.TOOLTIP_DISPLAY);
        TooltipDisplay.Builder display = TooltipDisplay.tooltipDisplay();
        for (DataComponentType dataComponentType : RegistryAccess.registryAccess().getRegistry(RegistryKey.DATA_COMPONENT_TYPE)) {
            if (dataComponentType == DataComponentTypes.LORE) continue;
            display.addHiddenComponents(new DataComponentType[]{dataComponentType});
        }
        if (existing != null) {
            if (existing.hideTooltip()) {
                display.hideTooltip(true);
            }
            if (existing.hiddenComponents().contains(DataComponentTypes.LORE)) {
                display.addHiddenComponents(new DataComponentType[]{DataComponentTypes.LORE});
            }
        }
        itemStack.setData(DataComponentTypes.TOOLTIP_DISPLAY, (Object)((TooltipDisplay)display.build()));
        return itemStack;
    }

    public static ItemStack enchant(ItemStack itemStack, Enchantment enchantment, int level) {
        ItemMeta meta = itemStack.getItemMeta();
        Enchantments.addEnchant(meta, enchantment, level, true);
        itemStack.setItemMeta(meta);
        return itemStack;
    }

    public static ItemStack lore(ItemStack itemStack, String ... lore) {
        ItemMeta meta = itemStack.getItemMeta();
        if (lore == null || lore.length == 0) {
            meta.lore(null);
        } else {
            meta.lore(List.of(lore).stream().map(s -> LegacyComponentSerializer.legacySection().deserialize(s)).toList());
        }
        itemStack.setItemMeta(meta);
        return itemStack;
    }

    public static ItemStack lore(ItemStack itemStack, Component ... lore) {
        ItemMeta meta = itemStack.getItemMeta();
        meta.lore(lore == null || lore.length == 0 ? null : List.of(lore));
        itemStack.setItemMeta(meta);
        return itemStack;
    }

    public static ItemStack rename(ItemStack itemStack, String name) {
        ItemMeta meta = itemStack.getItemMeta();
        meta.displayName((Component)LegacyComponentSerializer.legacySection().deserialize(name));
        itemStack.setItemMeta(meta);
        return itemStack;
    }

    public static ItemStack rename(ItemStack itemStack, Component name) {
        ItemMeta meta = itemStack.getItemMeta();
        meta.displayName(name);
        itemStack.setItemMeta(meta);
        return itemStack;
    }

    public static ItemStack amount(ItemStack itemStack, int amount) {
        itemStack.setAmount(amount);
        return itemStack;
    }

    public static ItemStack colorize(ItemStack itemStack, Color color) {
        ItemMeta meta = itemStack.getItemMeta();
        if (meta instanceof LeatherArmorMeta) {
            ((LeatherArmorMeta)meta).setColor(color);
        }
        itemStack.setItemMeta(meta);
        return itemStack;
    }

    public static ItemStack potion(ItemStack itemStack, PotionType potion) {
        ItemMeta meta = itemStack.getItemMeta();
        if (meta instanceof PotionMeta) {
            PotionMeta potionMeta = (PotionMeta)meta;
            potionMeta.setBasePotionType(potion);
        }
        itemStack.setItemMeta(meta);
        return itemStack;
    }

    public static ItemStack fastPvP(ItemStack itemStack) {
        if (itemStack == null || itemStack.getType() == Material.AIR) {
            return itemStack;
        }
        ItemMeta meta = itemStack.getItemMeta();
        Material type = itemStack.getType();
        double addDamage = Double.NaN;
        if (type == Material.WOODEN_SWORD) {
            addDamage = 3.0;
        } else if (type == Material.GOLDEN_SWORD) {
            addDamage = 3.0;
        } else if (type == Material.STONE_SWORD) {
            addDamage = 4.0;
        } else if (type == Material.IRON_SWORD) {
            addDamage = 5.0;
        } else if (type == Material.DIAMOND_SWORD) {
            addDamage = 6.0;
        } else if (type == Material.NETHERITE_SWORD) {
            addDamage = 7.0;
        }
        if (!Double.isNaN(addDamage)) {
            meta.removeAttributeModifier(Attribute.ATTACK_SPEED);
            meta.addAttributeModifier(Attribute.ATTACK_SPEED, new AttributeModifier(attackSpeedKey, 1.5, AttributeModifier.Operation.ADD_NUMBER, EquipmentSlotGroup.MAINHAND));
            meta.removeAttributeModifier(Attribute.ATTACK_DAMAGE);
            meta.addAttributeModifier(Attribute.ATTACK_DAMAGE, new AttributeModifier(attackDamageKey, addDamage, AttributeModifier.Operation.ADD_NUMBER, EquipmentSlotGroup.MAINHAND));
        }
        itemStack.setItemMeta(meta);
        return itemStack;
    }

    public static ItemStack[] deepCopy(ItemStack[] of) {
        ItemStack[] result = new ItemStack[of.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = of[i] == null ? null : of[i].clone();
        }
        return result;
    }

    public static boolean removeFromInventoryIfContainsAll(Inventory inventory, ItemStackAndAmount ... items) {
        ItemStack[] contents = ItemStacks.deepCopy(inventory.getStorageContents());
        for (ItemStackAndAmount item : items) {
            if (item == null || item.stack() == null || ItemGroups.isAir(item.stack().getType())) continue;
            int remaining = item.amount();
            int firstSimilar = -1;
            while (remaining > 0) {
                firstSimilar = ItemStacks.getFirstSimilar(item.stack(), contents, firstSimilar + 1);
                if (firstSimilar < 0) {
                    return false;
                }
                ItemStack content = contents[firstSimilar];
                int here = content.getAmount();
                if (here > remaining) {
                    content.setAmount(here - remaining);
                    remaining = 0;
                    continue;
                }
                contents[firstSimilar] = null;
                remaining -= here;
            }
        }
        inventory.setStorageContents(contents);
        return true;
    }

    public static boolean addToInventoryIfFits(Inventory inventory, ItemStackAndAmount ... items) {
        ItemStack[] contents = ItemStacks.deepCopy(inventory.getStorageContents());
        for (ItemStackAndAmount item : items) {
            int remaining;
            int add;
            if (item == null || item.stack() == null || ItemGroups.isAir(item.stack().getType())) continue;
            int firstPartial = -1;
            for (remaining = item.amount(); remaining > 0 && (firstPartial = ItemStacks.getFirstPartial(item.stack(), contents, firstPartial + 1)) >= 0; remaining -= add) {
                ItemStack content = contents[firstPartial];
                add = Math.min(content.getMaxStackSize() - content.getAmount(), remaining);
                content.setAmount(content.getAmount() + add);
            }
            int firstFree = -1;
            while (remaining > 0) {
                ItemStack content;
                if ((firstFree = ItemStacks.getFirstFree(contents, firstFree + 1)) < 0) {
                    return false;
                }
                contents[firstFree] = content = new ItemStack(item.stack());
                int add2 = Math.min(Math.max(content.getMaxStackSize(), 1), remaining);
                content.setAmount(add2);
                remaining -= add2;
            }
        }
        inventory.setStorageContents(contents);
        return true;
    }

    public static boolean addToInventoryIfFits(Inventory inventory, ItemStack ... items) {
        ItemStack[] contents = ItemStacks.deepCopy(inventory.getStorageContents());
        for (ItemStack item : items) {
            int remaining;
            int add;
            if (item == null || ItemGroups.isAir(item.getType())) continue;
            int firstPartial = -1;
            for (remaining = item.getAmount(); remaining > 0 && (firstPartial = ItemStacks.getFirstPartial(item, contents, firstPartial + 1)) >= 0; remaining -= add) {
                ItemStack content = contents[firstPartial];
                add = Math.min(content.getMaxStackSize() - content.getAmount(), remaining);
                content.setAmount(content.getAmount() + add);
            }
            int firstFree = -1;
            while (remaining > 0) {
                ItemStack content;
                if ((firstFree = ItemStacks.getFirstFree(contents, firstFree + 1)) < 0) {
                    return false;
                }
                contents[firstFree] = content = new ItemStack(item);
                int add2 = Math.min(Math.max(content.getMaxStackSize(), 1), remaining);
                content.setAmount(add2);
                remaining -= add2;
            }
        }
        inventory.setStorageContents(contents);
        return true;
    }

    private static int getFirstSimilar(ItemStack item, ItemStack[] contents, int start) {
        for (int i = start; i < contents.length; ++i) {
            ItemStack content = contents[i];
            if (content == null || !content.isSimilar(item)) continue;
            return i;
        }
        return -1;
    }

    private static int getFirstPartial(ItemStack item, ItemStack[] contents, int start) {
        for (int i = start; i < contents.length; ++i) {
            ItemStack content = contents[i];
            if (content == null || !content.isSimilar(item) || content.getAmount() >= content.getMaxStackSize()) continue;
            return i;
        }
        return -1;
    }

    private static int getFirstFree(ItemStack[] contents, int start) {
        for (int i = start; i < contents.length; ++i) {
            ItemStack content = contents[i];
            if (content != null && content.getAmount() != 0 && !ItemGroups.isAir(content.getType())) continue;
            return i;
        }
        return -1;
    }

    public static Map<ItemStack, Integer> countItems(ItemStack[] items) {
        LinkedHashMap<ItemStack, Integer> counts = new LinkedHashMap<ItemStack, Integer>();
        for (ItemStack item : items) {
            if (item == null || item.getAmount() == 0 || item.getType() == Material.AIR) continue;
            ItemStack key = item.clone();
            key.setAmount(1);
            counts.merge(key, item.getAmount(), (old, add) -> old + add);
        }
        return counts;
    }

    public static int countStacks(Map<ItemStack, Integer> itemCounts) {
        return itemCounts.entrySet().stream().mapToInt(entry -> (int)Math.ceil((double)((Integer)entry.getValue()).intValue() / (double)((ItemStack)entry.getKey()).getMaxStackSize())).sum();
    }

    public static ItemStack[] fromAmounts(Map<ItemStack, Integer> amounts) {
        ArrayList<ItemStack> resultList = new ArrayList<ItemStack>();
        for (Map.Entry<ItemStack, Integer> entry : amounts.entrySet()) {
            ItemStack item = entry.getKey();
            for (int count = entry.getValue().intValue(); count > 0; count -= Math.min(count, Math.max(1, item.getMaxStackSize()))) {
                item = item.clone();
                item.setAmount(Math.min(count, Math.max(1, item.getMaxStackSize())));
                resultList.add(item);
            }
        }
        return resultList.toArray(new ItemStack[resultList.size()]);
    }

    public static ItemStack[] shrink(ItemStack[] items) {
        return ItemStacks.fromAmounts(ItemStacks.countItems(items));
    }

    public static boolean isEmpty(ItemStack stack) {
        return stack == null || stack.getType() == Material.AIR || stack.getAmount() == 0;
    }

    public static boolean isEmpty(ItemStack[] items) {
        for (ItemStack item : items) {
            if (item == null || item.getAmount() <= 0 || item.getType() == Material.AIR) continue;
            return false;
        }
        return true;
    }

    public static boolean isSimilar(ItemStack i1, ItemStack i2) {
        if (i1 == null) {
            return i2 == null;
        }
        return i1.isSimilar(i2);
    }

    public static ItemStack[] doesHave(Player player, ItemStack[] items, boolean removeIfYes) {
        return ItemStacks.doesHave(player, items, removeIfYes, true);
    }

    public static ItemStack[] doesHave(Player player, ItemStack[] items, boolean removeIfYes, boolean includeNonStorage) {
        return ItemStacks.doesHave(player, items, removeIfYes, includeNonStorage, null);
    }

    public static ItemStack[] doesHave(Player player, ItemStack[] items, boolean removeIfYes, boolean includeNonStorage, DataComponentType[] ignoredComponents) {
        items = ItemStacks.deepCopy(items);
        ItemStack[] oldContents = includeNonStorage ? player.getInventory().getContents() : player.getInventory().getStorageContents();
        ItemStack[] contents = ItemStacks.deepCopy(oldContents);
        ItemStack[] filteredItems = null;
        ItemStack[] filteredContents = null;
        boolean anyRealFilteredComponents = false;
        if (ignoredComponents != null && ignoredComponents.length > 0) {
            boolean cloned;
            ItemStack stack;
            int j;
            filteredItems = new ItemStack[items.length];
            for (j = 0; j < items.length; ++j) {
                stack = items[j];
                if (stack == null) continue;
                cloned = false;
                for (DataComponentType ignored : ignoredComponents) {
                    if (!stack.isDataOverridden(ignored)) continue;
                    if (!cloned) {
                        stack = stack.clone();
                        cloned = true;
                    }
                    stack.resetData(ignored);
                    anyRealFilteredComponents = true;
                }
                filteredItems[j] = stack;
            }
            filteredContents = new ItemStack[contents.length];
            for (j = 0; j < contents.length; ++j) {
                stack = contents[j];
                if (stack == null) continue;
                cloned = false;
                for (DataComponentType ignored : ignoredComponents) {
                    if (!stack.isDataOverridden(ignored)) continue;
                    if (!cloned) {
                        stack = stack.clone();
                        cloned = true;
                    }
                    stack.resetData(ignored);
                    anyRealFilteredComponents = true;
                }
                filteredContents[j] = stack;
            }
        }
        boolean has = true;
        block4: for (int j = 0; j < items.length; ++j) {
            ItemStack toStack = items[j];
            ItemStack toStackCheck = anyRealFilteredComponents ? filteredItems[j] : toStack;
            for (int i = 0; i < contents.length; ++i) {
                ItemStack hisStackCheck;
                ItemStack hisStack = contents[i];
                ItemStack itemStack = hisStackCheck = anyRealFilteredComponents ? filteredContents[i] : hisStack;
                if (hisStack == null || hisStack.getAmount() <= 0 || !ItemStacks.isSimilar(hisStackCheck, toStackCheck)) continue;
                if (toStack.getAmount() > hisStack.getAmount()) {
                    toStack.setAmount(toStack.getAmount() - hisStack.getAmount());
                    contents[i] = null;
                    if (!anyRealFilteredComponents) continue;
                    toStackCheck.setAmount(toStack.getAmount());
                    filteredContents[i] = null;
                    continue;
                }
                if (toStack.getAmount() < hisStack.getAmount()) {
                    hisStack.setAmount(hisStack.getAmount() - toStack.getAmount());
                    toStack.setAmount(0);
                    if (!anyRealFilteredComponents) continue block4;
                    hisStackCheck.setAmount(hisStack.getAmount());
                    toStackCheck.setAmount(0);
                    continue block4;
                }
                contents[i] = null;
                toStack.setAmount(0);
                if (!anyRealFilteredComponents) continue block4;
                filteredContents[i] = null;
                toStackCheck.setAmount(0);
                continue block4;
            }
            has = false;
        }
        if (!has) {
            ItemStack[] missing = ItemStacks.shrink(items);
            if (missing.length == 0) {
                throw new AssertionError();
            }
            return missing;
        }
        if (removeIfYes) {
            if (includeNonStorage) {
                player.getInventory().setContents(contents);
            } else {
                player.getInventory().setStorageContents(contents);
            }
            player.updateInventory();
        }
        return new ItemStack[0];
    }

    public static boolean equals(ItemStack[] i1, ItemStack[] i2) {
        return ItemStacks.countItems(i1).equals(ItemStacks.countItems(i2));
    }

    public static ItemStack prepareForSerialization(ItemStack stack) {
        if (stack == null) {
            return null;
        }
        ItemStackPrepareForSerializationEvent event = new ItemStackPrepareForSerializationEvent(stack);
        event.callEvent();
        stack = event.getStack();
        ItemMeta meta = stack.getItemMeta();
        if (meta instanceof BlockStateMeta) {
            BlockState blockState;
            BlockStateMeta blockStateMeta = (BlockStateMeta)meta;
            if (blockStateMeta.hasBlockState() && (blockState = blockStateMeta.getBlockState()) != null && blockState instanceof Container) {
                Container container = (Container)blockState;
                Inventory inv = container.getSnapshotInventory();
                ItemStack[] contents = inv.getContents();
                boolean modified = false;
                for (int i = 0; i < contents.length; ++i) {
                    ItemStack newContent;
                    ItemStack oldContent = contents[i];
                    if (oldContent == null || Objects.equals(oldContent, newContent = ItemStacks.prepareForSerialization(oldContent))) continue;
                    contents[i] = newContent;
                    modified = true;
                }
                if (modified) {
                    inv.setContents(contents);
                    blockStateMeta.setBlockState(blockState);
                    stack = stack.clone();
                    stack.setItemMeta((ItemMeta)blockStateMeta);
                }
            }
        } else if (meta instanceof BundleMeta) {
            BundleMeta bundleMeta = (BundleMeta)meta;
            ItemStack[] contents = (ItemStack[])bundleMeta.getItems().toArray(ItemStack[]::new);
            boolean modified = false;
            for (int i = 0; i < contents.length; ++i) {
                ItemStack newContent;
                ItemStack oldContent = contents[i];
                if (oldContent == null || Objects.equals(oldContent, newContent = ItemStacks.prepareForSerialization(oldContent))) continue;
                contents[i] = newContent;
                modified = true;
            }
            if (modified) {
                bundleMeta.setItems(Arrays.asList(contents));
                stack = stack.clone();
                stack.setItemMeta((ItemMeta)bundleMeta);
            }
        }
        return stack;
    }

    public static ItemStack restoreAfterDeserialization(ItemStack stack) {
        if (stack == null) {
            return null;
        }
        ItemStackRestoreAfterDeserializationEvent event = new ItemStackRestoreAfterDeserializationEvent(stack);
        event.callEvent();
        stack = event.getStack();
        ItemMeta meta = stack.getItemMeta();
        if (meta instanceof BlockStateMeta) {
            BlockState blockState;
            BlockStateMeta blockStateMeta = (BlockStateMeta)meta;
            if (blockStateMeta.hasBlockState() && (blockState = blockStateMeta.getBlockState()) != null && blockState instanceof Container) {
                Container container = (Container)blockState;
                Inventory inv = container.getSnapshotInventory();
                ItemStack[] contents = inv.getContents();
                boolean modified = false;
                for (int i = 0; i < contents.length; ++i) {
                    ItemStack newContent;
                    ItemStack oldContent = contents[i];
                    if (oldContent == null || Objects.equals(oldContent, newContent = ItemStacks.restoreAfterDeserialization(oldContent))) continue;
                    contents[i] = newContent;
                    modified = true;
                }
                if (modified) {
                    inv.setContents(contents);
                    blockStateMeta.setBlockState(blockState);
                    stack = stack.clone();
                    stack.setItemMeta((ItemMeta)blockStateMeta);
                }
            }
        } else if (meta instanceof BundleMeta) {
            BundleMeta bundleMeta = (BundleMeta)meta;
            ItemStack[] contents = (ItemStack[])bundleMeta.getItems().toArray(ItemStack[]::new);
            boolean modified = false;
            for (int i = 0; i < contents.length; ++i) {
                ItemStack newContent;
                ItemStack oldContent = contents[i];
                if (oldContent == null || Objects.equals(oldContent, newContent = ItemStacks.restoreAfterDeserialization(oldContent))) continue;
                contents[i] = newContent;
                modified = true;
            }
            if (modified) {
                bundleMeta.setItems(Arrays.asList(contents));
                stack = stack.clone();
                stack.setItemMeta((ItemMeta)bundleMeta);
            }
        }
        return stack;
    }

    public static String getBase64StringFromItemStack(ItemStack stack) {
        if (stack == null) {
            return null;
        }
        return Base64.getEncoder().encodeToString(stack.serializeAsBytes());
    }

    public static ItemStack getItemStackFromBase64(String itemString) {
        if (itemString == null) {
            return null;
        }
        return ItemStack.deserializeBytes((byte[])Base64.getDecoder().decode(itemString));
    }

    public static Component toComponent(ItemStack[] items) {
        return ItemStacks.toComponent(items, Style.empty());
    }

    public static Component toComponent(ItemStack[] items, Style style) {
        TreeMap<ItemStack, Integer> itemMap = new TreeMap<ItemStack, Integer>((item1, item2) -> {
            if (item1.isSimilar(item2)) {
                return 0;
            }
            int result = item1.getType().compareTo((Enum)item2.getType());
            if (result != 0) {
                return result;
            }
            if (item1.getItemMeta().hasDisplayName()) {
                if (!item2.getItemMeta().hasDisplayName()) return 1;
                result = ComponentUtilAdventure.TEXT_ONLY_ORDER.compare(item1.getItemMeta().displayName(), item2.getItemMeta().displayName());
            } else if (item2.getItemMeta().hasDisplayName()) {
                return -1;
            }
            if (result == 0) return item1.getItemMeta().toString().compareTo(item2.getItemMeta().toString());
            return result;
        });
        Arrays.stream(items).filter(item -> item != null && item.getType() != Material.AIR && item.getAmount() > 0).forEach(item -> itemMap.merge((ItemStack)item, item.getAmount(), (v1, v2) -> v1 + v2));
        return ItemStacks.toComponent(itemMap, style);
    }

    public static Component toComponent(Map<ItemStack, Integer> amounts) {
        return ItemStacks.toComponent(amounts, Style.empty());
    }

    public static Component toComponent(Map<ItemStack, Integer> amounts, Style style) {
        Component[] components = new Component[amounts.size()];
        int index = 0;
        for (ItemStack item : amounts.keySet()) {
            int amount = amounts.get(item);
            Component component = ItemStacks.toComponent(item, amount, style);
            if (index + 1 < amounts.size()) {
                component = index + 2 < amounts.size() ? Component.textOfChildren((ComponentLike[])new ComponentLike[]{component, Component.text((String)", ")}) : Component.textOfChildren((ComponentLike[])new ComponentLike[]{component, Component.space(), CubesideTranslations.Components.AND, Component.space()});
            }
            components[index] = component;
            ++index;
        }
        return Component.textOfChildren((ComponentLike[])components).style(style);
    }

    public static Component toComponent(ItemStack item) {
        return ItemStacks.toComponent(item, item.getAmount(), Style.empty());
    }

    public static Component toComponent(ItemStack item, int amount) {
        return ItemStacks.toComponent(item, amount, Style.empty());
    }

    public static Component toComponent(ItemStack item, Style style) {
        return ItemStacks.toComponent(item, item.getAmount(), style);
    }

    public static Component toComponent(ItemStack item, int amount, Style style) {
        HashMap enchantments;
        PotionMeta potionMeta;
        Damageable damageableMeta;
        BookMeta bm;
        boolean itemTypeHidden;
        Component nameComponent;
        LeatherArmorMeta armorMeta;
        Color color;
        TextComponent result = Component.text((String)(amount + " "));
        ItemMeta meta = item.getItemMeta();
        if (meta instanceof LeatherArmorMeta && (color = (armorMeta = (LeatherArmorMeta)meta).getColor()).asRGB() != 10511680) {
            result = result.append(StringUtilBukkit.toComponent(color)).append((Component)Component.space());
        }
        if ((nameComponent = item.effectiveName()).style().equals((Object)Style.style((TextColor)NamedTextColor.WHITE))) {
            nameComponent = nameComponent.style(Style.empty());
        }
        result = result.append(nameComponent);
        boolean openedParanthesese = itemTypeHidden = meta != null && meta.hasDisplayName() || meta instanceof BookMeta && (bm = (BookMeta)meta).hasTitle();
        if (itemTypeHidden) {
            result = result.append((Component)Component.text((String)" (")).append((Component)Component.translatable((Translatable)item.getType()));
        }
        if (meta instanceof Damageable && (damageableMeta = (Damageable)meta).hasDamage()) {
            result = result.append(new ComponentLike[]{Component.text((char)':'), Component.text((int)damageableMeta.getDamage())});
        }
        if (meta instanceof PotionMeta && (potionMeta = (PotionMeta)meta).getAllEffects().size() > 0) {
            openedParanthesese = true;
            result = itemTypeHidden ? result.append((Component)Component.text((String)", ")) : result.append((Component)Component.text((String)" ("));
            int index = 0;
            for (PotionEffect effect : potionMeta.getAllEffects()) {
                if (index > 0) {
                    result = index + 1 < potionMeta.getCustomEffects().size() ? result.append((Component)Component.text((String)", ")) : result.append((Component)Component.space()).append(CubesideTranslations.Components.AND).append((Component)Component.space());
                }
                result = result.append((Component)Component.translatable((Translatable)effect.getType()));
                if (effect.getAmplifier() > 0) {
                    result = result.append(new ComponentLike[]{Component.text((String)" "), Component.text((String)StringUtil.toRomanNumber(effect.getAmplifier()))});
                }
                if (!effect.getType().isInstant()) {
                    result = result.append(new ComponentLike[]{Component.text((String)" ("), Component.text((String)StringUtil.formatTimespan(50 * effect.getDuration(), "", "", "", "", ":", ":", false, true)), Component.text((String)")")});
                }
                ++index;
            }
        }
        if (openedParanthesese) {
            result = result.append((Component)Component.text((String)")"));
        }
        if (meta instanceof BookMeta) {
            BookMeta bookMeta = (BookMeta)meta;
            if (bookMeta.hasAuthor()) {
                result = result.append((Component)Component.space()).append((Component)Component.translatable((String)"book.byAuthor", (ComponentLike[])new ComponentLike[]{bookMeta.author()}));
            }
            if (bookMeta.hasGeneration()) {
                BookMeta.Generation gen = bookMeta.getGeneration();
                int genNumber = switch (gen) {
                    default -> throw new MatchException(null, null);
                    case BookMeta.Generation.ORIGINAL -> 0;
                    case BookMeta.Generation.COPY_OF_ORIGINAL -> 1;
                    case BookMeta.Generation.COPY_OF_COPY -> 2;
                    case BookMeta.Generation.TATTERED -> 3;
                };
                result = result.append((Component)Component.text((String)" (")).append((Component)Component.translatable((String)("book.generation." + genNumber))).append((Component)Component.text((String)")"));
            }
        }
        HashMap hashMap = enchantments = meta == null ? Collections.emptyMap() : new HashMap(meta.getEnchants());
        if (meta instanceof EnchantmentStorageMeta) {
            EnchantmentStorageMeta enchMeta = (EnchantmentStorageMeta)meta;
            enchantments.putAll(enchMeta.getStoredEnchants());
        }
        if (!enchantments.isEmpty()) {
            result = result.append((Component)Component.space()).append(CubesideTranslations.Components.ENCHANTED_WITH).append((Component)Component.space());
            ArrayList enchList = new ArrayList(enchantments.keySet());
            enchList.sort(Comparator.comparing(Enchantment::description, ComponentUtilAdventure.TEXT_ONLY_ORDER));
            int index = 0;
            for (Enchantment ench : enchList) {
                result = result.append(ench.description());
                if (ench.getMaxLevel() > 1 || (Integer)enchantments.get(ench) > 1) {
                    result = result.append(new ComponentLike[]{Component.space(), Component.text((String)StringUtil.toRomanNumber((Integer)enchantments.get(ench)))});
                }
                if (index + 1 < enchantments.size()) {
                    result = index + 2 < enchantments.size() ? result.append((Component)Component.text((String)", ")) : result.append((Component)Component.space()).append(CubesideTranslations.Components.AND).append((Component)Component.space());
                }
                ++index;
            }
        }
        return result.style(style).hoverEvent((HoverEventSource)item.asHoverEvent());
    }

    public static Component toComponent(Material m) {
        return Component.translatable((Translatable)m);
    }

    public static String toNiceString(Material m) {
        return StringUtil.capitalizeFirstLetter(m.name(), true);
    }
}

