/*
 * Decompiled with CFR 0.152.
 */
package de.iani.cubesideutils.bukkit.items;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.bukkit.Material;

public class MaterialUtils {
    private static final Map<Material, Set<Material>> PLACED_AS_BLOCK = new HashMap<Material, Set<Material>>();

    private MaterialUtils() {
        throw new UnsupportedOperationException("No instance for you, Sir!");
    }

    public static Set<Material> getPlacedMaterials(Material item) {
        return PLACED_AS_BLOCK.get(item);
    }

    static {
        for (Material m : Material.values()) {
            Material placement;
            if (m.isLegacy() || !m.isBlock() || (placement = m.createBlockData().getPlacementMaterial()) == null) continue;
            PLACED_AS_BLOCK.computeIfAbsent(placement, placement2 -> new HashSet()).add(m);
        }
        PLACED_AS_BLOCK.computeIfAbsent(Material.BAMBOO, placement2 -> new HashSet()).add(Material.BAMBOO_SAPLING);
        for (Map.Entry entry : PLACED_AS_BLOCK.entrySet()) {
            entry.setValue(Set.of((Material[])((Set)entry.getValue()).toArray(Material[]::new)));
        }
    }
}

