/*
 * Decompiled with CFR 0.152.
 */
package de.iani.cubesideutils;

import java.util.Map;
import java.util.Objects;

public class Pair<T, S> {
    public final T first;
    public final S second;

    public Pair(T first, S second) {
        this.first = first;
        this.second = second;
    }

    public Pair(Map<String, Object> serialized) {
        this.first = serialized.get("first");
        this.second = serialized.get("second");
    }

    public <X> Pair<X, S> setFirst(X first) {
        return new Pair<X, S>(first, this.second);
    }

    public <X> Pair<T, X> setSecond(X second) {
        return new Pair<T, X>(this.first, second);
    }

    public T first() {
        return this.first;
    }

    public S second() {
        return this.second;
    }

    public String toString() {
        return "(" + String.valueOf(this.first) + ";" + String.valueOf(this.second) + ")";
    }

    public int hashCode() {
        return Objects.hashCode(this.first) + 31 * Objects.hashCode(this.second);
    }

    public boolean equals(Object other) {
        if (!(other instanceof Pair)) {
            return false;
        }
        Pair op = (Pair)other;
        return Objects.equals(this.first, op.first) && Objects.equals(this.second, op.second);
    }
}

