/*
 * Decompiled with CFR 0.152.
 */
package de.iani.cubesideutils;

import de.iani.cubesideutils.ComponentUtilAdventure;
import de.iani.cubesideutils.adventure.translations.GlobalAndMinecraftTranslator;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Locale;
import net.kyori.adventure.text.Component;

public class FontUtilAdventure {
    public static final int BOOK_LINE_WIDTH = 110;
    private static byte[] charWidth = new byte[65536];

    public static boolean fitsSingleBookPage(Collection<Component> text) {
        return FontUtilAdventure.fitsSingleBookPage((Component[])text.toArray(Component[]::new));
    }

    public static boolean fitsSingleBookPage(Locale locale, Collection<Component> text) {
        return FontUtilAdventure.fitsSingleBookPage(locale, (Component[])text.toArray(Component[]::new));
    }

    public static boolean fitsSingleBookPage(Component ... text) {
        return FontUtilAdventure.fitsSingleBookPage(Locale.US, text);
    }

    public static boolean fitsSingleBookPage(Locale locale, Component ... text) {
        if (text == null) {
            return true;
        }
        if (locale == null) {
            locale = Locale.US;
        }
        StringBuilder sb = new StringBuilder();
        for (Component c : text) {
            sb.append(ComponentUtilAdventure.toLegacy(GlobalAndMinecraftTranslator.render(c, locale)));
        }
        return FontUtilAdventure.fitsSingleBookPage(sb.toString());
    }

    public static boolean fitsSingleBookPage(String string) {
        return FontUtilAdventure.getBookLines(string) <= 14;
    }

    public static int getBookLines(String string) {
        return FontUtilAdventure.splitStringForLineWidth(FontUtilAdventure.trimTrailingNewlines(string), 110).length;
    }

    private static String trimTrailingNewlines(String string) {
        while (string.endsWith("\n")) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    public static String[] splitStringForLineWidth(String string, int availableWidth) {
        return FontUtilAdventure.wrapString(string, availableWidth).split("\n");
    }

    private static String wrapString(String string, int availableWidth) {
        int charactersInLine = FontUtilAdventure.getFittingCharacters(string, availableWidth);
        if (string.length() <= charactersInLine) {
            return string;
        }
        String thisLine = string.substring(0, charactersInLine);
        char firstRemainingCharacter = string.charAt(charactersInLine);
        boolean removeFirstRemainingChar = firstRemainingCharacter == ' ' || firstRemainingCharacter == '\n';
        String remaining = FontUtilAdventure.extractFormatingFromString(thisLine) + string.substring(charactersInLine + (removeFirstRemainingChar ? 1 : 0));
        return thisLine + "\n" + FontUtilAdventure.wrapString(remaining, availableWidth);
    }

    private static int getFittingCharacters(String string, int availableWidth) {
        int pos;
        int stringLength = string.length();
        int totalWidth = 0;
        int lastSpace = -1;
        boolean bold = false;
        for (pos = 0; pos < stringLength; ++pos) {
            char c = string.charAt(pos);
            switch (c) {
                case '\n': {
                    lastSpace = pos;
                    break;
                }
                case '\u00a7': {
                    char colorChar;
                    if (pos >= stringLength - 1 || !FontUtilAdventure.isFormatCharacter(colorChar = string.charAt(pos + 1))) break;
                    ++pos;
                    if (colorChar != 'l' && colorChar != 'L') {
                        if (colorChar != 'r' && colorChar != 'R' && !FontUtilAdventure.isFormatColor(colorChar)) break;
                        bold = false;
                        break;
                    }
                    bold = true;
                    break;
                }
                case ' ': {
                    lastSpace = pos;
                }
                default: {
                    totalWidth += FontUtilAdventure.getCharWidth(c) + (bold ? 1 : 0);
                }
            }
            if (c == '\n' || totalWidth > availableWidth) break;
        }
        return pos != stringLength && lastSpace != -1 && lastSpace < pos ? lastSpace : pos;
    }

    public static int getCharWidth(char c) {
        return charWidth[c];
    }

    private static boolean isFormatColor(char c) {
        return c >= '0' && c <= '9' || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F';
    }

    private static boolean isFormatSpecialCharacter(char c) {
        return c >= 'k' && c <= 'o' || c >= 'K' && c <= 'O' || c == 'r' || c == 'R' || c == 'x' || c == 'X';
    }

    private static boolean isFormatCharacter(char c) {
        return FontUtilAdventure.isFormatColor(c) || FontUtilAdventure.isFormatSpecialCharacter(c);
    }

    private static String extractFormatingFromString(String string) {
        Object formatingString = "";
        int formatingInitialCharacter = -1;
        int stringLength = string.length();
        while ((formatingInitialCharacter = string.indexOf(167, formatingInitialCharacter + 1)) != -1) {
            if (formatingInitialCharacter >= stringLength - 1) continue;
            char colorCharacter = string.charAt(formatingInitialCharacter + 1);
            if (FontUtilAdventure.isFormatColor(colorCharacter)) {
                formatingString = "\u00a7" + colorCharacter;
                continue;
            }
            if (!FontUtilAdventure.isFormatSpecialCharacter(colorCharacter)) continue;
            formatingString = (String)formatingString + "\u00a7" + colorCharacter;
        }
        return formatingString;
    }

    static {
        try (InputStream is = FontUtilAdventure.class.getClassLoader().getResourceAsStream("char_sizes.bin");){
            is.read(charWidth);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

