/*
 * Decompiled with CFR 0.152.
 */
package de.iani.cubesideutils.commands;

import de.iani.cubesideutils.commands.ArgsParser;
import de.iani.cubesideutils.commands.SubCommand;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.command.BlockCommandSender;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.entity.minecart.CommandMinecart;
import org.bukkit.util.StringUtil;

public abstract class HybridCommand
extends SubCommand
implements CommandExecutor,
TabCompleter {
    public boolean onCommand(CommandSender sender, Command command, String alias, String[] args) {
        if (!this.allowsCommandBlock() && (sender instanceof BlockCommandSender || sender instanceof CommandMinecart)) {
            sender.sendMessage(ChatColor.RED + "This command is not allowed for CommandBlocks!");
        }
        if (this.requiresPlayer() && !(sender instanceof Player)) {
            sender.sendMessage(ChatColor.RED + "This command can only be executed by players!");
        }
        if (this.getRequiredPermission() != null && !sender.hasPermission(this.getRequiredPermission())) {
            sender.sendMessage(ChatColor.RED + "No permission!");
            return true;
        }
        return this.onCommand(sender, command, alias, "/" + alias, new ArgsParser(args));
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (!this.allowsCommandBlock() && (sender instanceof BlockCommandSender || sender instanceof CommandMinecart)) {
            return Collections.emptyList();
        }
        if (this.requiresPlayer() && !(sender instanceof Player)) {
            return Collections.emptyList();
        }
        if (this.getRequiredPermission() != null && !sender.hasPermission(this.getRequiredPermission())) {
            return Collections.emptyList();
        }
        Collection<String> options = this.onTabComplete(sender, command, alias, new ArgsParser(args));
        if (options == null) {
            return null;
        }
        List result = (List)StringUtil.copyPartialMatches((String)(args.length > 0 ? args[args.length - 1] : ""), options, new ArrayList());
        Collections.sort(result);
        return result;
    }
}

