/*
 * Decompiled with CFR 0.152.
 */
package de.iani.cubesideutils;

import de.iani.cubesideutils.Locatable;
import de.iani.cubesideutils.RandomUtil;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class Particles {
    private static int MAX_COLOR_VALUE = 0xFFFFFF;

    private Particles() {
        throw new UnsupportedOperationException("No instance for you, Sir!");
    }

    public static void spawnParticles(Player player, Particle particle, double amount, double x, double y, double z, double offsetX, double offsetY, double offsetZ, double extra, Object data) {
        int intAmount = (int)Math.floor(amount) + (Math.random() < amount - Math.floor(amount) ? 1 : 0);
        boolean randomColor = particle == Particle.REDSTONE && data == null;
        for (int i = 0; i < intAmount; ++i) {
            double newX = x + 2.0 * Math.random() * offsetX - offsetX;
            double newY = y + 2.0 * Math.random() * offsetY - offsetY;
            double newZ = z + 2.0 * Math.random() * offsetZ - offsetZ;
            if (randomColor) {
                data = new Particle.DustOptions(Color.fromRGB((int)RandomUtil.SHARED_RANDOM.nextInt(MAX_COLOR_VALUE)), 1.0f);
            }
            player.spawnParticle(Particle.REDSTONE, newX, newY, newZ, 1, 0.0, 0.0, 0.0, extra, data);
        }
    }

    public static void spawnParticles(Player player, Particle particle, double amount, Location location, double offsetX, double offsetY, double offsetZ, double extra, Object data) {
        if (location.getWorld() != player.getWorld()) {
            return;
        }
        Particles.spawnParticles(player, particle, amount, location.getX(), location.getY(), location.getZ(), offsetX, offsetY, offsetZ, extra, data);
    }

    public static void spawnColoredDust(Player player, double amount, double x, double y, double z, double offsetX, double offsetY, double offsetZ, Color color) {
        Particles.spawnParticles(player, Particle.REDSTONE, amount, x, y, z, offsetX, offsetY, offsetZ, 1.0, (Object)(color == null ? null : new Particle.DustOptions(color, 1.0f)));
    }

    public static void spawnColoredDust(Player player, double amount, Location location, double offsetX, double offsetY, double offsetZ, Color color) {
        Particles.spawnParticles(player, Particle.REDSTONE, amount, location, offsetX, offsetY, offsetZ, 1.0, color == null ? null : new Particle.DustOptions(color, 1.0f));
    }

    public static int spawnParticles(Plugin plugin, final Player player, final Particle particle, final double amountPerTick, final int numberOfTicks, final Locatable location, final double offsetX, final double offsetY, final double offsetZ, final double extra, final Object ... datas) {
        if (numberOfTicks == 0) {
            return -1;
        }
        BukkitTask runnable = new BukkitRunnable(){
            private int count = 0;

            public void run() {
                if (!player.isValid()) {
                    this.cancel();
                    return;
                }
                Location loc = location.getLocation();
                Object data = datas == null || datas.length == 0 ? null : datas[RandomUtil.SHARED_RANDOM.nextInt(datas.length)];
                Particles.spawnParticles(player, particle, amountPerTick, loc, offsetX, offsetY, offsetZ, extra, data);
                if (this.count >= 0 && ++this.count >= numberOfTicks) {
                    this.cancel();
                }
            }
        }.runTaskTimer(plugin, 0L, 1L);
        return runnable.getTaskId();
    }

    public static int spawnParticles(Plugin plugin, Player player, Particle particle, double amountPerTick, int numberOfTicks, double x, double y, double z, double offsetX, double offsetY, double offsetZ, double extra, Object data) {
        Location location = player.getLocation();
        location.set(x, y, z);
        return Particles.spawnParticles(plugin, player, particle, amountPerTick, numberOfTicks, new Locatable.LocationWrapper(location), offsetX, offsetY, offsetZ, extra, data);
    }

    public static int spawnColoredDust(Plugin plugin, Player player, double amountPerTick, int numberOfTicks, Locatable location, double offsetX, double offsetY, double offsetZ, Color ... colors) {
        Object[] datas;
        if (colors == null || colors.length == 0) {
            datas = null;
        } else {
            datas = new Object[colors.length];
            for (int i = 0; i < datas.length; ++i) {
                datas[i] = colors[i] == null ? null : new Particle.DustOptions(colors[i], 1.0f);
            }
        }
        return Particles.spawnParticles(plugin, player, Particle.REDSTONE, amountPerTick, numberOfTicks, location, offsetX, offsetY, offsetZ, 1.0, datas);
    }

    public static int spawnColoredDust(Plugin plugin, Player player, double amountPerTick, int numberOfTicks, double x, double y, double z, double offsetX, double offsetY, double offsetZ, Color ... colors) {
        Location location = player.getLocation();
        location.set(x, y, z);
        return Particles.spawnColoredDust(plugin, player, amountPerTick, numberOfTicks, new Locatable.LocationWrapper(location), offsetX, offsetY, offsetZ, colors);
    }
}

