/*
 * Decompiled with CFR 0.152.
 */
package de.iani.cubesideutils;

import org.bukkit.ChatColor;
import org.bukkit.Location;

public class StringUtil {
    public static String capitalizeFirstLetter(String s, boolean replaceUnderscores) {
        char[] cap = s.toCharArray();
        boolean lastSpace = true;
        for (int i = 0; i < cap.length; ++i) {
            char c = cap[i];
            if (c == '_') {
                if (replaceUnderscores) {
                    c = ' ';
                }
                lastSpace = true;
            } else if (c >= '0' && c <= '9' || c == '(' || c == ')') {
                lastSpace = true;
            } else {
                c = lastSpace ? Character.toUpperCase(c) : Character.toLowerCase(c);
                lastSpace = false;
            }
            cap[i] = c;
        }
        return new String(cap);
    }

    public static String formatBlockLocationWithoutWorld(Location loc) {
        return loc.getBlockX() + "," + loc.getBlockY() + "," + loc.getBlockZ();
    }

    public static String convertColors(String text) {
        if (text == null) {
            return null;
        }
        StringBuilder builder = null;
        int len = text.length();
        for (int i = 0; i < len; ++i) {
            char next;
            char current = text.charAt(i);
            if (current == '&' && i + 1 < len && (ChatColor.getByChar((char)(next = text.charAt(i + 1))) != null || next == '&')) {
                if (builder == null) {
                    builder = new StringBuilder();
                    builder.append(text, 0, i);
                }
                ++i;
                if (next != '&') {
                    builder.append('\u00a7').append(next);
                    continue;
                }
            }
            if (builder == null) continue;
            builder.append(current);
        }
        return builder == null ? text : builder.toString();
    }
}

