/*
 * Decompiled with CFR 0.152.
 */
package de.iani.cubesidestats;

import de.iani.cubesidestats.CubesideStatisticsImplementation;
import de.iani.cubesidestats.StatisticsDatabase;
import de.iani.cubesidestats.api.SettingKey;
import java.sql.SQLException;
import java.util.Objects;
import java.util.logging.Level;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.YamlConfiguration;

public class SettingKeyImplementation
implements SettingKey {
    private final int id;
    private final String name;
    private final CubesideStatisticsImplementation stats;
    private String displayName;
    private int def;

    public SettingKeyImplementation(int id, String name, String properties, CubesideStatisticsImplementation impl) {
        this.id = id;
        this.name = name;
        this.stats = impl;
        this.def = 0;
        YamlConfiguration conf = new YamlConfiguration();
        if (properties != null) {
            try {
                conf.loadFromString(properties);
            }
            catch (InvalidConfigurationException e) {
                impl.getPlugin().getLogger().log(Level.SEVERE, "Could not load properties for settings key " + name + " (" + id + ")", e);
            }
        }
        this.displayName = conf.getString("displayName");
        this.def = conf.getInt("default");
    }

    public String getSerializedProperties() {
        YamlConfiguration conf = new YamlConfiguration();
        conf.set("displayName", (Object)this.displayName);
        conf.set("default", (Object)this.def);
        return conf.saveToString();
    }

    private void save() {
        final SettingKeyImplementation clone = new SettingKeyImplementation(this.id, this.name, null, this.stats);
        clone.copyPropertiesFrom(this);
        this.stats.getWorkerThread().addWork(new CubesideStatisticsImplementation.WorkEntry(){

            @Override
            public void process(StatisticsDatabase database) {
                try {
                    database.updateSettingKey(clone);
                }
                catch (SQLException e) {
                    SettingKeyImplementation.this.stats.getPlugin().getLogger().log(Level.SEVERE, "Could not save achivement key " + SettingKeyImplementation.this.name, e);
                }
            }
        });
    }

    public int getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setDisplayName(String name) {
        if (!Objects.equals(this.displayName, name)) {
            this.displayName = name;
            this.save();
        }
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public void setDefault(int def) {
        if (this.def != def) {
            this.def = def;
            this.save();
        }
    }

    @Override
    public int getDefault() {
        return this.def;
    }

    public void copyPropertiesFrom(SettingKeyImplementation e) {
        this.displayName = e.displayName;
        this.def = e.def;
    }
}

