/*
 * Decompiled with CFR 0.152.
 */
package de.iani.settings.libs.de.iani.cubesideutils;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.HoverEvent;
import org.bukkit.command.CommandSender;

public class ChatUtil {
    public static final int PAGE_LENGTH = 10;

    private ChatUtil() {
        throw new UnsupportedOperationException("No instance for you, Sir!");
    }

    public static List<Sendable> stringToSendableList(List<String> msges) {
        ArrayList<Sendable> result = new ArrayList<Sendable>(msges.size());
        for (String msg : msges) {
            result.add(new StringMsg(msg));
        }
        return result;
    }

    public static List<Sendable> bcToSendableList(List<BaseComponent[]> msges) {
        ArrayList<Sendable> result = new ArrayList<Sendable>(msges.size());
        for (BaseComponent[] msg : msges) {
            result.add(new ComponentMsg(msg));
        }
        return result;
    }

    public static void sendMessagesPaged(CommandSender recipient, List<? extends Sendable> messages, int page, String name, String openPageCommandPrefix) {
        ChatUtil.sendMessagesPaged(recipient, messages, page, name, openPageCommandPrefix, "");
    }

    public static void sendMessagesPaged(CommandSender recipient, List<? extends Sendable> messages, int page, String name, String openPageCommandPrefix, String pluginPrefix) {
        ChatUtil.sendMessagesPaged(recipient, messages, page, name, openPageCommandPrefix, pluginPrefix, ChatColor.GREEN, ChatColor.GOLD);
    }

    public static void sendMessagesPaged(CommandSender recipient, List<? extends Sendable> messages, int page, String name, String openPageCommandPrefix, String pluginPrefix, ChatColor normalColor, ChatColor warningColor) {
        int numPages = (int)Math.ceil((double)messages.size() / 10.0);
        if (page >= numPages) {
            ChatUtil.sendMessage(recipient, pluginPrefix, warningColor.toString(), name, " hat keine Seite ", page + 1);
            return;
        }
        if (numPages > 1) {
            ChatUtil.sendMessage(recipient, pluginPrefix, normalColor.toString(), name, " (Seite ", page + 1, "/", numPages, "):");
        } else {
            ChatUtil.sendMessage(recipient, pluginPrefix, normalColor.toString(), name, ":");
        }
        int index = page * 10;
        for (int i = 0; i < 10 && index < messages.size(); ++i, ++index) {
            messages.get(index).send(recipient);
        }
        if (numPages > 1) {
            ClickEvent ce;
            HoverEvent he;
            ChatUtil.sendMessage(recipient, pluginPrefix, normalColor.toString(), "Seite x anzeigen: ", openPageCommandPrefix, " x");
            ComponentBuilder builder = new ComponentBuilder(pluginPrefix).append(" << vorherige");
            if (page > 0) {
                builder.color(ChatColor.BLUE);
                he = new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder("Seite " + page + " anzeigen").create());
                ce = new ClickEvent(ClickEvent.Action.RUN_COMMAND, openPageCommandPrefix + " " + page);
                builder.event(he).event(ce);
            } else {
                builder.color(ChatColor.GRAY);
                he = new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder("Bereits auf Seite 1").create());
                builder.event(he);
            }
            builder.append("   ").reset().append("n\u00e4chste >>");
            if (page + 1 < numPages) {
                builder.color(ChatColor.BLUE);
                he = new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder("Seite " + (page + 2) + " anzeigen").create());
                ce = new ClickEvent(ClickEvent.Action.RUN_COMMAND, openPageCommandPrefix + " " + (page + 2));
                builder.event(he).event(ce);
            } else {
                builder.color(ChatColor.GRAY);
                he = new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder("Bereits auf Seite " + numPages).create());
                builder.event(he);
            }
            recipient.sendMessage(builder.create());
        }
    }

    public static void sendMessage(CommandSender sender, String pluginPrefix, String colors, Object message, Object ... messageParts) {
        if (messageParts.length == 0) {
            sender.sendMessage(pluginPrefix + " " + (colors == null ? "" : colors) + message);
        } else {
            StringBuilder builder = new StringBuilder(pluginPrefix).append(" ").append(colors == null ? "" : colors).append(message);
            for (Object s : messageParts) {
                if (colors != null) {
                    builder.append(ChatColor.RESET).append(colors);
                }
                builder.append(Objects.toString(s));
            }
            sender.sendMessage(builder.toString());
        }
    }

    public static class ComponentMsg
    implements Sendable {
        public final BaseComponent[] msg;

        public ComponentMsg(BaseComponent[] msg) {
            this.msg = msg;
        }

        @Override
        public void send(CommandSender recipient) {
            recipient.sendMessage(this.msg);
        }
    }

    public static class StringMsg
    implements Sendable {
        public final String msg;

        public StringMsg(String msg) {
            this.msg = msg;
        }

        @Override
        public void send(CommandSender recipient) {
            recipient.sendMessage(this.msg);
        }
    }

    public static interface Sendable {
        public void send(CommandSender var1);
    }
}

