/*
 * Decompiled with CFR 0.152.
 */
package de.diddiz.LogBlock.util;

import de.diddiz.LogBlock.componentwrapper.ChatColor;
import de.diddiz.LogBlock.componentwrapper.Click;
import de.diddiz.LogBlock.componentwrapper.Component;
import de.diddiz.LogBlock.componentwrapper.Components;
import de.diddiz.LogBlock.componentwrapper.Hover;
import de.diddiz.LogBlock.config.Config;
import de.diddiz.LogBlock.util.ActionColor;
import de.diddiz.LogBlock.util.TypeColor;
import de.diddiz.LogBlock.util.Utils;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.EntityType;

public class MessagingUtil {
    public static Component formatSummarizedChanges(int created, int destroyed, Component actor, int createdWidth, int destroyedWidth, float spaceFactor) {
        Component textCreated = MessagingUtil.createTextComponentWithColor(created + Utils.spaces((int)((float)(10 - String.valueOf(created).length()) / spaceFactor)), ActionColor.CREATE.getColor());
        Component textDestroyed = MessagingUtil.createTextComponentWithColor(destroyed + Utils.spaces((int)((float)(10 - String.valueOf(destroyed).length()) / spaceFactor)), ActionColor.DESTROY.getColor());
        Component result = Components.empty();
        result = result.append(textCreated);
        result = result.append(textDestroyed);
        result = result.append(actor);
        return result;
    }

    public static Component createTextComponentWithColor(String text, ChatColor color) {
        return Components.text(text, color, new Component[0]);
    }

    public static Component brackets(BracketType type, Component ... content) {
        Component tc = MessagingUtil.createTextComponentWithColor(type.getStarting(), TypeColor.BRACKETS.getColor());
        for (Component c : content) {
            tc = tc.append(c);
        }
        tc = tc.append(Components.text(type.getEnding()));
        return tc;
    }

    public static Component prettyDate(long date) {
        Component tc = MessagingUtil.brackets(BracketType.STANDARD, MessagingUtil.createTextComponentWithColor(Config.formatterShort.format(date), TypeColor.DATE.getColor()));
        tc = tc.hover(Hover.text(Config.formatter.format(date)));
        return tc;
    }

    public static Component prettyState(String stateName) {
        return MessagingUtil.createTextComponentWithColor(stateName, TypeColor.STATE.getColor());
    }

    public static Component prettyState(Component stateName) {
        Component tc = Components.text("", TypeColor.STATE.getColor(), new Component[0]);
        if (stateName != null) {
            tc = ((Component)tc).append(stateName);
        }
        return tc;
    }

    public static Component prettyState(int stateValue) {
        return MessagingUtil.prettyState(Integer.toString(stateValue));
    }

    public static <E extends Enum<E>> Component prettyState(E enumerator) {
        return MessagingUtil.prettyState(enumerator.toString());
    }

    public static Component prettyMaterial(String materialName) {
        return MessagingUtil.createTextComponentWithColor(materialName.toUpperCase(), TypeColor.MATERIAL.getColor());
    }

    public static Component prettyMaterial(Material material) {
        return MessagingUtil.prettyMaterial(material.name());
    }

    public static Component prettyMaterial(BlockData material) {
        int bracket2;
        Component tc = MessagingUtil.prettyMaterial(material.getMaterial());
        String bdString = material.getAsString();
        int bracket = bdString.indexOf("[");
        if (bracket >= 0 && (bracket2 = bdString.indexOf("]", bracket)) >= 0) {
            String state = bdString.substring(bracket + 1, bracket2).replace(',', '\n');
            tc = tc.hover(Hover.text(state));
        }
        return tc;
    }

    public static Component prettyEntityType(EntityType type) {
        return MessagingUtil.prettyMaterial(type.name());
    }

    public static Component prettyLocation(Location loc, int entryId) {
        return MessagingUtil.prettyLocation(loc.getBlockX(), loc.getBlockY(), loc.getBlockZ(), entryId);
    }

    public static Component prettyLocation(int x, int y, int z, int entryId) {
        Component tc = MessagingUtil.createTextComponentWithColor("", TypeColor.DEFAULT.getColor());
        tc = tc.append(MessagingUtil.createTextComponentWithColor(Integer.toString(x), TypeColor.COORDINATE.getColor()));
        tc = tc.append(MessagingUtil.createTextComponentWithColor(", ", TypeColor.DEFAULT.getColor()));
        tc = tc.append(MessagingUtil.createTextComponentWithColor(Integer.toString(y), TypeColor.COORDINATE.getColor()));
        tc = tc.append(MessagingUtil.createTextComponentWithColor(", ", TypeColor.DEFAULT.getColor()));
        tc = tc.append(MessagingUtil.createTextComponentWithColor(Integer.toString(z), TypeColor.COORDINATE.getColor()));
        if (entryId > 0) {
            tc = tc.click(Click.run("/lb tp " + entryId));
            tc = tc.hover(Hover.text("Teleport here"));
        }
        return tc;
    }

    public static enum BracketType {
        STANDARD("[", "]"),
        ANGLE("<", ">");

        private String starting;
        private String ending;

        private BracketType(String starting, String ending) {
            this.starting = starting;
            this.ending = ending;
        }

        public String getStarting() {
            return this.starting;
        }

        public String getEnding() {
            return this.ending;
        }
    }
}

