/*
 * Decompiled with CFR 0.152.
 */
package de.diddiz.LogBlock.addons.worldguard;

import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldguard.LocalPlayer;
import com.sk89q.worldguard.WorldGuard;
import com.sk89q.worldguard.bukkit.WorldGuardPlugin;
import com.sk89q.worldguard.protection.ApplicableRegionSet;
import com.sk89q.worldguard.protection.association.RegionAssociable;
import com.sk89q.worldguard.protection.flags.Flag;
import com.sk89q.worldguard.protection.flags.StateFlag;
import com.sk89q.worldguard.protection.flags.registry.FlagConflictException;
import com.sk89q.worldguard.protection.flags.registry.FlagRegistry;
import de.diddiz.LogBlock.LogBlock;
import de.diddiz.LogBlock.events.BlockChangePreLogEvent;
import de.diddiz.LogBlock.events.EntityChangePreLogEvent;
import java.util.logging.Level;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class WorldGuardLoggingFlagsManager {
    private final StateFlag LOGBLOCK_LOG_BLOCKS = new StateFlag("logblock-log-blocks", true);
    private final StateFlag LOGBLOCK_LOG_ENTITIES = new StateFlag("logblock-log-entities", true);
    private LogBlock plugin;
    private WorldGuardPlugin worldGuard;

    public WorldGuardLoggingFlagsManager(LogBlock plugin) {
        this.plugin = plugin;
    }

    public void onPluginLoad() {
        this.registerFlags();
    }

    public void onPluginEnable() {
        this.worldGuard = (WorldGuardPlugin)this.plugin.getServer().getPluginManager().getPlugin("WorldGuard");
        this.plugin.getServer().getPluginManager().registerEvents((Listener)new LoggingListener(), (Plugin)this.plugin);
    }

    private void registerFlags() {
        try {
            FlagRegistry registry = WorldGuard.getInstance().getFlagRegistry();
            registry.register((Flag)this.LOGBLOCK_LOG_BLOCKS);
            registry.register((Flag)this.LOGBLOCK_LOG_ENTITIES);
        }
        catch (FlagConflictException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Could not initialize Flags", e);
        }
    }

    private class LoggingListener
    implements Listener {
        private LoggingListener() {
        }

        @EventHandler(ignoreCancelled=true)
        public void onBlockChangePreLog(BlockChangePreLogEvent event) {
            LocalPlayer regionAssociable = null;
            Location location = event.getLocation();
            Entity actorEntity = event.getOwnerActor().getEntity();
            if (actorEntity instanceof Player) {
                regionAssociable = WorldGuardLoggingFlagsManager.this.worldGuard.wrapPlayer((Player)actorEntity);
            }
            ApplicableRegionSet set = WorldGuard.getInstance().getPlatform().getRegionContainer().createQuery().getApplicableRegions(BukkitAdapter.adapt((Location)location));
            if (!set.testState((RegionAssociable)regionAssociable, new StateFlag[]{WorldGuardLoggingFlagsManager.this.LOGBLOCK_LOG_BLOCKS})) {
                event.setCancelled(true);
                WorldGuardLoggingFlagsManager.this.plugin.getLogger().info("Not logging BlockChange at " + location);
            } else {
                WorldGuardLoggingFlagsManager.this.plugin.getLogger().info("Logging BlockChange at " + location);
            }
        }

        @EventHandler(ignoreCancelled=true)
        public void onEntityChangePreLog(EntityChangePreLogEvent event) {
            LocalPlayer regionAssociable = null;
            Location location = event.getLocation();
            Entity actorEntity = event.getOwnerActor().getEntity();
            if (actorEntity instanceof Player) {
                regionAssociable = WorldGuardLoggingFlagsManager.this.worldGuard.wrapPlayer((Player)actorEntity);
            }
            ApplicableRegionSet set = WorldGuard.getInstance().getPlatform().getRegionContainer().createQuery().getApplicableRegions(BukkitAdapter.adapt((Location)location));
            if (!set.testState((RegionAssociable)regionAssociable, new StateFlag[]{WorldGuardLoggingFlagsManager.this.LOGBLOCK_LOG_ENTITIES})) {
                event.setCancelled(true);
                WorldGuardLoggingFlagsManager.this.plugin.getLogger().info("Not logging EntityChange at " + location);
            } else {
                WorldGuardLoggingFlagsManager.this.plugin.getLogger().info("Logging EntityChange at " + location);
            }
        }
    }
}

