/*
 * Decompiled with CFR 0.152.
 */
package de.diddiz.util;

import de.diddiz.LogBlock.LogBlock;
import de.diddiz.util.BukkitUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipException;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.inventory.ItemStack;

public class Utils {
    public static String newline = System.getProperty("line.separator");
    private static final char[] hexArray = "0123456789ABCDEF".toCharArray();

    public static boolean isInt(String str) {
        try {
            Integer.parseInt(str);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public static boolean isShort(String str) {
        try {
            Short.parseShort(str);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public static boolean isByte(String str) {
        try {
            Byte.parseByte(str);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public static String listing(String[] entries, String delimiter, String finalDelimiter) {
        int len = entries.length;
        if (len == 0) {
            return "";
        }
        if (len == 1) {
            return entries[0];
        }
        StringBuilder builder = new StringBuilder(entries[0]);
        int i = 1;
        while (i < len - 1) {
            builder.append(delimiter).append(entries[i]);
            ++i;
        }
        builder.append(finalDelimiter).append(entries[len - 1]);
        return builder.toString();
    }

    public static String listing(List<?> entries, String delimiter, String finalDelimiter) {
        int len = entries.size();
        if (len == 0) {
            return "";
        }
        if (len == 1) {
            return entries.get(0).toString();
        }
        StringBuilder builder = new StringBuilder(entries.get(0).toString());
        int i = 1;
        while (i < len - 1) {
            builder.append(delimiter).append(entries.get(i).toString());
            ++i;
        }
        builder.append(finalDelimiter).append(entries.get(len - 1).toString());
        return builder.toString();
    }

    /*
     * Unable to fully structure code
     */
    public static int parseTimeSpec(String[] spec) {
        block19: {
            block20: {
                if (spec == null || spec.length < 1 || spec.length > 2) {
                    return -1;
                }
                if (spec.length == 1 && Utils.isInt(spec[0])) {
                    return Integer.valueOf(spec[0]);
                }
                if (spec[0].contains(":") || spec[0].contains(".")) break block19;
                if (spec.length == 2) {
                    if (!Utils.isInt(spec[0])) {
                        return -1;
                    }
                    min = Integer.parseInt(spec[0]);
                    if (spec[1].startsWith("h")) {
                        min *= 60;
                    } else if (spec[1].startsWith("d")) {
                        min *= 1440;
                    }
                    return min;
                }
                if (spec.length != 1) break block20;
                days = 0;
                hours = 0;
                minutes = 0;
                lastIndex = 0;
                currIndex = 1;
                ** GOTO lbl39
                {
                    ++currIndex;
                    do {
                        if (currIndex <= spec[0].length() && Utils.isInt(spec[0].substring(lastIndex, currIndex))) continue block2;
                        if (currIndex - 1 != lastIndex) {
                            if (currIndex > spec[0].length()) {
                                return -1;
                            }
                            param = spec[0].substring(currIndex - 1, currIndex).toLowerCase();
                            if (param.equals("d")) {
                                days = Integer.parseInt(spec[0].substring(lastIndex, currIndex - 1));
                            } else if (param.equals("h")) {
                                hours = Integer.parseInt(spec[0].substring(lastIndex, currIndex - 1));
                            } else if (param.equals("m")) {
                                minutes = Integer.parseInt(spec[0].substring(lastIndex, currIndex - 1));
                            }
                        }
                        lastIndex = currIndex++;
lbl39:
                        // 2 sources

                    } while (currIndex <= spec[0].length());
                }
                if (days == 0 && hours == 0 && minutes == 0) {
                    return -1;
                }
                return minutes + hours * 60 + days * 1440;
            }
            return -1;
        }
        timestamp = spec.length == 1 ? (spec[0].contains(":") ? String.valueOf(new SimpleDateFormat("dd.MM.yyyy").format(System.currentTimeMillis())) + " " + spec[0] : String.valueOf(spec[0]) + " 00:00:00") : String.valueOf(spec[0]) + " " + spec[1];
        try {
            return (int)((System.currentTimeMillis() - new SimpleDateFormat("dd.MM.yyyy HH:mm:ss").parse(timestamp).getTime()) / 60000L);
        }
        catch (ParseException ex) {
            return -1;
        }
    }

    public static String spaces(int count) {
        StringBuilder filled = new StringBuilder(count);
        int i = 0;
        while (i < count) {
            filled.append(' ');
            ++i;
        }
        return filled.toString();
    }

    public static String join(String[] s, String delimiter) {
        if (s == null || s.length == 0) {
            return "";
        }
        int len = s.length;
        StringBuilder builder = new StringBuilder(s[0]);
        int i = 1;
        while (i < len) {
            builder.append(delimiter).append(s[i]);
            ++i;
        }
        return builder.toString();
    }

    public static List<String> parseQuotes(List<String> args) {
        ArrayList<String> newArguments = new ArrayList<String>();
        String subjectString = Utils.join(args.toArray(new String[args.size()]), " ");
        Pattern regex = Pattern.compile("[^\\s\"']+|\"[^\"]*\"|'[^']*'");
        Matcher regexMatcher = regex.matcher(subjectString);
        while (regexMatcher.find()) {
            newArguments.add(regexMatcher.group());
        }
        return newArguments;
    }

    public static String mysqlEscapeBytes(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2 + 2];
        hexChars[0] = 48;
        hexChars[1] = 120;
        int j = 0;
        while (j < bytes.length) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2 + 2] = hexArray[v >>> 4];
            hexChars[j * 2 + 3] = hexArray[v & 0xF];
            ++j;
        }
        return new String(hexChars);
    }

    public static String mysqlPrepareBytesForInsertAllowNull(byte[] bytes) {
        if (bytes == null) {
            return "null";
        }
        return "'" + Utils.mysqlEscapeBytes(bytes) + "'";
    }

    public static String mysqlTextEscape(String untrusted) {
        return untrusted.replace("\\", "\\\\").replace("'", "\\'");
    }

    public static ItemStack loadItemStack(byte[] data) {
        if (data == null || data.length == 0) {
            return null;
        }
        YamlConfiguration conf = Utils.deserializeYamlConfiguration(data);
        return conf == null ? null : conf.getItemStack("stack");
    }

    public static byte[] saveItemStack(ItemStack stack) {
        if (stack == null || BukkitUtils.isEmpty(stack.getType())) {
            return null;
        }
        YamlConfiguration conf = new YamlConfiguration();
        conf.set("stack", (Object)stack);
        return Utils.serializeYamlConfiguration(conf);
    }

    public static YamlConfiguration deserializeYamlConfiguration(byte[] data) {
        if (data == null || data.length == 0) {
            return null;
        }
        YamlConfiguration conf = new YamlConfiguration();
        try {
            InputStreamReader reader = new InputStreamReader((InputStream)new GZIPInputStream(new ByteArrayInputStream(data)), "UTF-8");
            conf.load((Reader)reader);
            reader.close();
            return conf;
        }
        catch (ZipException | InvalidConfigurationException e) {
            LogBlock.getInstance().getLogger().warning("Could not deserialize YamlConfiguration: " + e.getMessage());
            return conf;
        }
        catch (IOException e) {
            throw new RuntimeException("IOException should be impossible for ByteArrayInputStream", e);
        }
    }

    public static byte[] serializeYamlConfiguration(YamlConfiguration conf) {
        if (conf == null || conf.getKeys(false).isEmpty()) {
            return null;
        }
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new GZIPOutputStream(baos), "UTF-8");
            writer.write(conf.saveToString());
            writer.close();
            return baos.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException("IOException should be impossible for ByteArrayOutputStream", e);
        }
    }

    public static String serializeForSQL(YamlConfiguration conf) {
        return Utils.mysqlPrepareBytesForInsertAllowNull(Utils.serializeYamlConfiguration(conf));
    }

    public static class ExtensionFilenameFilter
    implements FilenameFilter {
        private final String ext;

        public ExtensionFilenameFilter(String ext) {
            this.ext = "." + ext;
        }

        @Override
        public boolean accept(File dir, String name) {
            return name.toLowerCase().endsWith(this.ext);
        }
    }
}

