/*
 * Decompiled with CFR 0.152.
 */
package de.diddiz.LogBlock;

import de.diddiz.LogBlock.EntityChange;
import de.diddiz.LogBlock.EntityTypeConverter;
import de.diddiz.LogBlock.LogBlock;
import de.diddiz.LogBlock.Logging;
import de.diddiz.LogBlock.MaterialConverter;
import de.diddiz.LogBlock.Session;
import de.diddiz.LogBlock.config.Config;
import de.diddiz.util.BukkitUtils;
import de.diddiz.util.CuboidRegion;
import de.diddiz.util.Utils;
import de.diddiz.worldedit.WorldEditHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Pattern;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Tag;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;

public final class QueryParams
implements Cloneable {
    private static final HashMap<String, Integer> keywords = new HashMap();
    public BlockChangeType bct = BlockChangeType.BOTH;
    public int limit = -1;
    public int before = 0;
    public int since = 0;
    public int radius = -1;
    public Location loc = null;
    public Order order = Order.DESC;
    public List<String> players = new ArrayList<String>();
    public List<String> killers = new ArrayList<String>();
    public List<String> victims = new ArrayList<String>();
    public boolean excludePlayersMode = false;
    public boolean excludeKillersMode = false;
    public boolean excludeVictimsMode = false;
    public boolean excludeBlocksEntitiesMode = false;
    public boolean prepareToolQuery = false;
    public boolean silent = false;
    public boolean noForcedLimit = false;
    public boolean forceReplace = false;
    public boolean noCache = false;
    public CuboidRegion sel = null;
    public SummarizationMode sum = SummarizationMode.NONE;
    public List<Material> types = new ArrayList<Material>();
    public List<Tag<?>> typeTags = new ArrayList();
    public List<Integer> typeIds = new ArrayList<Integer>();
    public List<EntityType> entityTypes = new ArrayList<EntityType>();
    public List<Integer> entityTypeIds = new ArrayList<Integer>();
    public World world = null;
    public String match = null;
    public boolean needCount = false;
    public boolean needId = false;
    public boolean needDate = false;
    public boolean needType = false;
    public boolean needData = false;
    public boolean needPlayerId = false;
    public boolean needPlayer = false;
    public boolean needCoords = false;
    public boolean needChestAccess = false;
    public boolean needMessage = false;
    public boolean needKiller = false;
    public boolean needVictim = false;
    public boolean needWeapon = false;
    private final LogBlock logblock;

    static {
        keywords.put("player", 1);
        keywords.put("area", 0);
        keywords.put("selection", 0);
        keywords.put("sel", 0);
        keywords.put("block", 1);
        keywords.put("type", 1);
        keywords.put("sum", 1);
        keywords.put("destroyed", 0);
        keywords.put("created", 0);
        keywords.put("chestaccess", 0);
        keywords.put("all", 0);
        keywords.put("time", 0);
        keywords.put("since", 0);
        keywords.put("before", 0);
        keywords.put("limit", 1);
        keywords.put("world", 1);
        keywords.put("asc", 0);
        keywords.put("desc", 0);
        keywords.put("last", 0);
        keywords.put("coords", 0);
        keywords.put("silent", 0);
        keywords.put("chat", 0);
        keywords.put("search", 1);
        keywords.put("match", 1);
        keywords.put("loc", 1);
        keywords.put("location", 1);
        keywords.put("kills", 0);
        keywords.put("killer", 1);
        keywords.put("victim", 1);
        keywords.put("both", 0);
        keywords.put("force", 0);
        keywords.put("nocache", 0);
        keywords.put("entities", 0);
        keywords.put("entity", 0);
    }

    public QueryParams(LogBlock logblock) {
        this.logblock = logblock;
    }

    public QueryParams(LogBlock logblock, CommandSender sender, List<String> args) throws IllegalArgumentException {
        this.logblock = logblock;
        this.parseArgs(sender, args);
    }

    public static boolean isKeyWord(String param) {
        return keywords.containsKey(param.toLowerCase());
    }

    public static int getKeyWordMinArguments(String param) {
        Integer minArgs = keywords.get(param.toLowerCase());
        return minArgs == null ? 0 : minArgs;
    }

    public String getLimit() {
        if (this.noForcedLimit || Config.hardLinesLimit <= 0 || this.limit > 0 && this.limit <= Config.hardLinesLimit) {
            return this.limit > 0 ? "LIMIT " + this.limit : "";
        }
        return "LIMIT " + Config.hardLinesLimit;
    }

    public String getFrom() {
        if (this.sum != SummarizationMode.NONE) {
            throw new IllegalStateException("Not implemented for summarization");
        }
        if (this.bct == BlockChangeType.CHAT) {
            String from = "FROM `lb-chat` ";
            if (this.needPlayer || this.players.size() > 0) {
                from = String.valueOf(from) + "INNER JOIN `lb-players` USING (playerid) ";
            }
            return from;
        }
        if (this.bct == BlockChangeType.KILLS) {
            String from = "FROM `" + this.getTable() + "-kills` ";
            if (this.needPlayer || this.needKiller || this.killers.size() > 0) {
                from = String.valueOf(from) + "INNER JOIN `lb-players` as killers ON (killer=killers.playerid) ";
            }
            if (this.needPlayer || this.needVictim || this.victims.size() > 0) {
                from = String.valueOf(from) + "INNER JOIN `lb-players` as victims ON (victim=victims.playerid) ";
            }
            return from;
        }
        if (this.bct == BlockChangeType.ENTITIES || this.bct == BlockChangeType.ENTITIES_CREATED || this.bct == BlockChangeType.ENTITIES_KILLED) {
            String from = "FROM `" + this.getTable() + "-entities` ";
            if (this.needPlayer || this.players.size() > 0) {
                from = String.valueOf(from) + "INNER JOIN `lb-players` USING (playerid) ";
            }
            if (!this.needCount && this.needData) {
                from = String.valueOf(from) + "LEFT JOIN `" + this.getTable() + "-entityids` USING (entityid) ";
            }
            return from;
        }
        String from = "FROM `" + this.getTable() + "-blocks` ";
        if (this.needPlayer || this.players.size() > 0) {
            from = String.valueOf(from) + "INNER JOIN `lb-players` USING (playerid) ";
        }
        if (!this.needCount && this.needData) {
            from = String.valueOf(from) + "LEFT JOIN `" + this.getTable() + "-state` USING (id) ";
        }
        if (this.needChestAccess) {
            from = this.bct == BlockChangeType.CHESTACCESS ? String.valueOf(from) + "RIGHT JOIN `" + this.getTable() + "-chestdata` USING (id) " : String.valueOf(from) + "LEFT JOIN `" + this.getTable() + "-chestdata` USING (id) ";
        }
        return from;
    }

    public String getOrder() {
        if (this.sum != SummarizationMode.NONE) {
            throw new IllegalStateException("Not implemented for summarization");
        }
        int twoDaysInSeconds = 2880;
        if (this.since > 0 && this.since <= 2880) {
            return "ORDER BY date " + (Object)((Object)this.order) + ", id " + (Object)((Object)this.order) + " ";
        }
        return "ORDER BY id " + (Object)((Object)this.order) + " ";
    }

    public String getFields() {
        if (this.sum != SummarizationMode.NONE) {
            throw new IllegalStateException("Not implemented for summarization");
        }
        if (this.bct == BlockChangeType.CHAT) {
            String select = "";
            if (this.needCount) {
                select = String.valueOf(select) + "COUNT(*) AS count ";
            } else {
                if (this.needId) {
                    select = String.valueOf(select) + "id, ";
                }
                if (this.needDate) {
                    select = String.valueOf(select) + "date, ";
                }
                if (this.needPlayer) {
                    select = String.valueOf(select) + "playername, UUID, ";
                }
                if (this.needPlayerId) {
                    select = String.valueOf(select) + "playerid, ";
                }
                if (this.needMessage) {
                    select = String.valueOf(select) + "message, ";
                }
                select = String.valueOf(select.substring(0, select.length() - 2)) + " ";
            }
            return select;
        }
        if (this.bct == BlockChangeType.KILLS) {
            String select = "";
            if (this.needCount) {
                select = String.valueOf(select) + "COUNT(*) AS count ";
            } else {
                if (this.needId) {
                    select = String.valueOf(select) + "id, ";
                }
                if (this.needDate) {
                    select = String.valueOf(select) + "date, ";
                }
                if (this.needPlayer || this.needKiller) {
                    select = String.valueOf(select) + "killers.playername as killer, ";
                }
                if (this.needPlayer || this.needVictim) {
                    select = String.valueOf(select) + "victims.playername as victim, ";
                }
                if (this.needPlayerId) {
                    select = String.valueOf(select) + "killer as killerid, victim as victimid, ";
                }
                if (this.needWeapon) {
                    select = String.valueOf(select) + "weapon, ";
                }
                if (this.needCoords) {
                    select = String.valueOf(select) + "x, y, z, ";
                }
                select = String.valueOf(select.substring(0, select.length() - 2)) + " ";
            }
            return select;
        }
        String select = "";
        if (this.needCount) {
            select = String.valueOf(select) + "COUNT(*) AS count ";
        } else {
            if (this.needId) {
                select = this.bct != BlockChangeType.ENTITIES && this.bct != BlockChangeType.ENTITIES_CREATED && this.bct != BlockChangeType.ENTITIES_KILLED ? String.valueOf(select) + "`" + this.getTable() + "-blocks`.id, " : String.valueOf(select) + "`" + this.getTable() + "-entities`.id, ";
            }
            if (this.needDate) {
                select = String.valueOf(select) + "date, ";
            }
            if (this.bct != BlockChangeType.ENTITIES && this.bct != BlockChangeType.ENTITIES_CREATED && this.bct != BlockChangeType.ENTITIES_KILLED) {
                if (this.needType) {
                    select = String.valueOf(select) + "replaced, type, ";
                }
                if (this.needData) {
                    select = String.valueOf(select) + "replacedData, typeData, ";
                }
            }
            if (this.needPlayer) {
                select = String.valueOf(select) + "playername, UUID, ";
            }
            if (this.needPlayerId) {
                select = String.valueOf(select) + "playerid, ";
            }
            if (this.needCoords) {
                select = String.valueOf(select) + "x, y, z, ";
            }
            if (this.bct != BlockChangeType.ENTITIES && this.bct != BlockChangeType.ENTITIES_CREATED && this.bct != BlockChangeType.ENTITIES_KILLED) {
                if (this.needData) {
                    select = String.valueOf(select) + "replacedState, typeState, ";
                }
                if (this.needChestAccess) {
                    select = String.valueOf(select) + "item, itemremove, itemtype, ";
                }
            } else {
                if (this.needType) {
                    select = String.valueOf(select) + "entitytypeid, action, ";
                }
                if (this.needData) {
                    select = String.valueOf(select) + "entityid, entityuuid, data, ";
                }
            }
            select = String.valueOf(select.substring(0, select.length() - 2)) + " ";
        }
        return select;
    }

    public String getQuery() {
        if (this.sum == SummarizationMode.NONE) {
            return "SELECT " + this.getFields() + this.getFrom() + this.getWhere() + this.getOrder() + this.getLimit();
        }
        if (this.bct == BlockChangeType.CHAT) {
            throw new IllegalStateException("Invalid summarization for chat");
        }
        if (this.bct == BlockChangeType.KILLS) {
            if (this.sum == SummarizationMode.PLAYERS) {
                return "SELECT playername, UUID, SUM(kills) AS kills, SUM(killed) AS killed FROM ((SELECT killer AS playerid, count(*) AS kills, 0 as killed FROM `" + this.getTable() + "-kills` INNER JOIN `lb-players` as killers ON (killer=killers.playerid) INNER JOIN `lb-players` as victims ON (victim=victims.playerid) " + this.getWhere(BlockChangeType.KILLS) + "GROUP BY killer) UNION (SELECT victim AS playerid, 0 as kills, count(*) AS killed FROM `" + this.getTable() + "-kills` INNER JOIN `lb-players` as killers ON (killer=killers.playerid) INNER JOIN `lb-players` as victims ON (victim=victims.playerid) " + this.getWhere(BlockChangeType.KILLS) + "GROUP BY victim)) AS t INNER JOIN `lb-players` USING (playerid) GROUP BY playerid ORDER BY SUM(kills) + SUM(killed) " + (Object)((Object)this.order) + " " + this.getLimit();
            }
            throw new IllegalStateException("Invalid summarization for kills");
        }
        if (this.bct == BlockChangeType.ENTITIES || this.bct == BlockChangeType.ENTITIES_CREATED || this.bct == BlockChangeType.ENTITIES_KILLED) {
            if (this.sum == SummarizationMode.TYPES) {
                return "SELECT entitytypeid, SUM(created) AS created, SUM(destroyed) AS destroyed FROM ((SELECT entitytypeid, count(*) AS created, 0 AS destroyed FROM `" + this.getTable() + "-entities` INNER JOIN `lb-players` USING (playerid) " + this.getWhere(BlockChangeType.ENTITIES_CREATED) + "GROUP BY entitytypeid) UNION (SELECT entitytypeid, 0 AS created, count(*) AS destroyed FROM `" + this.getTable() + "-entities` INNER JOIN `lb-players` USING (playerid) " + this.getWhere(BlockChangeType.ENTITIES_KILLED) + "GROUP BY entitytypeid)) AS t GROUP BY entitytypeid ORDER BY SUM(created) + SUM(destroyed) " + (Object)((Object)this.order) + " " + this.getLimit();
            }
            return "SELECT playername, UUID, SUM(created) AS created, SUM(destroyed) AS destroyed FROM ((SELECT playerid, count(*) AS created, 0 AS destroyed FROM `" + this.getTable() + "-entities` " + this.getWhere(BlockChangeType.ENTITIES_CREATED) + "GROUP BY playerid) UNION (SELECT playerid, 0 AS created, count(*) AS destroyed FROM `" + this.getTable() + "-entities` " + this.getWhere(BlockChangeType.ENTITIES_KILLED) + "GROUP BY playerid)) AS t INNER JOIN `lb-players` USING (playerid) GROUP BY playerid ORDER BY SUM(created) + SUM(destroyed) " + (Object)((Object)this.order) + " " + this.getLimit();
        }
        if (this.sum == SummarizationMode.TYPES) {
            return "SELECT type, SUM(created) AS created, SUM(destroyed) AS destroyed FROM ((SELECT type, count(*) AS created, 0 AS destroyed FROM `" + this.getTable() + "-blocks` INNER JOIN `lb-players` USING (playerid) " + this.getWhere(BlockChangeType.CREATED) + "GROUP BY type) UNION (SELECT replaced AS type, 0 AS created, count(*) AS destroyed FROM `" + this.getTable() + "-blocks` INNER JOIN `lb-players` USING (playerid) " + this.getWhere(BlockChangeType.DESTROYED) + "GROUP BY replaced)) AS t GROUP BY type ORDER BY SUM(created) + SUM(destroyed) " + (Object)((Object)this.order) + " " + this.getLimit();
        }
        return "SELECT playername, UUID, SUM(created) AS created, SUM(destroyed) AS destroyed FROM ((SELECT playerid, count(*) AS created, 0 AS destroyed FROM `" + this.getTable() + "-blocks` " + this.getWhere(BlockChangeType.CREATED) + "GROUP BY playerid) UNION (SELECT playerid, 0 AS created, count(*) AS destroyed FROM `" + this.getTable() + "-blocks` " + this.getWhere(BlockChangeType.DESTROYED) + "GROUP BY playerid)) AS t INNER JOIN `lb-players` USING (playerid) GROUP BY playerid ORDER BY SUM(created) + SUM(destroyed) " + (Object)((Object)this.order) + " " + this.getLimit();
    }

    public String getTable() {
        return Config.getWorldConfig((World)this.world).table;
    }

    public String getTitle() {
        StringBuilder title = new StringBuilder();
        if (this.bct == BlockChangeType.CHESTACCESS) {
            title.append("chest accesses ");
        } else if (this.bct == BlockChangeType.CHAT) {
            title.append("chat messages ");
        } else if (this.bct == BlockChangeType.KILLS) {
            title.append("kills ");
        } else if (this.bct == BlockChangeType.ENTITIES || this.bct == BlockChangeType.ENTITIES_CREATED || this.bct == BlockChangeType.ENTITIES_KILLED) {
            if (!this.entityTypes.isEmpty()) {
                if (this.excludeBlocksEntitiesMode) {
                    title.append("all entities except ");
                }
                String[] entityTypeNames = new String[this.entityTypes.size()];
                int i = 0;
                while (i < this.entityTypes.size()) {
                    entityTypeNames[i] = this.entityTypes.get(i).name();
                    ++i;
                }
                title.append(Utils.listing(entityTypeNames, ", ", " and ")).append(" ");
            } else {
                title.append("entity changes ");
            }
        } else {
            if (!this.types.isEmpty() || !this.typeTags.isEmpty()) {
                if (this.excludeBlocksEntitiesMode) {
                    title.append("all blocks except ");
                }
                String[] blocknames = new String[this.types.size() + this.typeTags.size()];
                int i = 0;
                while (i < this.types.size()) {
                    blocknames[i] = this.types.get(i).name();
                    ++i;
                }
                i = 0;
                while (i < this.typeTags.size()) {
                    blocknames[i + this.types.size()] = "#" + this.typeTags.get(i).getKey().getKey().toUpperCase();
                    ++i;
                }
                title.append(Utils.listing(blocknames, ", ", " and ")).append(" ");
            } else {
                title.append("block ");
            }
            if (this.bct == BlockChangeType.CREATED) {
                title.append("creations ");
            } else if (this.bct == BlockChangeType.DESTROYED) {
                title.append("destructions ");
            } else {
                title.append("changes ");
            }
        }
        if (this.killers.size() > 10) {
            title.append(this.excludeKillersMode ? "without" : "from").append(" many killers ");
        } else if (!this.killers.isEmpty()) {
            title.append(this.excludeKillersMode ? "without" : "from").append(" ").append(Utils.listing(this.killers.toArray(new String[this.killers.size()]), ", ", " and ")).append(" ");
        }
        if (this.victims.size() > 10) {
            title.append(this.excludeVictimsMode ? "without" : "of").append(" many victims ");
        } else if (!this.victims.isEmpty()) {
            title.append(this.excludeVictimsMode ? "without" : "of").append(" victim").append(this.victims.size() != 1 ? "s" : "").append(" ").append(Utils.listing(this.victims.toArray(new String[this.victims.size()]), ", ", " and ")).append(" ");
        }
        if (this.players.size() > 10) {
            title.append(this.excludePlayersMode ? "without" : "from").append(" many players ");
        } else if (!this.players.isEmpty()) {
            title.append(this.excludePlayersMode ? "without" : "from").append(" player").append(this.players.size() != 1 ? "s" : "").append(" ").append(Utils.listing(this.players.toArray(new String[this.players.size()]), ", ", " and ")).append(" ");
        }
        if (this.match != null && this.match.length() > 0) {
            title.append("matching '").append(this.match).append("' ");
        }
        if (this.before > 0 && this.since > 0) {
            title.append("between ").append(this.since).append(" and ").append(this.before).append(" minutes ago ");
        } else if (this.since > 0) {
            title.append("in the last ").append(this.since).append(" minutes ");
        } else if (this.before > 0) {
            title.append("more than ").append(this.before).append(" minutes ago ");
        }
        if (this.loc != null) {
            if (this.radius > 0) {
                title.append("within ").append(this.radius).append(" blocks of ").append(this.prepareToolQuery ? "clicked block" : "location").append(" ");
            } else if (this.radius == 0) {
                title.append("at ").append(this.loc.getBlockX()).append(":").append(this.loc.getBlockY()).append(":").append(this.loc.getBlockZ()).append(" ");
            }
        } else if (this.sel != null) {
            title.append(this.prepareToolQuery ? "at double chest " : "inside selection ");
        } else if (this.prepareToolQuery) {
            if (this.radius > 0) {
                title.append("within ").append(this.radius).append(" blocks of clicked block ");
            } else if (this.radius == 0) {
                title.append("at clicked block ");
            }
        }
        if (!(this.world == null || this.sel != null && this.prepareToolQuery)) {
            title.append("in ").append(BukkitUtils.friendlyWorldname(this.world.getName())).append(" ");
        }
        if (this.sum != SummarizationMode.NONE) {
            title.append("summed up by ").append(this.sum == SummarizationMode.TYPES ? (this.bct == BlockChangeType.ENTITIES || this.bct == BlockChangeType.ENTITIES_CREATED || this.bct == BlockChangeType.ENTITIES_KILLED ? "entities" : "blocks") : "players").append(" ");
        }
        title.deleteCharAt(title.length() - 1);
        title.setCharAt(0, String.valueOf(title.charAt(0)).toUpperCase().toCharArray()[0]);
        return title.toString();
    }

    public String getWhere() {
        return this.getWhere(this.bct);
    }

    public String getWhere(BlockChangeType blockChangeType) {
        StringBuilder where = new StringBuilder("WHERE ");
        if (blockChangeType == BlockChangeType.CHAT) {
            if (this.match != null && this.match.length() > 0) {
                boolean unlike = this.match.startsWith("-");
                if (this.match.length() > 3 && !unlike || this.match.length() > 4) {
                    where.append("MATCH (message) AGAINST ('").append(this.match).append("' IN BOOLEAN MODE) AND ");
                } else {
                    where.append("message ").append(unlike ? "NOT " : "").append("LIKE '%").append(unlike ? this.match.substring(1) : this.match).append("%' AND ");
                }
            }
        } else if (blockChangeType == BlockChangeType.KILLS) {
            if (!this.players.isEmpty()) {
                if (!this.excludePlayersMode) {
                    where.append('(');
                    for (String killerName : this.players) {
                        where.append("killers.playername = '").append(killerName).append("' OR ");
                    }
                    for (String victimName : this.players) {
                        where.append("victims.playername = '").append(victimName).append("' OR ");
                    }
                    where.delete(where.length() - 4, where.length());
                    where.append(") AND ");
                } else {
                    for (String killerName : this.players) {
                        where.append("killers.playername != '").append(killerName).append("' AND ");
                    }
                    for (String victimName : this.players) {
                        where.append("victims.playername != '").append(victimName).append("' AND ");
                    }
                }
            }
            if (!this.killers.isEmpty()) {
                if (!this.excludeKillersMode) {
                    where.append('(');
                    for (String killerName : this.killers) {
                        where.append("killers.playername = '").append(killerName).append("' OR ");
                    }
                    where.delete(where.length() - 4, where.length());
                    where.append(") AND ");
                } else {
                    for (String killerName : this.killers) {
                        where.append("killers.playername != '").append(killerName).append("' AND ");
                    }
                }
            }
            if (!this.victims.isEmpty()) {
                if (!this.excludeVictimsMode) {
                    where.append('(');
                    for (String victimName : this.victims) {
                        where.append("victims.playername = '").append(victimName).append("' OR ");
                    }
                    where.delete(where.length() - 4, where.length());
                    where.append(") AND ");
                } else {
                    for (String victimName : this.victims) {
                        where.append("victims.playername != '").append(victimName).append("' AND ");
                    }
                }
            }
        } else if (blockChangeType == BlockChangeType.ENTITIES || blockChangeType == BlockChangeType.ENTITIES_CREATED || blockChangeType == BlockChangeType.ENTITIES_KILLED) {
            if (!this.entityTypeIds.isEmpty()) {
                if (this.excludeBlocksEntitiesMode) {
                    where.append("NOT ");
                }
                where.append('(');
                for (Integer entityType : this.entityTypeIds) {
                    where.append("(entitytypeid = ").append(entityType);
                    where.append(") OR ");
                }
                where.delete(where.length() - 4, where.length() - 1);
                where.append(") AND ");
            }
            if (blockChangeType == BlockChangeType.ENTITIES_CREATED) {
                where.append("action = " + EntityChange.EntityChangeType.CREATE.ordinal() + " AND ");
            } else if (blockChangeType == BlockChangeType.ENTITIES_KILLED) {
                where.append("action = " + EntityChange.EntityChangeType.KILL.ordinal() + " AND ");
            }
        } else {
            switch (blockChangeType) {
                case ALL: {
                    if (this.typeIds.isEmpty()) break;
                    if (this.excludeBlocksEntitiesMode) {
                        where.append("NOT ");
                    }
                    where.append('(');
                    for (Integer block : this.typeIds) {
                        where.append("((type = ").append(block).append(" OR replaced = ").append(block);
                        where.append(")");
                        where.append(") OR ");
                    }
                    where.delete(where.length() - 4, where.length() - 1);
                    where.append(") AND ");
                    break;
                }
                case BOTH: {
                    if (!this.typeIds.isEmpty()) {
                        if (this.excludeBlocksEntitiesMode) {
                            where.append("NOT ");
                        }
                        where.append('(');
                        for (Integer block : this.typeIds) {
                            where.append("((type = ").append(block).append(" OR replaced = ").append(block);
                            where.append(")");
                            where.append(") OR ");
                        }
                        where.delete(where.length() - 4, where.length());
                        where.append(") AND ");
                    }
                    where.append("type != replaced AND ");
                    break;
                }
                case CREATED: {
                    if (!this.typeIds.isEmpty()) {
                        if (this.excludeBlocksEntitiesMode) {
                            where.append("NOT ");
                        }
                        where.append('(');
                        for (Integer block : this.typeIds) {
                            where.append("((type = ").append(block);
                            where.append(")");
                            where.append(") OR ");
                        }
                        where.delete(where.length() - 4, where.length());
                        where.append(") AND ");
                    }
                    where.append("type != 0 AND type != replaced AND ");
                    break;
                }
                case DESTROYED: {
                    if (!this.typeIds.isEmpty()) {
                        if (this.excludeBlocksEntitiesMode) {
                            where.append("NOT ");
                        }
                        where.append('(');
                        for (Integer block : this.typeIds) {
                            where.append("((replaced = ").append(block);
                            where.append(")");
                            where.append(") OR ");
                        }
                        where.delete(where.length() - 4, where.length());
                        where.append(") AND ");
                    }
                    where.append("replaced != 0 AND type != replaced AND ");
                    break;
                }
                case CHESTACCESS: {
                    if (this.typeIds.isEmpty()) break;
                    if (this.excludeBlocksEntitiesMode) {
                        where.append("NOT ");
                    }
                    where.append('(');
                    for (Integer block : this.typeIds) {
                        where.append("((itemtype = ").append(block);
                        where.append(")");
                        where.append(") OR ");
                    }
                    where.delete(where.length() - 4, where.length());
                    where.append(") AND ");
                    break;
                }
            }
        }
        if (blockChangeType != BlockChangeType.CHAT) {
            if (this.loc != null) {
                if (this.radius == 0) {
                    this.compileLocationQuery(where, this.loc.getBlockX(), this.loc.getBlockX(), this.loc.getBlockY(), this.loc.getBlockY(), this.loc.getBlockZ(), this.loc.getBlockZ());
                } else if (this.radius > 0) {
                    this.compileLocationQuery(where, this.loc.getBlockX() - this.radius + 1, this.loc.getBlockX() + this.radius - 1, this.loc.getBlockY() - this.radius + 1, this.loc.getBlockY() + this.radius - 1, this.loc.getBlockZ() - this.radius + 1, this.loc.getBlockZ() + this.radius - 1);
                }
            } else if (this.sel != null) {
                this.compileLocationQuery(where, this.sel.getMinimumPoint().getBlockX(), this.sel.getMaximumPoint().getBlockX(), this.sel.getMinimumPoint().getBlockY(), this.sel.getMaximumPoint().getBlockY(), this.sel.getMinimumPoint().getBlockZ(), this.sel.getMaximumPoint().getBlockZ());
            }
        }
        if (!this.players.isEmpty() && this.sum != SummarizationMode.PLAYERS && blockChangeType != BlockChangeType.KILLS) {
            if (!this.excludePlayersMode) {
                where.append('(');
                for (String playerName : this.players) {
                    where.append("playername = '").append(playerName).append("' OR ");
                }
                where.delete(where.length() - 4, where.length());
                where.append(") AND ");
            } else {
                for (String playerName : this.players) {
                    where.append("playername != '").append(playerName).append("' AND ");
                }
            }
        }
        if (this.since > 0) {
            where.append("date > date_sub(now(), INTERVAL ").append(this.since).append(" MINUTE) AND ");
        }
        if (this.before > 0) {
            where.append("date < date_sub(now(), INTERVAL ").append(this.before).append(" MINUTE) AND ");
        }
        if (where.length() > 6) {
            where.delete(where.length() - 4, where.length());
        } else {
            where.delete(0, where.length());
        }
        return where.toString();
    }

    private void compileLocationQuery(StringBuilder where, int blockX, int blockX2, int blockY, int blockY2, int blockZ, int blockZ2) {
        this.compileLocationQueryPart(where, "x", blockX, blockX2);
        where.append(" AND ");
        this.compileLocationQueryPart(where, "y", blockY, blockY2);
        where.append(" AND ");
        this.compileLocationQueryPart(where, "z", blockZ, blockZ2);
        where.append(" AND ");
    }

    private void compileLocationQueryPart(StringBuilder where, String locValue, int loc, int loc2) {
        int max;
        int min = Math.min(loc, loc2);
        if (min == (max = Math.max(loc2, loc))) {
            where.append(locValue).append(" = ").append(min);
        } else if (max - min > 50) {
            where.append(locValue).append(" >= ").append(min).append(" AND ").append(locValue).append(" <= ").append(max);
        } else {
            where.append(locValue).append(" in (");
            int c = min;
            while (c < max) {
                where.append(c).append(",");
                ++c;
            }
            where.append(max);
            where.append(")");
        }
    }

    public void parseArgs(CommandSender sender, List<String> args) throws IllegalArgumentException {
        this.parseArgs(sender, args, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void parseArgs(CommandSender sender, List<String> args, boolean validate) throws IllegalArgumentException {
        Session session;
        if (args == null || args.isEmpty()) {
            throw new IllegalArgumentException("No parameters specified.");
        }
        args = Utils.parseQuotes(args);
        Player player = sender instanceof Player ? (Player)sender : null;
        Session session2 = session = this.prepareToolQuery ? null : Session.getSession(sender);
        if (player != null && this.world == null) {
            this.world = player.getWorld();
        }
        int i = 0;
        while (i < args.size()) {
            Material mat;
            Object matches;
            int n;
            String param = args.get(i).toLowerCase();
            String[] values = QueryParams.getValues(args, i + 1, QueryParams.getKeyWordMinArguments(param));
            if (param.equals("last")) {
                if (session == null || session.lastQuery == null) {
                    throw new IllegalArgumentException("This is your first command, you can't use last.");
                }
                this.merge(session.lastQuery);
            } else if (param.equals("player")) {
                if (values.length < 1) {
                    throw new IllegalArgumentException("No or wrong count of arguments for '" + param + "'");
                }
                String[] stringArray = values;
                n = values.length;
                int n2 = 0;
                while (n2 < n) {
                    String playerName = stringArray[n2];
                    if (playerName.length() > 0) {
                        if (playerName.contains("!")) {
                            this.excludePlayersMode = true;
                        }
                        if (playerName.contains("\"")) {
                            this.players.add(playerName.replaceAll("[^a-zA-Z0-9_]", ""));
                        } else {
                            matches = this.logblock.getServer().getPlayerExact(playerName);
                            this.players.add(matches != null ? matches.getName() : playerName.replaceAll("[^a-zA-Z0-9_]", ""));
                        }
                    }
                    ++n2;
                }
                this.needPlayer = true;
            } else if (param.equals("killer")) {
                if (values.length < 1) {
                    throw new IllegalArgumentException("No or wrong count of arguments for '" + param + "'");
                }
                String[] stringArray = values;
                n = values.length;
                int n3 = 0;
                while (n3 < n) {
                    String killerName = stringArray[n3];
                    if (killerName.length() > 0) {
                        if (killerName.contains("!")) {
                            this.excludeVictimsMode = true;
                        }
                        if (killerName.contains("\"")) {
                            this.killers.add(killerName.replaceAll("[^a-zA-Z0-9_]", ""));
                        } else {
                            matches = this.logblock.getServer().matchPlayer(killerName);
                            if (matches.size() > 1) {
                                throw new IllegalArgumentException("Ambiguous victimname '" + param + "'");
                            }
                            this.killers.add(matches.size() == 1 ? ((Player)matches.get(0)).getName() : killerName.replaceAll("[^a-zA-Z0-9_]", ""));
                        }
                    }
                    ++n3;
                }
                this.needKiller = true;
            } else if (param.equals("victim")) {
                if (values.length < 1) {
                    throw new IllegalArgumentException("No or wrong count of arguments for '" + param + "'");
                }
                String[] stringArray = values;
                n = values.length;
                int n4 = 0;
                while (n4 < n) {
                    String victimName = stringArray[n4];
                    if (victimName.length() > 0) {
                        if (victimName.contains("!")) {
                            this.excludeVictimsMode = true;
                        }
                        if (victimName.contains("\"")) {
                            this.victims.add(victimName.replaceAll("[^a-zA-Z0-9_]", ""));
                        } else {
                            matches = this.logblock.getServer().matchPlayer(victimName);
                            if (matches.size() > 1) {
                                throw new IllegalArgumentException("Ambiguous victimname '" + param + "'");
                            }
                            this.victims.add(matches.size() == 1 ? ((Player)matches.get(0)).getName() : victimName.replaceAll("[^a-zA-Z0-9_]", ""));
                        }
                    }
                    ++n4;
                }
                this.needVictim = true;
            } else if (param.equals("weapon")) {
                if (values.length < 1) {
                    throw new IllegalArgumentException("No or wrong count of arguments for '" + param + "'");
                }
                String[] stringArray = values;
                n = values.length;
                int n5 = 0;
                while (n5 < n) {
                    String weaponName = stringArray[n5];
                    Material material = mat = weaponName.equalsIgnoreCase("fist") ? Material.AIR : Material.matchMaterial((String)weaponName);
                    if (mat == null) {
                        throw new IllegalArgumentException("No material matching: '" + weaponName + "'");
                    }
                    this.types.add(mat);
                    this.typeIds.add(MaterialConverter.getOrAddMaterialId(mat.getKey()));
                    ++n5;
                }
                this.needWeapon = true;
            } else if (param.equals("block") || param.equals("type")) {
                if (values.length < 1) {
                    throw new IllegalArgumentException("No or wrong count of arguments for '" + param + "'");
                }
                String[] stringArray = values;
                n = values.length;
                int n6 = 0;
                while (n6 < n) {
                    String blockName = stringArray[n6];
                    if (blockName.startsWith("!")) {
                        this.excludeBlocksEntitiesMode = true;
                        blockName = blockName.substring(1);
                    }
                    if (blockName.startsWith("#")) {
                        String tagName = blockName.substring(1).toLowerCase();
                        Tag tag = this.logblock.getServer().getTag("blocks", NamespacedKey.minecraft((String)tagName), Material.class);
                        if ((tag == null || tag.getValues().isEmpty()) && ((tag = this.logblock.getServer().getTag("items", NamespacedKey.minecraft((String)tagName), Material.class)) == null || tag.getValues().isEmpty())) {
                            throw new IllegalArgumentException("No block tag matching: '" + blockName + "'");
                        }
                        for (Material mat2 : tag.getValues()) {
                            this.typeIds.add(MaterialConverter.getOrAddMaterialId(mat2.getKey()));
                        }
                        this.typeTags.add(tag);
                    } else if (blockName.contains("*")) {
                        StringBuilder sb = new StringBuilder();
                        int ci = 0;
                        while (ci < blockName.length()) {
                            char c = blockName.charAt(ci);
                            if (!Character.isAlphabetic(c)) {
                                if (c == '*') {
                                    sb.append('.');
                                } else {
                                    sb.append('\\');
                                }
                            }
                            sb.append(c);
                            ++ci;
                        }
                        String blockNamePattern = sb.toString();
                        Pattern pattern = Pattern.compile(blockNamePattern, 2);
                        ArrayList<Material> matched = new ArrayList<Material>();
                        Material[] materialArray = Material.values();
                        int n7 = materialArray.length;
                        int n8 = 0;
                        while (n8 < n7) {
                            Material mat3 = materialArray[n8];
                            if (pattern.matcher(mat3.name()).matches()) {
                                matched.add(mat3);
                            }
                            ++n8;
                        }
                        if (matched.isEmpty()) {
                            throw new IllegalArgumentException("No material matching: '" + blockName + "'");
                        }
                        for (Material mat3 : matched) {
                            this.types.add(mat3);
                            this.typeIds.add(MaterialConverter.getOrAddMaterialId(mat3.getKey()));
                        }
                    } else {
                        mat = Material.matchMaterial((String)blockName);
                        if (mat == null) {
                            throw new IllegalArgumentException("No material matching: '" + blockName + "'");
                        }
                        this.types.add(mat);
                        this.typeIds.add(MaterialConverter.getOrAddMaterialId(mat.getKey()));
                    }
                    ++n6;
                }
            } else if (param.equals("area")) {
                if (player == null && !this.prepareToolQuery && this.loc == null) {
                    throw new IllegalArgumentException("You have to be a player to use area, or specify a location first");
                }
                if (values.length == 0) {
                    this.radius = Config.defaultDist;
                    if (!this.prepareToolQuery && this.loc == null) {
                        this.loc = player.getLocation();
                    }
                } else {
                    if (!Utils.isInt(values[0])) {
                        throw new IllegalArgumentException("Not a number: '" + values[0] + "'");
                    }
                    this.radius = Integer.parseInt(values[0]);
                    if (!this.prepareToolQuery && this.loc == null) {
                        this.loc = player.getLocation();
                    }
                }
            } else if (param.equals("selection") || param.equals("sel")) {
                if (player == null) {
                    throw new IllegalArgumentException("You have to be a player to use selection");
                }
                this.setSelection(WorldEditHelper.getSelectedRegion(player));
            } else if (param.equals("time") || param.equals("since")) {
                int n9 = this.since = values.length > 0 ? Utils.parseTimeSpec(values) : Config.defaultTime;
                if (this.since == -1) {
                    throw new IllegalArgumentException("Failed to parse time spec for '" + param + "'");
                }
            } else if (param.equals("before")) {
                int n10 = this.before = values.length > 0 ? Utils.parseTimeSpec(values) : Config.defaultTime;
                if (this.before == -1) {
                    throw new IllegalArgumentException("Faile to parse time spec for '" + param + "'");
                }
            } else if (param.equals("sum")) {
                if (values.length != 1) {
                    throw new IllegalArgumentException("No or wrong count of arguments for '" + param + "'");
                }
                if (values[0].startsWith("p")) {
                    this.sum = SummarizationMode.PLAYERS;
                } else if (values[0].startsWith("b") || values[0].startsWith("e")) {
                    this.sum = SummarizationMode.TYPES;
                } else {
                    if (!values[0].startsWith("n")) throw new IllegalArgumentException("Wrong summarization mode");
                    this.sum = SummarizationMode.NONE;
                }
            } else if (param.equals("created")) {
                this.bct = BlockChangeType.CREATED;
            } else if (param.equals("destroyed")) {
                this.bct = BlockChangeType.DESTROYED;
            } else if (param.equals("both")) {
                this.bct = BlockChangeType.BOTH;
            } else if (param.equals("chestaccess")) {
                this.bct = BlockChangeType.CHESTACCESS;
            } else if (param.equals("chat")) {
                this.bct = BlockChangeType.CHAT;
            } else if (param.equals("kills")) {
                this.bct = BlockChangeType.KILLS;
            } else if (param.equals("entities") || param.equals("entity")) {
                this.bct = BlockChangeType.ENTITIES;
                if (values.length > 0) {
                    String[] stringArray = values;
                    n = values.length;
                    int n11 = 0;
                    while (n11 < n) {
                        EntityType entityType;
                        String entityTypeName = stringArray[n11];
                        if (entityTypeName.startsWith("!")) {
                            this.excludeBlocksEntitiesMode = true;
                            entityTypeName = entityTypeName.substring(1);
                        }
                        if ((entityType = BukkitUtils.matchEntityType(entityTypeName)) == null) {
                            throw new IllegalArgumentException("No entity type matching: '" + entityTypeName + "'");
                        }
                        this.entityTypes.add(entityType);
                        this.entityTypeIds.add(EntityTypeConverter.getOrAddEntityTypeId(entityType));
                        ++n11;
                    }
                }
            } else if (param.equals("all")) {
                this.bct = BlockChangeType.ALL;
            } else if (param.equals("limit")) {
                if (values.length != 1) {
                    throw new IllegalArgumentException("Wrong count of arguments for '" + param + "'");
                }
                if (!Utils.isInt(values[0])) {
                    throw new IllegalArgumentException("Not a number: '" + values[0] + "'");
                }
                this.limit = Integer.parseInt(values[0]);
            } else if (param.equals("world")) {
                if (values.length != 1) {
                    throw new IllegalArgumentException("Wrong count of arguments for '" + param + "'");
                }
                World w = sender.getServer().getWorld(values[0].replace("\"", ""));
                if (w == null) {
                    throw new IllegalArgumentException("There is no world called '" + values[0] + "'");
                }
                this.world = w;
            } else if (param.equals("asc")) {
                this.order = Order.ASC;
            } else if (param.equals("desc")) {
                this.order = Order.DESC;
            } else if (param.equals("coords")) {
                this.needCoords = true;
            } else if (param.equals("silent")) {
                this.silent = true;
            } else if (param.equals("force")) {
                this.forceReplace = true;
            } else if (param.equals("nocache")) {
                this.noCache = true;
            } else if (param.equals("search") || param.equals("match")) {
                if (values.length == 0) {
                    throw new IllegalArgumentException("No arguments for '" + param + "'");
                }
                this.match = Utils.mysqlTextEscape(Utils.join(values, " "));
            } else {
                String[] vectors;
                if (!param.equals("loc") && !param.equals("location")) throw new IllegalArgumentException("Not a valid argument: '" + param + "'");
                String[] stringArray = vectors = values.length == 1 ? values[0].split(":") : values;
                if (vectors.length != 3) {
                    throw new IllegalArgumentException("Wrong count arguments for '" + param + "'");
                }
                String[] stringArray2 = vectors;
                int n12 = vectors.length;
                n = 0;
                while (n < n12) {
                    String vec = stringArray2[n];
                    if (!Utils.isInt(vec)) {
                        throw new IllegalArgumentException("Not a number: '" + vec + "'");
                    }
                    ++n;
                }
                this.loc = new Location(null, (double)Integer.valueOf(vectors[0]).intValue(), (double)Integer.valueOf(vectors[1]).intValue(), (double)Integer.valueOf(vectors[2]).intValue());
                this.radius = 0;
            }
            i += values.length;
            ++i;
        }
        if (validate) {
            this.validate();
        }
        if (session == null || this.noCache) return;
        session.lastQuery = this.clone();
    }

    public void validate() {
        if (this.bct == BlockChangeType.KILLS) {
            if (this.world == null) {
                throw new IllegalArgumentException("No world specified");
            }
            if (!Config.getWorldConfig(this.world).isLogging(Logging.KILL)) {
                throw new IllegalArgumentException("Kill logging not enabled for world '" + this.world.getName() + "'");
            }
            if (this.sum != SummarizationMode.NONE && this.sum != SummarizationMode.PLAYERS) {
                throw new IllegalArgumentException("Invalid summarization for kills");
            }
        }
        if (!this.prepareToolQuery && this.bct != BlockChangeType.CHAT) {
            if (this.world == null) {
                throw new IllegalArgumentException("No world specified");
            }
            if (!Config.isLogged(this.world)) {
                throw new IllegalArgumentException("This world ('" + this.world.getName() + "') isn't logged");
            }
        }
        if (this.bct == BlockChangeType.CHAT) {
            if (!(Config.isLogging(Logging.CHAT) || Config.isLogging(Logging.PLAYER_COMMANDS) || Config.isLogging(Logging.CONSOLE_COMMANDS) || Config.isLogging(Logging.COMMANDBLOCK_COMMANDS))) {
                throw new IllegalArgumentException("Chat is not logged");
            }
            if (this.sum != SummarizationMode.NONE) {
                throw new IllegalArgumentException("Invalid summarization for chat");
            }
        }
    }

    public void setLocation(Location loc) {
        this.loc = loc;
        this.sel = null;
        this.world = loc.getWorld();
    }

    public void setSelection(CuboidRegion container) {
        this.sel = container;
        this.loc = null;
        this.world = this.sel.getWorld();
    }

    public void setPlayer(String playerName) {
        this.players.clear();
        this.players.add(playerName);
    }

    public QueryParams clone() {
        try {
            QueryParams params = (QueryParams)super.clone();
            params.players = new ArrayList<String>(this.players);
            params.killers = new ArrayList<String>(this.killers);
            params.victims = new ArrayList<String>(this.victims);
            params.typeIds = new ArrayList<Integer>(this.typeIds);
            params.types = new ArrayList<Material>(this.types);
            params.typeTags = new ArrayList(this.typeTags);
            params.entityTypeIds = new ArrayList<Integer>(this.entityTypeIds);
            params.entityTypes = new ArrayList<EntityType>(this.entityTypes);
            params.loc = this.loc == null ? null : this.loc.clone();
            params.sel = this.sel == null ? null : this.sel.clone();
            return params;
        }
        catch (CloneNotSupportedException ex) {
            throw new Error("QueryParams should be cloneable", ex);
        }
    }

    private static String[] getValues(List<String> args, int offset, int minParams) {
        int i = offset;
        while (i < args.size()) {
            if (i >= offset + minParams && QueryParams.isKeyWord(args.get(i))) break;
            ++i;
        }
        if (i == offset) {
            return new String[0];
        }
        String[] values = new String[i - offset];
        int j = offset;
        while (j < i) {
            String value = args.get(j);
            if (value.startsWith("\"") && value.endsWith("\"")) {
                value = value.substring(1, value.length() - 1);
            }
            values[j - offset] = value;
            ++j;
        }
        return values;
    }

    public void merge(QueryParams p) {
        this.players.addAll(p.players);
        this.killers.addAll(p.killers);
        this.victims.addAll(p.victims);
        this.excludePlayersMode = p.excludePlayersMode;
        this.typeIds.addAll(p.typeIds);
        this.types.addAll(p.types);
        this.typeTags.addAll(p.typeTags);
        this.entityTypeIds.addAll(p.entityTypeIds);
        this.entityTypes.addAll(p.entityTypes);
        this.loc = p.loc == null ? null : p.loc.clone();
        this.radius = p.radius;
        CuboidRegion cuboidRegion = this.sel = p.sel == null ? null : p.sel.clone();
        if (p.since != 0 || this.since != Config.defaultTime) {
            this.since = p.since;
        }
        this.before = p.before;
        this.sum = p.sum;
        this.bct = p.bct;
        this.limit = p.limit;
        this.world = p.world;
        this.order = p.order;
        this.match = p.match;
    }

    public static enum BlockChangeType {
        ALL,
        BOTH,
        CHESTACCESS,
        CREATED,
        DESTROYED,
        CHAT,
        KILLS,
        ENTITIES,
        ENTITIES_CREATED,
        ENTITIES_KILLED;

    }

    public static enum Order {
        ASC,
        DESC;

    }

    public static enum SummarizationMode {
        NONE,
        PLAYERS,
        TYPES;

    }
}

