/*
 * Decompiled with CFR 0.152.
 */
package de.diddiz.worldedit;

import com.sk89q.worldedit.IncompleteRegionException;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.bukkit.WorldEditPlugin;
import com.sk89q.worldedit.regions.CuboidRegion;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.world.World;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class RegionContainer {
    private Region selection;

    public RegionContainer(Region sel) {
        this.selection = sel;
    }

    public static RegionContainer fromPlayerSelection(Player player, Plugin plugin) {
        Region selection;
        LocalSession session = ((WorldEditPlugin)plugin).getSession(player);
        World weWorld = BukkitAdapter.adapt((org.bukkit.World)player.getWorld());
        if (!weWorld.equals((Object)session.getSelectionWorld())) {
            throw new IllegalArgumentException("No selection defined");
        }
        try {
            selection = session.getSelection(weWorld);
        }
        catch (IncompleteRegionException e) {
            throw new IllegalArgumentException("No selection defined");
        }
        if (selection == null) {
            throw new IllegalArgumentException("No selection defined");
        }
        if (!(selection instanceof CuboidRegion)) {
            throw new IllegalArgumentException("You have to define a cuboid selection");
        }
        return new RegionContainer(selection);
    }

    public static RegionContainer fromCorners(org.bukkit.World world, Location first, Location second) {
        World weWorld = BukkitAdapter.adapt((org.bukkit.World)world);
        Vector firstVector = BukkitAdapter.asVector((Location)first);
        Vector secondVector = BukkitAdapter.asVector((Location)second);
        return new RegionContainer((Region)new CuboidRegion(weWorld, firstVector, secondVector));
    }

    public Region getSelection() {
        return this.selection;
    }

    public void setSelection(Region selection) {
        this.selection = selection;
    }
}

