/*
 * Decompiled with CFR 0.152.
 */
package de.diddiz.LogBlock.listeners;

import de.diddiz.LogBlock.Actor;
import de.diddiz.LogBlock.LogBlock;
import de.diddiz.LogBlock.Logging;
import de.diddiz.LogBlock.config.Config;
import de.diddiz.LogBlock.listeners.LoggingListener;
import de.diddiz.util.LoggingUtil;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBurnEvent;
import org.bukkit.event.player.PlayerInteractEvent;

public class BlockBurnLogging
extends LoggingListener {
    public BlockBurnLogging(LogBlock lb) {
        super(lb);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onBlockBurn(BlockBurnEvent event) {
        if (Config.isLogging(event.getBlock().getWorld(), Logging.FIRE)) {
            LoggingUtil.smartLogBlockBreak(this.consumer, new Actor("Fire"), event.getBlock());
            LoggingUtil.smartLogFallables(this.consumer, new Actor("Fire"), event.getBlock());
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onExtinguish(PlayerInteractEvent event) {
        if (event.getAction().equals((Object)Action.LEFT_CLICK_BLOCK)) {
            Player player = event.getPlayer();
            Block block = event.getClickedBlock().getRelative(event.getBlockFace());
            if (block.getType().equals((Object)Material.FIRE) && Config.isLogging(player.getWorld(), Logging.FIRE)) {
                Actor actor = Actor.actorFromEntity((Entity)player);
                LoggingUtil.smartLogBlockBreak(this.consumer, actor, block);
                LoggingUtil.smartLogFallables(this.consumer, actor, block);
            }
        }
    }
}

