/*
 * Decompiled with CFR 0.152.
 */
package de.diddiz.LogBlock.events;

import de.diddiz.LogBlock.Actor;
import de.diddiz.LogBlock.ChestAccess;
import de.diddiz.LogBlock.events.PreLogEvent;
import de.diddiz.util.BukkitUtils;
import org.apache.commons.lang.Validate;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.data.BlockData;
import org.bukkit.event.HandlerList;

public class BlockChangePreLogEvent
extends PreLogEvent {
    private static final HandlerList handlers = new HandlerList();
    private Location location;
    private BlockData typeBefore;
    private BlockData typeAfter;
    private String signText;
    private ChestAccess chestAccess;

    public BlockChangePreLogEvent(Actor owner, Location location, BlockData typeBefore, BlockData typeAfter, String signText, ChestAccess chestAccess) {
        super(owner);
        this.location = location;
        this.typeBefore = typeBefore;
        this.typeAfter = typeAfter;
        this.signText = signText;
        this.chestAccess = chestAccess;
    }

    public Location getLocation() {
        return this.location;
    }

    public void setLocation(Location location) {
        this.location = location;
    }

    public BlockData getTypeBefore() {
        return this.typeBefore;
    }

    public void setTypeBefore(BlockData typeBefore) {
        if (typeBefore == null) {
            typeBefore = Bukkit.createBlockData((Material)Material.AIR);
        }
        this.typeBefore = typeBefore;
    }

    public BlockData getTypeAfter() {
        return this.typeAfter;
    }

    public void setTypeAfter(BlockData typeAfter) {
        if (typeAfter == null) {
            typeAfter = Bukkit.createBlockData((Material)Material.AIR);
        }
        this.typeAfter = typeAfter;
    }

    public String getSignText() {
        return this.signText;
    }

    public void setSignText(String[] signText) {
        if (signText != null) {
            Validate.isTrue((boolean)this.isValidSign(), (String)"Must be valid sign block");
            Validate.noNullElements((Object[])signText, (String)"No null lines");
            Validate.isTrue((signText.length == 4 ? 1 : 0) != 0, (String)"Sign text must be 4 strings");
            this.signText = String.valueOf(signText[0]) + "\u0000" + signText[1] + "\u0000" + signText[2] + "\u0000" + signText[3];
        } else {
            this.signText = null;
        }
    }

    private boolean isValidSign() {
        if ((this.typeAfter.getMaterial() == Material.SIGN || this.typeAfter.getMaterial() == Material.WALL_SIGN) && BukkitUtils.isEmpty(this.typeBefore.getMaterial())) {
            return true;
        }
        if ((this.typeBefore.getMaterial() == Material.SIGN || this.typeBefore.getMaterial() == Material.WALL_SIGN) && BukkitUtils.isEmpty(this.typeAfter.getMaterial())) {
            return true;
        }
        return (this.typeAfter.getMaterial() == Material.SIGN || this.typeAfter.getMaterial() == Material.WALL_SIGN) && this.typeBefore.equals(this.typeAfter);
    }

    public ChestAccess getChestAccess() {
        return this.chestAccess;
    }

    public void setChestAccess(ChestAccess chestAccess) {
        this.chestAccess = chestAccess;
    }

    public HandlerList getHandlers() {
        return handlers;
    }

    public static HandlerList getHandlerList() {
        return handlers;
    }
}

