/*
 * Decompiled with CFR 0.152.
 */
package de.diddiz.LogBlock;

import de.diddiz.LogBlock.Actor;
import de.diddiz.LogBlock.BlockChange;
import de.diddiz.LogBlock.ChestAccess;
import de.diddiz.LogBlock.LogBlock;
import de.diddiz.LogBlock.LookupCacheElement;
import de.diddiz.LogBlock.MaterialConverter;
import de.diddiz.LogBlock.blockstate.BlockStateCodecs;
import de.diddiz.LogBlock.config.Config;
import de.diddiz.util.BukkitUtils;
import java.io.File;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.data.Bisected;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.Bed;
import org.bukkit.block.data.type.Door;
import org.bukkit.block.data.type.Piston;
import org.bukkit.block.data.type.PistonHead;
import org.bukkit.block.data.type.TechnicalPiston;
import org.bukkit.command.CommandSender;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class WorldEditor
implements Runnable {
    private final LogBlock logblock;
    private final Queue<Edit> edits = new LinkedBlockingQueue<Edit>();
    private final World world;
    private CommandSender sender;
    private int taskID;
    private int successes = 0;
    private int blacklistCollisions = 0;
    private long elapsedTime = 0L;
    public LookupCacheElement[] errors;

    public WorldEditor(LogBlock logblock, World world) {
        this.logblock = logblock;
        this.world = world;
    }

    public int getSize() {
        return this.edits.size();
    }

    public int getSuccesses() {
        return this.successes;
    }

    public int getErrors() {
        return this.errors.length;
    }

    public int getBlacklistCollisions() {
        return this.blacklistCollisions;
    }

    public void setSender(CommandSender sender) {
        this.sender = sender;
    }

    public void queueEdit(int x, int y, int z, int replaced, int replaceData, byte[] replacedState, int type, int typeData, byte[] typeState, ChestAccess item) {
        this.edits.add(new Edit(0L, new Location(this.world, (double)x, (double)y, (double)z), null, replaced, replaceData, replacedState, type, typeData, typeState, item));
    }

    public long getElapsedTime() {
        return this.elapsedTime;
    }

    public synchronized void start() throws Exception {
        long start = System.currentTimeMillis();
        this.taskID = this.logblock.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)this.logblock, (Runnable)this, 0L, 1L);
        if (this.taskID == -1) {
            throw new Exception("Failed to schedule task");
        }
        try {
            this.wait();
        }
        catch (InterruptedException ex) {
            throw new Exception("Interrupted");
        }
        this.elapsedTime = System.currentTimeMillis() - start;
    }

    @Override
    public synchronized void run() {
        ArrayList<WorldEditorException> errorList = new ArrayList<WorldEditorException>();
        int counter = 0;
        float size = this.edits.size();
        while (!this.edits.isEmpty() && counter < 100) {
            float percentage;
            try {
                switch (this.edits.poll().perform()) {
                    case SUCCESS: {
                        ++this.successes;
                        break;
                    }
                    case BLACKLISTED: {
                        ++this.blacklistCollisions;
                        break;
                    }
                }
            }
            catch (WorldEditorException ex) {
                errorList.add(ex);
            }
            catch (Exception ex) {
                Bukkit.getLogger().log(Level.WARNING, "[WorldEditor] Exeption: ", ex);
            }
            ++counter;
            if (this.sender == null || (percentage = (size - (float)this.edits.size()) / size * 100.0f) % 20.0f != 0.0f) continue;
            this.sender.sendMessage(ChatColor.GOLD + "[LogBlock]" + ChatColor.YELLOW + " Rollback progress: " + percentage + "%" + " Blocks edited: " + counter);
        }
        if (this.edits.isEmpty()) {
            this.logblock.getServer().getScheduler().cancelTask(this.taskID);
            if (errorList.size() > 0) {
                try {
                    File file = new File("plugins/LogBlock/error/WorldEditor-" + new SimpleDateFormat("yy-MM-dd-HH-mm-ss").format(System.currentTimeMillis()) + ".log");
                    file.getParentFile().mkdirs();
                    PrintWriter writer = new PrintWriter(file);
                    for (LookupCacheElement lookupCacheElement : errorList) {
                        writer.println(lookupCacheElement.getMessage());
                    }
                    writer.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.errors = errorList.toArray(new WorldEditorException[errorList.size()]);
            this.notify();
        }
    }

    private class Edit
    extends BlockChange {
        public Edit(long time, Location loc, Actor actor, int replaced, int replaceData, byte[] replacedState, int type, int typeData, byte[] typeState, ChestAccess ca) {
            super(time, loc, actor, replaced, replaceData, replacedState, type, typeData, typeState, ca);
        }

        PerformResult perform() throws WorldEditorException {
            PistonHead head;
            Block secBlock;
            BlockData replacedBlock = MaterialConverter.getBlockData(this.replacedMaterial, this.replacedData);
            BlockData setBlock = MaterialConverter.getBlockData(this.typeMaterial, this.typeData);
            if (replacedBlock == null || setBlock == null) {
                throw new WorldEditorException("Could not parse the material", this.loc.clone());
            }
            if (Config.dontRollback.contains(replacedBlock.getMaterial())) {
                return PerformResult.BLACKLISTED;
            }
            Block block = this.loc.getBlock();
            if (BukkitUtils.isEmpty(replacedBlock.getMaterial()) && BukkitUtils.isEmpty(block.getType())) {
                return PerformResult.NO_ACTION;
            }
            BlockState state = block.getState();
            if (!WorldEditor.this.world.isChunkLoaded(block.getChunk())) {
                WorldEditor.this.world.loadChunk(block.getChunk());
            }
            if (setBlock.equals(replacedBlock)) {
                if (BukkitUtils.isEmpty(setBlock.getMaterial())) {
                    block.setType(Material.AIR);
                } else if (this.ca != null) {
                    if (state instanceof InventoryHolder) {
                        int leftover;
                        try {
                            leftover = BukkitUtils.modifyContainer(state, new ItemStack(this.ca.itemStack), !this.ca.remove);
                            if (leftover > 0 && (setBlock.getMaterial() == Material.CHEST || setBlock.getMaterial() == Material.TRAPPED_CHEST)) {
                                BlockFace[] blockFaceArray = new BlockFace[]{BlockFace.NORTH, BlockFace.SOUTH, BlockFace.EAST, BlockFace.WEST};
                                int n = blockFaceArray.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    BlockFace face = blockFaceArray[n2];
                                    if (block.getRelative(face).getType() == setBlock.getMaterial()) {
                                        ItemStack remaining = new ItemStack(this.ca.itemStack);
                                        remaining.setAmount(leftover);
                                        leftover = BukkitUtils.modifyContainer(block.getRelative(face).getState(), remaining, !this.ca.remove);
                                    }
                                    ++n2;
                                }
                            }
                        }
                        catch (Exception ex) {
                            throw new WorldEditorException(ex.getMessage(), block.getLocation());
                        }
                        if (leftover > 0 && this.ca.remove) {
                            throw new WorldEditorException("Not enough space left in " + block.getType(), block.getLocation());
                        }
                    }
                } else if (!block.getBlockData().equals(replacedBlock)) {
                    block.setBlockData(replacedBlock);
                } else {
                    return PerformResult.NO_ACTION;
                }
                return PerformResult.SUCCESS;
            }
            if (block.getType() != setBlock.getMaterial() && !Config.replaceAnyway.contains(block.getType())) {
                return PerformResult.NO_ACTION;
            }
            if (state instanceof InventoryHolder) {
                ((InventoryHolder)state).getInventory().clear();
                state.update();
            }
            block.setBlockData(replacedBlock);
            BlockData newData = block.getBlockData();
            if (BlockStateCodecs.hasCodec(replacedBlock.getMaterial())) {
                state = block.getState();
                try {
                    BlockStateCodecs.deserialize(state, this.replacedState);
                    state.update();
                }
                catch (Exception e) {
                    throw new WorldEditorException("Failed to restore blockstate of " + block.getType() + ": " + e, block.getLocation());
                }
            }
            Material curtype = block.getType();
            if (newData instanceof Bed) {
                Block secBlock2;
                Bed bed = (Bed)newData;
                Block block2 = secBlock2 = bed.getPart() == Bed.Part.HEAD ? block.getRelative(bed.getFacing().getOppositeFace()) : block.getRelative(bed.getFacing());
                if (secBlock2.isEmpty()) {
                    Bed bed2 = (Bed)bed.clone();
                    bed2.setPart(bed.getPart() == Bed.Part.HEAD ? Bed.Part.FOOT : Bed.Part.HEAD);
                    secBlock2.setBlockData((BlockData)bed2);
                }
            } else if (newData instanceof Door) {
                Block secBlock3;
                Door door = (Door)newData;
                Block block3 = secBlock3 = door.getHalf() == Bisected.Half.TOP ? block.getRelative(BlockFace.DOWN) : block.getRelative(BlockFace.UP);
                if (secBlock3.isEmpty()) {
                    Door door2 = (Door)door.clone();
                    door2.setHalf(door.getHalf() == Bisected.Half.TOP ? Bisected.Half.BOTTOM : Bisected.Half.TOP);
                    secBlock3.setBlockData((BlockData)door2);
                }
            } else if (curtype == Material.PISTON || curtype == Material.STICKY_PISTON) {
                Block secBlock4;
                Piston piston = (Piston)newData;
                if (piston.isExtended() && (secBlock4 = block.getRelative(piston.getFacing())).isEmpty()) {
                    PistonHead head2 = (PistonHead)Material.PISTON_HEAD.createBlockData();
                    head2.setFacing(piston.getFacing());
                    head2.setType(curtype == Material.PISTON ? TechnicalPiston.Type.NORMAL : TechnicalPiston.Type.STICKY);
                    secBlock4.setBlockData((BlockData)head2);
                }
            } else if (curtype == Material.PISTON_HEAD && (secBlock = block.getRelative((head = (PistonHead)newData).getFacing().getOppositeFace())).isEmpty()) {
                Piston piston = (Piston)(head.getType() == TechnicalPiston.Type.NORMAL ? Material.PISTON : Material.STICKY_PISTON).createBlockData();
                piston.setFacing(head.getFacing());
                piston.setExtended(true);
                secBlock.setBlockData((BlockData)piston);
            }
            return PerformResult.SUCCESS;
        }
    }

    private static enum PerformResult {
        SUCCESS,
        BLACKLISTED,
        NO_ACTION;

    }

    public static class WorldEditorException
    extends Exception
    implements LookupCacheElement {
        private final Location loc;

        public WorldEditorException(Material typeBefore, Material typeAfter, Location loc) {
            this("Failed to replace " + typeBefore.name() + " with " + typeAfter.name(), loc);
        }

        public WorldEditorException(String msg, Location loc) {
            super(String.valueOf(msg) + " at " + loc.getWorld().getName() + ":" + loc.getBlockX() + ":" + loc.getBlockY() + ":" + loc.getBlockZ());
            this.loc = loc;
        }

        @Override
        public Location getLocation() {
            return this.loc;
        }
    }
}

