/*
 * Decompiled with CFR 0.152.
 */
package de.diddiz.LogBlock;

import de.diddiz.LogBlock.LogBlock;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.HashMap;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.block.data.BlockData;

public class MaterialConverter {
    private static String[] idToMaterial = new String[10];
    private static HashMap<String, Integer> materialToID = new HashMap();
    private static int nextMaterialId;
    private static String[] idToBlockState;
    private static HashMap<String, Integer> blockStateToID;
    private static int nextBlockStateId;
    private static HashMap<String, Material> materialKeyToMaterial;

    static {
        idToBlockState = new String[10];
        blockStateToID = new HashMap();
        materialKeyToMaterial = new HashMap();
        Material[] materialArray = Material.values();
        int n = materialArray.length;
        int n2 = 0;
        while (n2 < n) {
            Material m = materialArray[n2];
            materialKeyToMaterial.put(m.getKey().toString(), m);
            ++n2;
        }
    }

    public static int getOrAddMaterialId(NamespacedKey nameSpaceKey) {
        return MaterialConverter.getOrAddMaterialId(nameSpaceKey.toString());
    }

    public static int getOrAddMaterialId(String blockDataString) {
        Integer key;
        String materialString = blockDataString;
        int dataPart = blockDataString.indexOf("[");
        if (dataPart >= 0) {
            materialString = blockDataString.substring(0, dataPart);
        }
        if ((key = materialToID.get(materialString)) == null) {
            key = nextMaterialId++;
            materialToID.put(materialString, key);
            int length = idToMaterial.length;
            while (length <= key) {
                length = length * 3 / 2 + 5;
            }
            if (length > idToMaterial.length) {
                idToMaterial = Arrays.copyOf(idToMaterial, length);
            }
            MaterialConverter.idToMaterial[key.intValue()] = materialString;
            LogBlock.getInstance().getConsumer().queueAddMaterialMapping(key, materialString);
        }
        return key;
    }

    public static int getOrAddBlockStateId(String blockDataString) {
        int dataPart = blockDataString.indexOf("[");
        if (dataPart < 0) {
            return -1;
        }
        String materialString = blockDataString.substring(dataPart);
        Integer key = blockStateToID.get(materialString);
        if (key == null) {
            key = nextBlockStateId++;
            blockStateToID.put(materialString, key);
            int length = idToBlockState.length;
            while (length <= key) {
                length = length * 3 / 2 + 5;
            }
            if (length > idToBlockState.length) {
                idToBlockState = Arrays.copyOf(idToBlockState, length);
            }
            MaterialConverter.idToBlockState[key.intValue()] = materialString;
            LogBlock.getInstance().getConsumer().queueAddBlockStateMapping(key, materialString);
        }
        return key;
    }

    public static BlockData getBlockData(int materialId, int blockStateId) {
        String material = idToMaterial[materialId];
        if (blockStateId >= 0) {
            material = String.valueOf(material) + idToBlockState[blockStateId];
        }
        return Bukkit.createBlockData((String)material);
    }

    public static Material getMaterial(int materialId) {
        return materialKeyToMaterial.get(idToMaterial[materialId]);
    }

    public static void initializeMaterials(Connection connection) throws SQLException {
        int length;
        String materialString;
        int key;
        Statement smt = connection.createStatement();
        ResultSet rs = smt.executeQuery("SELECT id, name FROM `lb-materials`");
        while (rs.next()) {
            key = rs.getInt(1);
            materialString = rs.getString(2);
            materialToID.put(materialString, key);
            length = idToMaterial.length;
            while (length <= key) {
                length = length * 3 / 2 + 5;
            }
            if (length > idToMaterial.length) {
                idToMaterial = Arrays.copyOf(idToMaterial, length);
            }
            MaterialConverter.idToMaterial[key] = materialString;
            if (nextMaterialId > key) continue;
            nextMaterialId = key + 1;
        }
        rs.close();
        rs = smt.executeQuery("SELECT id, name FROM `lb-blockstates`");
        while (rs.next()) {
            key = rs.getInt(1);
            materialString = rs.getString(2);
            blockStateToID.put(materialString, key);
            length = idToBlockState.length;
            while (length <= key) {
                length = length * 3 / 2 + 5;
            }
            if (length > idToBlockState.length) {
                idToBlockState = Arrays.copyOf(idToBlockState, length);
            }
            MaterialConverter.idToBlockState[key] = materialString;
            if (nextBlockStateId > key) continue;
            nextBlockStateId = key + 1;
        }
        rs.close();
        smt.close();
        connection.close();
    }
}

