/*
 * Decompiled with CFR 0.152.
 */
package de.diddiz.LogBlock;

import de.diddiz.LogBlock.AutoClearLog;
import de.diddiz.LogBlock.BlockChange;
import de.diddiz.LogBlock.CommandsHandler;
import de.diddiz.LogBlock.Consumer;
import de.diddiz.LogBlock.DumpedLogImporter;
import de.diddiz.LogBlock.Logging;
import de.diddiz.LogBlock.MaterialConverter;
import de.diddiz.LogBlock.Metrics;
import de.diddiz.LogBlock.QueryParams;
import de.diddiz.LogBlock.Tool;
import de.diddiz.LogBlock.Updater;
import de.diddiz.LogBlock.config.Config;
import de.diddiz.LogBlock.listeners.BanListener;
import de.diddiz.LogBlock.listeners.BlockBreakLogging;
import de.diddiz.LogBlock.listeners.BlockBurnLogging;
import de.diddiz.LogBlock.listeners.BlockPlaceLogging;
import de.diddiz.LogBlock.listeners.BlockSpreadLogging;
import de.diddiz.LogBlock.listeners.ChatLogging;
import de.diddiz.LogBlock.listeners.ChestAccessLogging;
import de.diddiz.LogBlock.listeners.CreatureInteractLogging;
import de.diddiz.LogBlock.listeners.EndermenLogging;
import de.diddiz.LogBlock.listeners.ExplosionLogging;
import de.diddiz.LogBlock.listeners.FluidFlowLogging;
import de.diddiz.LogBlock.listeners.InteractLogging;
import de.diddiz.LogBlock.listeners.KillLogging;
import de.diddiz.LogBlock.listeners.LeavesDecayLogging;
import de.diddiz.LogBlock.listeners.PlayerInfoLogging;
import de.diddiz.LogBlock.listeners.SignChangeLogging;
import de.diddiz.LogBlock.listeners.SnowFadeLogging;
import de.diddiz.LogBlock.listeners.SnowFormLogging;
import de.diddiz.LogBlock.listeners.StructureGrowLogging;
import de.diddiz.LogBlock.listeners.ToolListener;
import de.diddiz.LogBlock.listeners.WitherLogging;
import de.diddiz.util.BukkitUtils;
import de.diddiz.util.MySQLConnectionPool;
import de.diddiz.worldedit.WorldEditLoggingHook;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.permissions.Permission;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;

public class LogBlock
extends JavaPlugin {
    private static LogBlock logblock = null;
    private MySQLConnectionPool pool;
    private Consumer consumer = null;
    private CommandsHandler commandsHandler;
    private Updater updater = null;
    private Timer timer = null;
    private boolean errorAtLoading = false;
    private boolean noDb = false;
    private boolean connected = true;

    public static LogBlock getInstance() {
        return logblock;
    }

    public Consumer getConsumer() {
        return this.consumer;
    }

    public CommandsHandler getCommandsHandler() {
        return this.commandsHandler;
    }

    Updater getUpdater() {
        return this.updater;
    }

    public void onLoad() {
        logblock = this;
        this.consumer = new Consumer(this);
        try {
            this.updater = new Updater(this);
            Config.load(this);
            this.getLogger().info("Connecting to " + Config.user + "@" + Config.url + "...");
            this.pool = new MySQLConnectionPool(Config.url, Config.user, Config.password);
            Connection conn = this.getConnection();
            if (conn == null) {
                this.noDb = true;
                return;
            }
            Statement st = conn.createStatement();
            ResultSet rs = st.executeQuery("SHOW CHARACTER SET where charset='utf8mb4';");
            if (rs.next()) {
                Config.mb4 = true;
                st.executeQuery("SET NAMES utf8mb4;");
            }
            conn.close();
            this.updater.checkTables();
            MaterialConverter.initializeMaterials(this.getConnection());
            MaterialConverter.getOrAddMaterialId(Material.AIR.getKey());
            if (this.updater.update()) {
                Config.load(this);
            }
        }
        catch (NullPointerException ex) {
            this.getLogger().log(Level.SEVERE, "Error while loading: ", ex);
        }
        catch (Exception ex) {
            this.getLogger().log(Level.SEVERE, "Error while loading: " + ex.getMessage(), ex);
            this.errorAtLoading = true;
            return;
        }
    }

    public void onEnable() {
        BukkitUtils.isDoublePlant(Material.AIR);
        PluginManager pm = Bukkit.getPluginManager();
        if (this.errorAtLoading) {
            pm.disablePlugin((Plugin)this);
            return;
        }
        if (this.noDb) {
            return;
        }
        if (pm.getPlugin("WorldEdit") != null) {
            if (Integer.parseInt(pm.getPlugin("WorldEdit").getDescription().getVersion().substring(0, 1)) > 5) {
                new WorldEditLoggingHook(this).hook();
            } else {
                this.getLogger().warning("Failed to hook into WorldEdit. Your WorldEdit version seems to be outdated, please make sure WorldEdit is at least version 6.");
            }
        }
        this.commandsHandler = new CommandsHandler(this);
        this.getCommand("lb").setExecutor((CommandExecutor)this.commandsHandler);
        if (Config.enableAutoClearLog && Config.autoClearLogDelay > 0) {
            this.getServer().getScheduler().runTaskTimerAsynchronously((Plugin)this, (Runnable)new AutoClearLog(this), 6000L, (long)(Config.autoClearLogDelay * 60 * 20));
        }
        this.getServer().getScheduler().runTaskAsynchronously((Plugin)this, (Runnable)new DumpedLogImporter(this));
        this.registerEvents();
        if (Config.useBukkitScheduler) {
            if (this.getServer().getScheduler().runTaskTimerAsynchronously((Plugin)this, (Runnable)this.consumer, (long)(Config.delayBetweenRuns < 20 ? 20 : Config.delayBetweenRuns), (long)Config.delayBetweenRuns).getTaskId() > 0) {
                this.getLogger().info("Scheduled consumer with bukkit scheduler.");
            } else {
                this.getLogger().warning("Failed to schedule consumer with bukkit scheduler. Now trying schedule with timer.");
                this.timer = new Timer();
                this.timer.schedule((TimerTask)this.consumer, Config.delayBetweenRuns < 20 ? 1000 : Config.delayBetweenRuns * 50, (long)(Config.delayBetweenRuns * 50));
            }
        } else {
            this.timer = new Timer();
            this.timer.schedule((TimerTask)this.consumer, Config.delayBetweenRuns < 20 ? 1000 : Config.delayBetweenRuns * 50, (long)(Config.delayBetweenRuns * 50));
            this.getLogger().info("Scheduled consumer with timer.");
        }
        this.getServer().getScheduler().runTaskAsynchronously((Plugin)this, (Runnable)new Updater.PlayerCountChecker(this));
        for (Tool tool : Config.toolsByType.values()) {
            if (pm.getPermission("logblock.tools." + tool.name) != null) continue;
            Permission perm = new Permission("logblock.tools." + tool.name, tool.permissionDefault);
            pm.addPermission(perm);
        }
        try {
            Metrics metrics = new Metrics((Plugin)this);
            metrics.start();
        }
        catch (IOException ex) {
            this.getLogger().info("Could not start metrics: " + ex.getMessage());
        }
    }

    private void registerEvents() {
        PluginManager pm = Bukkit.getPluginManager();
        pm.registerEvents((Listener)new ToolListener(this), (Plugin)this);
        pm.registerEvents((Listener)new PlayerInfoLogging(this), (Plugin)this);
        if (Config.askRollbackAfterBan) {
            pm.registerEvents((Listener)new BanListener(this), (Plugin)this);
        }
        if (Config.isLogging(Logging.BLOCKPLACE)) {
            pm.registerEvents((Listener)new BlockPlaceLogging(this), (Plugin)this);
        }
        if (Config.isLogging(Logging.BLOCKPLACE) || Config.isLogging(Logging.LAVAFLOW) || Config.isLogging(Logging.WATERFLOW)) {
            pm.registerEvents((Listener)new FluidFlowLogging(this), (Plugin)this);
        }
        if (Config.isLogging(Logging.BLOCKBREAK)) {
            pm.registerEvents((Listener)new BlockBreakLogging(this), (Plugin)this);
        }
        if (Config.isLogging(Logging.SIGNTEXT)) {
            pm.registerEvents((Listener)new SignChangeLogging(this), (Plugin)this);
        }
        if (Config.isLogging(Logging.FIRE)) {
            pm.registerEvents((Listener)new BlockBurnLogging(this), (Plugin)this);
        }
        if (Config.isLogging(Logging.SNOWFORM)) {
            pm.registerEvents((Listener)new SnowFormLogging(this), (Plugin)this);
        }
        if (Config.isLogging(Logging.SNOWFADE)) {
            pm.registerEvents((Listener)new SnowFadeLogging(this), (Plugin)this);
        }
        if (Config.isLogging(Logging.CREEPEREXPLOSION) || Config.isLogging(Logging.TNTEXPLOSION) || Config.isLogging(Logging.GHASTFIREBALLEXPLOSION) || Config.isLogging(Logging.ENDERDRAGON) || Config.isLogging(Logging.MISCEXPLOSION)) {
            pm.registerEvents((Listener)new ExplosionLogging(this), (Plugin)this);
        }
        if (Config.isLogging(Logging.LEAVESDECAY)) {
            pm.registerEvents((Listener)new LeavesDecayLogging(this), (Plugin)this);
        }
        if (Config.isLogging(Logging.CHESTACCESS)) {
            pm.registerEvents((Listener)new ChestAccessLogging(this), (Plugin)this);
        }
        if (Config.isLogging(Logging.SWITCHINTERACT) || Config.isLogging(Logging.DOORINTERACT) || Config.isLogging(Logging.CAKEEAT) || Config.isLogging(Logging.DIODEINTERACT) || Config.isLogging(Logging.COMPARATORINTERACT) || Config.isLogging(Logging.NOTEBLOCKINTERACT) || Config.isLogging(Logging.PRESUREPLATEINTERACT) || Config.isLogging(Logging.TRIPWIREINTERACT) || Config.isLogging(Logging.CROPTRAMPLE)) {
            pm.registerEvents((Listener)new InteractLogging(this), (Plugin)this);
        }
        if (Config.isLogging(Logging.CREATURECROPTRAMPLE)) {
            pm.registerEvents((Listener)new CreatureInteractLogging(this), (Plugin)this);
        }
        if (Config.isLogging(Logging.KILL)) {
            pm.registerEvents((Listener)new KillLogging(this), (Plugin)this);
        }
        if (Config.isLogging(Logging.CHAT)) {
            pm.registerEvents((Listener)new ChatLogging(this), (Plugin)this);
        }
        if (Config.isLogging(Logging.ENDERMEN)) {
            pm.registerEvents((Listener)new EndermenLogging(this), (Plugin)this);
        }
        if (Config.isLogging(Logging.WITHER)) {
            pm.registerEvents((Listener)new WitherLogging(this), (Plugin)this);
        }
        if (Config.isLogging(Logging.NATURALSTRUCTUREGROW) || Config.isLogging(Logging.BONEMEALSTRUCTUREGROW)) {
            pm.registerEvents((Listener)new StructureGrowLogging(this), (Plugin)this);
        }
        if (Config.isLogging(Logging.GRASSGROWTH) || Config.isLogging(Logging.MYCELIUMSPREAD) || Config.isLogging(Logging.VINEGROWTH) || Config.isLogging(Logging.MUSHROOMSPREAD)) {
            pm.registerEvents((Listener)new BlockSpreadLogging(this), (Plugin)this);
        }
    }

    public void onDisable() {
        if (this.timer != null) {
            this.timer.cancel();
        }
        this.getServer().getScheduler().cancelTasks((Plugin)this);
        if (this.consumer != null) {
            if (Config.logPlayerInfo && this.getServer().getOnlinePlayers() != null) {
                for (Player player : this.getServer().getOnlinePlayers()) {
                    this.consumer.queueLeave(player);
                }
            }
            this.getLogger().info("Waiting for consumer ...");
            this.consumer.run();
            if (this.consumer.getQueueSize() > 0) {
                int tries = 9;
                while (this.consumer.getQueueSize() > 0) {
                    this.getLogger().info("Remaining queue size: " + this.consumer.getQueueSize());
                    if (tries > 0) {
                        this.getLogger().info("Remaining tries: " + tries);
                    } else {
                        this.getLogger().info("Unable to save queue to database. Trying to write to a local file.");
                        try {
                            this.consumer.writeToFile();
                            this.getLogger().info("Successfully dumped queue.");
                        }
                        catch (FileNotFoundException ex) {
                            this.getLogger().info("Failed to write. Given up.");
                            break;
                        }
                    }
                    this.consumer.run();
                    --tries;
                }
            }
        }
        if (this.pool != null) {
            this.pool.close();
        }
    }

    public boolean onCommand(CommandSender sender, Command cmd, String commandLabel, String[] args) {
        if (this.noDb) {
            sender.sendMessage(ChatColor.RED + "No database connected. Check your MySQL user/pw and database for typos. Start/restart your MySQL server.");
        }
        return true;
    }

    public boolean hasPermission(CommandSender sender, String permission) {
        return sender.hasPermission(permission);
    }

    public Connection getConnection() {
        try {
            Connection conn = this.pool.getConnection();
            if (!this.connected) {
                this.getLogger().info("MySQL connection rebuild");
                this.connected = true;
            }
            return conn;
        }
        catch (Exception ex) {
            if (this.connected) {
                this.getLogger().log(Level.SEVERE, "Error while fetching connection: ", ex);
                this.connected = false;
            } else {
                this.getLogger().log(Level.SEVERE, "MySQL connection lost", ex);
            }
            return null;
        }
    }

    public List<BlockChange> getBlockChanges(QueryParams params) throws SQLException {
        Connection conn = this.getConnection();
        Statement state = null;
        if (conn == null) {
            throw new SQLException("No connection");
        }
        try {
            state = conn.createStatement();
            ResultSet rs = state.executeQuery(params.getQuery());
            ArrayList<BlockChange> blockchanges = new ArrayList<BlockChange>();
            while (rs.next()) {
                blockchanges.add(new BlockChange(rs, params));
            }
            ArrayList<BlockChange> arrayList = blockchanges;
            return arrayList;
        }
        finally {
            if (state != null) {
                state.close();
            }
            conn.close();
        }
    }

    public int getCount(QueryParams params) throws SQLException {
        Connection conn = this.getConnection();
        Statement state = null;
        if (conn == null) {
            throw new SQLException("No connection");
        }
        try {
            state = conn.createStatement();
            QueryParams p = params.clone();
            p.needCount = true;
            ResultSet rs = state.executeQuery(p.getQuery());
            if (!rs.next()) {
                return 0;
            }
            int n = rs.getInt(1);
            return n;
        }
        finally {
            if (state != null) {
                state.close();
            }
            conn.close();
        }
    }

    public File getFile() {
        return super.getFile();
    }
}

