/*
 * Decompiled with CFR 0.152.
 */
package de.diddiz.LogBlock;

import de.diddiz.LogBlock.LogBlock;
import de.diddiz.util.Utils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Level;
import org.bukkit.Bukkit;

public class DumpedLogImporter
implements Runnable {
    private final LogBlock logblock;

    DumpedLogImporter(LogBlock logblock) {
        this.logblock = logblock;
    }

    @Override
    public void run() {
        File[] imports = new File("plugins/LogBlock/import/").listFiles(new Utils.ExtensionFilenameFilter("sql"));
        if (imports != null && imports.length > 0) {
            Bukkit.getLogger().info("Found " + imports.length + " imports.");
            Connection conn = null;
            try {
                conn = this.logblock.getConnection();
                if (conn == null) {
                    return;
                }
                try {
                    conn.setAutoCommit(false);
                    Statement st = conn.createStatement();
                    BufferedWriter writer = new BufferedWriter(new FileWriter(new File(this.logblock.getDataFolder(), "import/failed.txt")));
                    int successes = 0;
                    int errors = 0;
                    File[] fileArray = imports;
                    int n = imports.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String line;
                        File sqlFile = fileArray[n2];
                        Bukkit.getLogger().info("Trying to import " + sqlFile.getName() + " ...");
                        BufferedReader reader = new BufferedReader(new FileReader(sqlFile));
                        while ((line = reader.readLine()) != null) {
                            try {
                                st.execute(line);
                                ++successes;
                            }
                            catch (Exception ex) {
                                Bukkit.getLogger().warning("Error while importing: '" + line + "': " + ex.getMessage());
                                writer.write(String.valueOf(line) + Utils.newline);
                                ++errors;
                            }
                        }
                        conn.commit();
                        reader.close();
                        sqlFile.delete();
                        Bukkit.getLogger().info("Successfully imported " + sqlFile.getName() + ".");
                        ++n2;
                    }
                    writer.close();
                    st.close();
                    Bukkit.getLogger().info("Successfully imported stored queue. (" + successes + " rows imported, " + errors + " errors)");
                }
                catch (Exception ex) {
                    Bukkit.getLogger().log(Level.WARNING, "Error while importing: ", ex);
                }
            }
            finally {
                if (conn != null) {
                    try {
                        conn.close();
                    }
                    catch (SQLException sQLException) {}
                }
            }
        }
    }
}

