/*
 * Decompiled with CFR 0.152.
 */
package de.diddiz.LogBlock.listeners;

import de.diddiz.LogBlock.Actor;
import de.diddiz.LogBlock.LogBlock;
import de.diddiz.LogBlock.Logging;
import de.diddiz.LogBlock.config.Config;
import de.diddiz.LogBlock.config.WorldConfig;
import de.diddiz.LogBlock.listeners.LoggingListener;
import de.diddiz.util.BukkitUtils;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;

public class InteractLogging
extends LoggingListener {
    public InteractLogging(LogBlock lb) {
        super(lb);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerInteract(PlayerInteractEvent event) {
        WorldConfig wcfg = Config.getWorldConfig(event.getPlayer().getWorld());
        if (wcfg != null) {
            Block clicked = event.getClickedBlock();
            if (clicked == null) {
                return;
            }
            Material type = clicked.getType();
            int typeId = type.getId();
            byte blockData = clicked.getData();
            Player player = event.getPlayer();
            Location loc = clicked.getLocation();
            switch (type) {
                case LEVER: 
                case WOOD_BUTTON: 
                case STONE_BUTTON: {
                    if (!wcfg.isLogging(Logging.SWITCHINTERACT) || event.getAction() != Action.RIGHT_CLICK_BLOCK) break;
                    this.consumer.queueBlock(Actor.actorFromEntity((Entity)player), loc, typeId, typeId, blockData);
                    break;
                }
                case FENCE_GATE: 
                case WOODEN_DOOR: 
                case TRAP_DOOR: {
                    if (!wcfg.isLogging(Logging.DOORINTERACT) || event.getAction() != Action.RIGHT_CLICK_BLOCK) break;
                    this.consumer.queueBlock(Actor.actorFromEntity((Entity)player), loc, typeId, typeId, blockData);
                    break;
                }
                case CAKE_BLOCK: {
                    if (!wcfg.isLogging(Logging.CAKEEAT) || event.getAction() != Action.RIGHT_CLICK_BLOCK || player.getFoodLevel() >= 20) break;
                    this.consumer.queueBlock(Actor.actorFromEntity((Entity)player), loc, typeId, typeId, blockData);
                    break;
                }
                case NOTE_BLOCK: {
                    if (!wcfg.isLogging(Logging.NOTEBLOCKINTERACT) || event.getAction() != Action.RIGHT_CLICK_BLOCK) break;
                    this.consumer.queueBlock(Actor.actorFromEntity((Entity)player), loc, typeId, typeId, blockData);
                    break;
                }
                case DIODE_BLOCK_OFF: 
                case DIODE_BLOCK_ON: {
                    if (!wcfg.isLogging(Logging.DIODEINTERACT) || event.getAction() != Action.RIGHT_CLICK_BLOCK) break;
                    this.consumer.queueBlock(Actor.actorFromEntity((Entity)player), loc, typeId, typeId, blockData);
                    break;
                }
                case REDSTONE_COMPARATOR_OFF: 
                case REDSTONE_COMPARATOR_ON: {
                    if (!wcfg.isLogging(Logging.COMPARATORINTERACT) || event.getAction() != Action.RIGHT_CLICK_BLOCK) break;
                    this.consumer.queueBlock(Actor.actorFromEntity((Entity)player), loc, typeId, typeId, blockData);
                    break;
                }
                case WOOD_PLATE: 
                case STONE_PLATE: 
                case IRON_PLATE: 
                case GOLD_PLATE: {
                    if (!wcfg.isLogging(Logging.PRESUREPLATEINTERACT) || event.getAction() != Action.PHYSICAL) break;
                    this.consumer.queueBlock(Actor.actorFromEntity((Entity)player), loc, typeId, typeId, blockData);
                    break;
                }
                case TRIPWIRE: {
                    if (!wcfg.isLogging(Logging.TRIPWIREINTERACT) || event.getAction() != Action.PHYSICAL) break;
                    this.consumer.queueBlock(Actor.actorFromEntity((Entity)player), loc, typeId, typeId, blockData);
                    break;
                }
                case SOIL: {
                    if (!wcfg.isLogging(Logging.CROPTRAMPLE) || event.getAction() != Action.PHYSICAL) break;
                    this.consumer.queueBlock(Actor.actorFromEntity((Entity)player), loc, typeId, 3, blockData);
                    Block trampledCrop = clicked.getRelative(BlockFace.UP);
                    if (!BukkitUtils.getCropBlocks().contains(trampledCrop.getType())) break;
                    this.consumer.queueBlockBreak(Actor.actorFromEntity((Entity)player), trampledCrop.getState());
                }
            }
        }
    }
}

