/*
 * Decompiled with CFR 0.152.
 */
package de.diddiz.LogBlock.listeners;

import de.diddiz.LogBlock.Actor;
import de.diddiz.LogBlock.LogBlock;
import de.diddiz.LogBlock.Logging;
import de.diddiz.LogBlock.config.Config;
import de.diddiz.LogBlock.listeners.LoggingListener;
import de.diddiz.util.BukkitUtils;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Location;
import org.bukkit.block.BlockState;
import org.bukkit.block.DoubleChest;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;

public class ChestAccessLogging
extends LoggingListener {
    private final Map<HumanEntity, ItemStack[]> containers = new HashMap<HumanEntity, ItemStack[]>();

    public ChestAccessLogging(LogBlock lb) {
        super(lb);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onInventoryClose(InventoryCloseEvent event) {
        HumanEntity player;
        ItemStack[] before;
        if (!Config.isLogging(event.getPlayer().getWorld(), Logging.CHESTACCESS)) {
            return;
        }
        InventoryHolder holder = event.getInventory().getHolder();
        if ((holder instanceof BlockState || holder instanceof DoubleChest) && (before = this.containers.get(player = event.getPlayer())) != null) {
            ItemStack[] after = BukkitUtils.compressInventory(event.getInventory().getContents());
            ItemStack[] diff = BukkitUtils.compareInventories(before, after);
            Location loc = BukkitUtils.getInventoryHolderLocation(holder);
            for (ItemStack item : diff) {
                this.consumer.queueChestAccess(Actor.actorFromEntity((Entity)player), loc, loc.getWorld().getBlockTypeIdAt(loc), (short)item.getTypeId(), (short)item.getAmount(), BukkitUtils.rawData(item));
            }
            this.containers.remove(player);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onInventoryOpen(InventoryOpenEvent event) {
        InventoryHolder holder;
        if (!Config.isLogging(event.getPlayer().getWorld(), Logging.CHESTACCESS)) {
            return;
        }
        if (event.getInventory() != null && ((holder = event.getInventory().getHolder()) instanceof BlockState || holder instanceof DoubleChest) && BukkitUtils.getInventoryHolderType(holder) != 58) {
            this.containers.put(event.getPlayer(), BukkitUtils.compressInventory(event.getInventory().getContents()));
        }
    }
}

