/*
 * Decompiled with CFR 0.152.
 */
package de.diddiz.LogBlock;

import de.diddiz.LogBlock.Actor;
import de.diddiz.LogBlock.BlockChange;
import de.diddiz.LogBlock.ChatMessage;
import de.diddiz.LogBlock.ChestAccess;
import de.diddiz.LogBlock.LogBlock;
import de.diddiz.LogBlock.config.Config;
import de.diddiz.LogBlock.events.BlockChangePreLogEvent;
import de.diddiz.util.BukkitUtils;
import de.diddiz.util.Utils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.TimerTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.BlockState;
import org.bukkit.block.Sign;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.Event;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.projectiles.ProjectileSource;

public class Consumer
extends TimerTask {
    private final Queue<Row> queue = new LinkedBlockingQueue<Row>();
    private final Set<Actor> failedPlayers = new HashSet<Actor>();
    private final LogBlock logblock;
    private final Map<Actor, Integer> playerIds = new HashMap<Actor, Integer>();
    private final Lock lock = new ReentrantLock();

    Consumer(LogBlock logblock) {
        this.logblock = logblock;
        try {
            Class.forName("PlayerLeaveRow");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    public void queueBlock(Actor actor, Location loc, int typeBefore, int typeAfter, byte data) {
        this.queueBlock(actor, loc, typeBefore, typeAfter, data, null, null);
    }

    public void queueBlockBreak(Actor actor, BlockState before) {
        this.queueBlockBreak(actor, new Location(before.getWorld(), (double)before.getX(), (double)before.getY(), (double)before.getZ()), before.getTypeId(), before.getRawData());
    }

    public void queueBlockBreak(Actor actor, Location loc, int typeBefore, byte dataBefore) {
        this.queueBlock(actor, loc, typeBefore, 0, dataBefore);
    }

    public void queueBlockPlace(Actor actor, BlockState after) {
        this.queueBlockPlace(actor, new Location(after.getWorld(), (double)after.getX(), (double)after.getY(), (double)after.getZ()), after.getBlock().getTypeId(), after.getBlock().getData());
    }

    public void queueBlockPlace(Actor actor, Location loc, int type, byte data) {
        this.queueBlock(actor, loc, 0, type, data);
    }

    public void queueBlockReplace(Actor actor, BlockState before, BlockState after) {
        this.queueBlockReplace(actor, new Location(before.getWorld(), (double)before.getX(), (double)before.getY(), (double)before.getZ()), before.getTypeId(), before.getRawData(), after.getTypeId(), after.getRawData());
    }

    public void queueBlockReplace(Actor actor, BlockState before, int typeAfter, byte dataAfter) {
        this.queueBlockReplace(actor, new Location(before.getWorld(), (double)before.getX(), (double)before.getY(), (double)before.getZ()), before.getTypeId(), before.getRawData(), typeAfter, dataAfter);
    }

    public void queueBlockReplace(Actor actor, int typeBefore, byte dataBefore, BlockState after) {
        this.queueBlockReplace(actor, new Location(after.getWorld(), (double)after.getX(), (double)after.getY(), (double)after.getZ()), typeBefore, dataBefore, after.getTypeId(), after.getRawData());
    }

    public void queueBlockReplace(Actor actor, Location loc, int typeBefore, byte dataBefore, int typeAfter, byte dataAfter) {
        if (dataBefore == 0 && typeBefore != typeAfter) {
            this.queueBlock(actor, loc, typeBefore, typeAfter, dataAfter);
        } else {
            this.queueBlockBreak(actor, loc, typeBefore, dataBefore);
            this.queueBlockPlace(actor, loc, typeAfter, dataAfter);
        }
    }

    public void queueChestAccess(Actor actor, BlockState container, short itemType, short itemAmount, short itemData) {
        if (!(container instanceof InventoryHolder)) {
            throw new IllegalArgumentException("Container must be instanceof InventoryHolder");
        }
        this.queueChestAccess(actor, new Location(container.getWorld(), (double)container.getX(), (double)container.getY(), (double)container.getZ()), container.getTypeId(), itemType, itemAmount, itemData);
    }

    public void queueChestAccess(Actor actor, Location loc, int type, short itemType, short itemAmount, short itemData) {
        this.queueBlock(actor, loc, type, type, (byte)0, null, new ChestAccess(itemType, itemAmount, itemData));
    }

    public void queueContainerBreak(Actor actor, BlockState container) {
        if (!(container instanceof InventoryHolder)) {
            return;
        }
        this.queueContainerBreak(actor, new Location(container.getWorld(), (double)container.getX(), (double)container.getY(), (double)container.getZ()), container.getTypeId(), container.getRawData(), ((InventoryHolder)container).getInventory());
    }

    public void queueContainerBreak(Actor actor, Location loc, int type, byte data, Inventory inv) {
        ItemStack[] items;
        for (ItemStack item : items = BukkitUtils.compressInventory(inv.getContents())) {
            this.queueChestAccess(actor, loc, type, (short)item.getTypeId(), (short)(item.getAmount() * -1), BukkitUtils.rawData(item));
        }
        this.queueBlockBreak(actor, loc, type, data);
    }

    public void queueKill(Entity killer, Entity victim) {
        if (killer == null || victim == null) {
            return;
        }
        int weapon = 0;
        Actor killerActor = Actor.actorFromEntity(killer);
        if (killer instanceof Player && ((Player)killer).getItemInHand() != null) {
            weapon = ((Player)killer).getItemInHand().getTypeId();
        }
        if (killer instanceof Projectile) {
            weapon = BukkitUtils.itemIDfromProjectileEntity(killer);
            ProjectileSource ps = ((Projectile)killer).getShooter();
            killerActor = ps == null ? Actor.actorFromEntity(killer) : Actor.actorFromProjectileSource(ps);
        }
        this.queueKill(victim.getLocation(), killerActor, Actor.actorFromEntity(victim), weapon);
    }

    public void queueKill(Actor killer, Entity victim) {
        if (killer == null || victim == null) {
            return;
        }
        this.queueKill(victim.getLocation(), killer, Actor.actorFromEntity(victim), 0);
    }

    @Deprecated
    public void queueKill(World world, Actor killer, Actor victim, int weapon) {
        this.queueKill(new Location(world, 0.0, 0.0, 0.0), killer, victim, weapon);
    }

    public void queueKill(Location location, Actor killer, Actor victim, int weapon) {
        if (victim == null || !Config.isLogged(location.getWorld())) {
            return;
        }
        this.queue.add(new KillRow(location, killer == null ? null : killer, victim, weapon));
    }

    public void queueSignBreak(Actor actor, Location loc, int type, byte data, String[] lines) {
        if (type != 63 && type != 68 || lines == null || lines.length != 4) {
            return;
        }
        this.queueBlock(actor, loc, type, 0, data, lines[0] + "\u0000" + lines[1] + "\u0000" + lines[2] + "\u0000" + lines[3], null);
    }

    public void queueSignBreak(Actor actor, Sign sign) {
        this.queueSignBreak(actor, new Location(sign.getWorld(), (double)sign.getX(), (double)sign.getY(), (double)sign.getZ()), sign.getTypeId(), sign.getRawData(), sign.getLines());
    }

    public void queueSignPlace(Actor actor, Location loc, int type, byte data, String[] lines) {
        if (type != 63 && type != 68 || lines == null || lines.length != 4) {
            return;
        }
        this.queueBlock(actor, loc, 0, type, data, lines[0] + "\u0000" + lines[1] + "\u0000" + lines[2] + "\u0000" + lines[3], null);
    }

    public void queueSignPlace(Actor actor, Sign sign) {
        this.queueSignPlace(actor, new Location(sign.getWorld(), (double)sign.getX(), (double)sign.getY(), (double)sign.getZ()), sign.getTypeId(), sign.getRawData(), sign.getLines());
    }

    public void queueChat(Actor player, String message) {
        for (String ignored : Config.ignoredChat) {
            if (!message.startsWith(ignored)) continue;
            return;
        }
        if (Config.hiddenPlayers.contains(player.getName().toLowerCase())) {
            return;
        }
        this.queue.add(new ChatRow(player, message));
    }

    public void queueJoin(Player player) {
        this.queue.add(new PlayerJoinRow(player));
    }

    public void queueLeave(Player player) {
        this.queue.add(new PlayerLeaveRow(player));
    }

    public void queueBlock(String playerName, Location loc, int typeBefore, int typeAfter, byte data) {
        this.queueBlock(Actor.actorFromString(playerName), loc, typeBefore, typeAfter, data);
    }

    public void queueBlockBreak(String playerName, BlockState before) {
        this.queueBlockBreak(Actor.actorFromString(playerName), before);
    }

    public void queueBlockBreak(String playerName, Location loc, int typeBefore, byte dataBefore) {
        this.queueBlockBreak(Actor.actorFromString(playerName), loc, typeBefore, dataBefore);
    }

    public void queueBlockPlace(String playerName, BlockState after) {
        this.queueBlockPlace(Actor.actorFromString(playerName), after);
    }

    public void queueBlockPlace(String playerName, Location loc, int type, byte data) {
        this.queueBlockPlace(Actor.actorFromString(playerName), loc, type, data);
    }

    public void queueBlockReplace(String playerName, BlockState before, BlockState after) {
        this.queueBlockReplace(Actor.actorFromString(playerName), before, after);
    }

    public void queueBlockReplace(String playerName, BlockState before, int typeAfter, byte dataAfter) {
        this.queueBlockReplace(Actor.actorFromString(playerName), before, typeAfter, dataAfter);
    }

    public void queueBlockReplace(String playerName, int typeBefore, byte dataBefore, BlockState after) {
        this.queueBlockReplace(Actor.actorFromString(playerName), typeBefore, dataBefore, after);
    }

    public void queueBlockReplace(String playerName, Location loc, int typeBefore, byte dataBefore, int typeAfter, byte dataAfter) {
        this.queueBlockReplace(Actor.actorFromString(playerName), loc, typeBefore, dataBefore, typeAfter, dataAfter);
    }

    public void queueChestAccess(String playerName, BlockState container, short itemType, short itemAmount, short itemData) {
        this.queueChestAccess(Actor.actorFromString(playerName), container, itemType, itemAmount, itemData);
    }

    public void queueChestAccess(String playerName, Location loc, int type, short itemType, short itemAmount, short itemData) {
        this.queueChestAccess(Actor.actorFromString(playerName), loc, type, itemType, itemAmount, itemData);
    }

    public void queueContainerBreak(String playerName, BlockState container) {
        this.queueContainerBreak(Actor.actorFromString(playerName), container);
    }

    public void queueContainerBreak(String playerName, Location loc, int type, byte data, Inventory inv) {
        this.queueContainerBreak(Actor.actorFromString(playerName), loc, type, data, inv);
    }

    public void queueKill(String killer, Entity victim) {
        this.queueKill(Actor.actorFromString(killer), victim);
    }

    @Deprecated
    public void queueKill(World world, String killerName, String victimName, int weapon) {
        this.queueKill(world, Actor.actorFromString(killerName), Actor.actorFromString(victimName), weapon);
    }

    public void queueKill(Location location, String killerName, String victimName, int weapon) {
        this.queueKill(location, Actor.actorFromString(killerName), Actor.actorFromString(victimName), weapon);
    }

    public void queueSignBreak(String playerName, Location loc, int type, byte data, String[] lines) {
        this.queueSignBreak(Actor.actorFromString(playerName), loc, type, data, lines);
    }

    public void queueSignBreak(String playerName, Sign sign) {
        this.queueSignBreak(Actor.actorFromString(playerName), sign);
    }

    public void queueSignPlace(String playerName, Location loc, int type, byte data, String[] lines) {
        this.queueSignPlace(Actor.actorFromString(playerName), loc, type, data, lines);
    }

    public void queueSignPlace(String playerName, Sign sign) {
        this.queueSignPlace(Actor.actorFromString(playerName), sign);
    }

    public void queueChat(String player, String message) {
        this.queueChat(Actor.actorFromString(player), message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public synchronized void run() {
        block40: {
            int count;
            Statement state;
            Connection conn;
            long startTime;
            block38: {
                if (this.queue.isEmpty() || !this.lock.tryLock()) {
                    return;
                }
                startTime = System.currentTimeMillis();
                int startSize = this.queue.size();
                conn = this.logblock.getConnection();
                state = null;
                if (Config.queueWarningSize > 0 && this.queue.size() >= Config.queueWarningSize) {
                    Bukkit.getLogger().info("[Consumer] Queue overloaded. Size: " + this.getQueueSize());
                }
                count = 0;
                if (conn != null) break block38;
                try {
                    if (state != null) {
                        state.close();
                    }
                    if (conn != null) {
                        conn.close();
                    }
                }
                catch (SQLException ex) {
                    Bukkit.getLogger().log(Level.SEVERE, "[Consumer] SQL exception on close", ex);
                }
                this.lock.unlock();
                if (Config.debug) {
                    long timeElapsed = System.currentTimeMillis() - startTime;
                    float rowPerTime = (long)count / timeElapsed;
                    Bukkit.getLogger().log(Level.INFO, "[Consumer] Finished consumer cycle in " + timeElapsed + " milliseconds.");
                    Bukkit.getLogger().log(Level.INFO, "[Consumer] Total rows processed: " + count + ". row/time: " + String.format("%.4f", Float.valueOf(rowPerTime)));
                }
                return;
            }
            conn.setAutoCommit(false);
            state = conn.createStatement();
            long start = System.currentTimeMillis();
            block17: while (!(this.queue.isEmpty() || System.currentTimeMillis() - start >= (long)Config.timePerRun && count >= Config.forceToProcessAtLeast)) {
                block39: {
                    Row r = this.queue.poll();
                    if (r == null) continue;
                    for (Actor actor : r.getActors()) {
                        if (this.playerIds.containsKey(actor) || this.addPlayer(state, actor)) continue;
                        if (this.failedPlayers.contains(actor)) continue block17;
                        this.failedPlayers.add(actor);
                        Bukkit.getLogger().warning("[Consumer] Failed to add player " + actor.getName());
                        continue block17;
                    }
                    if (r instanceof PreparedStatementRow) {
                        PreparedStatementRow PSRow = (PreparedStatementRow)r;
                        if (r instanceof MergeableRow) {
                            int batchCount = count;
                            if (count > Config.forceToProcessAtLeast) {
                                batchCount = Config.forceToProcessAtLeast / 2;
                            }
                            while (!this.queue.isEmpty()) {
                                MergeableRow mRow2;
                                MergeableRow mRow = (MergeableRow)PSRow;
                                Row s = this.queue.peek();
                                if (s == null || !(s instanceof MergeableRow) || !mRow.canMerge(mRow2 = (MergeableRow)s)) break;
                                PSRow = mRow.merge((MergeableRow)this.queue.poll());
                                ++count;
                                if (++batchCount <= Config.forceToProcessAtLeast) continue;
                                break;
                            }
                        }
                        PSRow.setConnection(conn);
                        try {
                            PSRow.executeStatements();
                            break block39;
                        }
                        catch (SQLException ex) {
                            Bukkit.getLogger().log(Level.SEVERE, "[Consumer] SQL exception on insertion: ", ex);
                            break;
                        }
                    }
                    for (String insert : r.getInserts()) {
                        try {
                            state.execute(insert);
                        }
                        catch (SQLException ex) {
                            Bukkit.getLogger().log(Level.SEVERE, "[Consumer] SQL exception on " + (String)insert + ": ", ex);
                            break block17;
                        }
                    }
                }
                ++count;
            }
            conn.commit();
            try {
                if (state != null) {
                    state.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException ex) {
                Bukkit.getLogger().log(Level.SEVERE, "[Consumer] SQL exception on close", ex);
            }
            this.lock.unlock();
            if (Config.debug) {
                long timeElapsed = System.currentTimeMillis() - startTime;
                float rowPerTime = (long)count / timeElapsed;
                Bukkit.getLogger().log(Level.INFO, "[Consumer] Finished consumer cycle in " + timeElapsed + " milliseconds.");
                Bukkit.getLogger().log(Level.INFO, "[Consumer] Total rows processed: " + count + ". row/time: " + String.format("%.4f", Float.valueOf(rowPerTime)));
            }
            break block40;
            catch (SQLException ex) {
                try {
                    Bukkit.getLogger().log(Level.SEVERE, "[Consumer] SQL exception", ex);
                }
                catch (Throwable throwable) {
                    try {
                        if (state != null) {
                            state.close();
                        }
                        if (conn != null) {
                            conn.close();
                        }
                    }
                    catch (SQLException ex2) {
                        Bukkit.getLogger().log(Level.SEVERE, "[Consumer] SQL exception on close", ex2);
                    }
                    this.lock.unlock();
                    if (Config.debug) {
                        long timeElapsed2 = System.currentTimeMillis() - startTime;
                        float rowPerTime2 = (long)count / timeElapsed2;
                        Bukkit.getLogger().log(Level.INFO, "[Consumer] Finished consumer cycle in " + timeElapsed2 + " milliseconds.");
                        Bukkit.getLogger().log(Level.INFO, "[Consumer] Total rows processed: " + count + ". row/time: " + String.format("%.4f", Float.valueOf(rowPerTime2)));
                    }
                    throw throwable;
                }
                try {
                    if (state != null) {
                        state.close();
                    }
                    if (conn != null) {
                        conn.close();
                    }
                }
                catch (SQLException ex3) {
                    Bukkit.getLogger().log(Level.SEVERE, "[Consumer] SQL exception on close", ex3);
                }
                this.lock.unlock();
                if (Config.debug) {
                    long timeElapsed = System.currentTimeMillis() - startTime;
                    float rowPerTime = (long)count / timeElapsed;
                    Bukkit.getLogger().log(Level.INFO, "[Consumer] Finished consumer cycle in " + timeElapsed + " milliseconds.");
                    Bukkit.getLogger().log(Level.INFO, "[Consumer] Total rows processed: " + count + ". row/time: " + String.format("%.4f", Float.valueOf(rowPerTime)));
                }
            }
        }
    }

    public void writeToFile() throws FileNotFoundException {
        long time = System.currentTimeMillis();
        HashSet<Actor> insertedPlayers = new HashSet<Actor>();
        int counter = 0;
        new File("plugins/LogBlock/import/").mkdirs();
        PrintWriter writer = new PrintWriter(new File("plugins/LogBlock/import/queue-" + time + "-0.sql"));
        while (!this.queue.isEmpty()) {
            Row r = this.queue.poll();
            if (r == null) continue;
            for (Actor actor : r.getActors()) {
                if (this.playerIds.containsKey(actor) || insertedPlayers.contains(actor)) continue;
                writer.println("INSERT IGNORE INTO `lb-players` (playername,UUID) SELECT '" + Utils.mysqlTextEscape(actor.getName()) + "','" + actor.getUUID() + "' FROM `lb-players` WHERE NOT EXISTS (SELECT NULL FROM `lb-players` WHERE UUID = '" + actor.getUUID() + "') LIMIT 1;");
                insertedPlayers.add(actor);
            }
            for (String insert : r.getInserts()) {
                writer.println(insert);
            }
            if (++counter % 1000 != 0) continue;
            writer.close();
            writer = new PrintWriter(new File("plugins/LogBlock/import/queue-" + time + "-" + counter / 1000 + ".sql"));
        }
        writer.close();
    }

    int getQueueSize() {
        return this.queue.size();
    }

    static void hide(Player player) {
        Config.hiddenPlayers.add(player.getName().toLowerCase());
    }

    static void unHide(Player player) {
        Config.hiddenPlayers.remove(player.getName().toLowerCase());
    }

    static boolean toggleHide(Player player) {
        String playerName = player.getName().toLowerCase();
        if (Config.hiddenPlayers.contains(playerName)) {
            Config.hiddenPlayers.remove(playerName);
            return false;
        }
        Config.hiddenPlayers.add(playerName);
        return true;
    }

    private boolean addPlayer(Statement state, Actor actor) throws SQLException {
        String name = actor.getName();
        String uuid = actor.getUUID();
        state.execute("INSERT IGNORE INTO `lb-players` (playername,UUID) SELECT '" + Utils.mysqlTextEscape(name) + "','" + uuid + "' FROM `lb-players` WHERE NOT EXISTS (SELECT NULL FROM `lb-players` WHERE UUID = '" + uuid + "') LIMIT 1;");
        ResultSet rs = state.executeQuery("SELECT playerid FROM `lb-players` WHERE UUID = '" + uuid + "'");
        if (rs.next()) {
            this.playerIds.put(actor, rs.getInt(1));
        }
        rs.close();
        return this.playerIds.containsKey(actor);
    }

    private void queueBlock(Actor actor, Location loc, int typeBefore, int typeAfter, byte data, String signtext, ChestAccess ca) {
        if (Config.fireCustomEvents) {
            BlockChangePreLogEvent event = new BlockChangePreLogEvent(actor, loc, typeBefore, typeAfter, data, signtext, ca);
            this.logblock.getServer().getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                return;
            }
            actor = event.getOwnerActor();
            loc = event.getLocation();
            typeBefore = event.getTypeBefore();
            typeAfter = event.getTypeAfter();
            data = event.getData();
            signtext = event.getSignText();
            ca = event.getChestAccess();
        }
        if (actor == null || loc == null || typeBefore < 0 || typeAfter < 0 || Config.safetyIdCheck && (typeBefore > 255 || typeAfter > 255) || Config.hiddenPlayers.contains(actor.getName().toLowerCase()) || !Config.isLogged(loc.getWorld()) || typeBefore != typeAfter && Config.hiddenBlocks.contains(typeBefore) && Config.hiddenBlocks.contains(typeAfter)) {
            return;
        }
        this.queue.add(new BlockRow(loc, actor, typeBefore, typeAfter, data, signtext, ca));
    }

    private String playerID(Actor actor) {
        if (actor == null) {
            return "NULL";
        }
        Integer id = this.playerIds.get(actor);
        if (id != null) {
            return id.toString();
        }
        return "(SELECT playerid FROM `lb-players` WHERE UUID = '" + actor.getUUID() + "')";
    }

    private Integer playerIDAsInt(Actor actor) {
        if (actor == null) {
            return null;
        }
        return this.playerIds.get(actor);
    }

    private int safeY(Location loc) {
        int safeY = loc.getBlockY();
        if (safeY < 0) {
            safeY = 0;
        }
        if (safeY > 65535) {
            safeY = 65535;
        }
        return safeY;
    }

    private class PlayerLeaveRow
    implements Row {
        private final long leaveTime = System.currentTimeMillis() / 1000L;
        private final Actor actor;

        PlayerLeaveRow(Player player) {
            this.actor = Actor.actorFromEntity((Entity)player);
        }

        @Override
        public String[] getInserts() {
            if (Config.logPlayerInfo) {
                return new String[]{"UPDATE `lb-players` SET onlinetime = onlinetime + TIMESTAMPDIFF(SECOND, lastlogin, FROM_UNIXTIME('" + this.leaveTime + "')), playername = '" + Utils.mysqlTextEscape(this.actor.getName()) + "' WHERE lastlogin > 0 && UUID = '" + this.actor.getUUID() + "';"};
            }
            return new String[]{"UPDATE `lb-players` SET playername = '" + Utils.mysqlTextEscape(this.actor.getName()) + "' WHERE UUID = '" + this.actor.getUUID() + "';"};
        }

        @Override
        public String[] getPlayers() {
            return new String[]{this.actor.getName()};
        }

        @Override
        public Actor[] getActors() {
            return new Actor[]{this.actor};
        }
    }

    private class PlayerJoinRow
    implements Row {
        private final Actor player;
        private final long lastLogin;
        private final String ip;

        PlayerJoinRow(Player player) {
            this.player = Actor.actorFromEntity((Entity)player);
            this.lastLogin = System.currentTimeMillis() / 1000L;
            this.ip = player.getAddress().toString().replace("'", "\\'");
        }

        @Override
        public String[] getInserts() {
            if (Config.logPlayerInfo) {
                return new String[]{"UPDATE `lb-players` SET lastlogin = FROM_UNIXTIME(" + this.lastLogin + "), firstlogin = IF(firstlogin = 0, FROM_UNIXTIME(" + this.lastLogin + "), firstlogin), ip = '" + this.ip + "', playername = '" + Utils.mysqlTextEscape(this.player.getName()) + "' WHERE UUID = '" + this.player.getUUID() + "';"};
            }
            return new String[]{"UPDATE `lb-players` SET playername = '" + Utils.mysqlTextEscape(this.player.getName()) + "' WHERE UUID = '" + this.player.getUUID() + "';"};
        }

        @Override
        public String[] getPlayers() {
            return new String[]{this.player.getName()};
        }

        @Override
        public Actor[] getActors() {
            return new Actor[]{this.player};
        }
    }

    private class ChatRow
    extends ChatMessage
    implements PreparedStatementRow {
        private Connection connection;

        ChatRow(Actor player, String message) {
            super(player, message);
        }

        @Override
        public String[] getInserts() {
            return new String[]{"INSERT INTO `lb-chat` (date, playerid, message) VALUES (FROM_UNIXTIME(" + this.date + "), " + Consumer.this.playerID(this.player) + ", '" + Utils.mysqlTextEscape(this.message) + "');"};
        }

        @Override
        public String[] getPlayers() {
            return new String[]{this.player.getName()};
        }

        @Override
        public Actor[] getActors() {
            return new Actor[]{this.player};
        }

        @Override
        public void setConnection(Connection connection) {
            this.connection = connection;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void executeStatements() throws SQLException {
            boolean noID = false;
            String sql = "INSERT INTO `lb-chat` (date, playerid, message) VALUES (FROM_UNIXTIME(?), ";
            Integer id = Consumer.this.playerIDAsInt(this.player);
            if (id == null) {
                noID = true;
                sql = sql + Consumer.this.playerID(this.player) + ", ";
            } else {
                sql = sql + "?, ";
            }
            sql = sql + "?)";
            PreparedStatement ps = null;
            try {
                ps = this.connection.prepareStatement(sql);
                ps.setLong(1, this.date);
                if (!noID) {
                    ps.setInt(2, id);
                    ps.setString(3, this.message);
                } else {
                    ps.setString(2, this.message);
                }
                ps.execute();
            }
            finally {
                if (ps != null) {
                    try {
                        ps.close();
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    private class KillRow
    implements Row {
        final long date = System.currentTimeMillis() / 1000L;
        final Actor killer;
        final Actor victim;
        final int weapon;
        final Location loc;

        KillRow(Location loc, Actor attacker, Actor defender, int weapon) {
            this.loc = loc;
            this.killer = attacker;
            this.victim = defender;
            this.weapon = weapon;
        }

        @Override
        public String[] getInserts() {
            return new String[]{"INSERT INTO `" + Config.getWorldConfig((World)this.loc.getWorld()).table + "-kills` (date, killer, victim, weapon, x, y, z) VALUES (FROM_UNIXTIME(" + this.date + "), " + Consumer.this.playerID(this.killer) + ", " + Consumer.this.playerID(this.victim) + ", " + this.weapon + ", " + this.loc.getBlockX() + ", " + Consumer.this.safeY(this.loc) + ", " + this.loc.getBlockZ() + ");"};
        }

        @Override
        public String[] getPlayers() {
            return new String[]{this.killer.getName(), this.victim.getName()};
        }

        @Override
        public Actor[] getActors() {
            return new Actor[]{this.killer, this.victim};
        }
    }

    private class MultiBlockChangeRow
    implements MergeableRow {
        private List<BlockRow> rows = new ArrayList<BlockRow>();
        private Connection connection;
        private Set<String> players = new HashSet<String>();
        private Set<Actor> actors = new HashSet<Actor>();
        private String table;

        MultiBlockChangeRow(BlockRow first, BlockRow second) {
            if (first.isUnique() || second.isUnique()) {
                throw new IllegalArgumentException("Can't merge a unique row");
            }
            this.rows.add(first);
            this.rows.add(second);
            this.actors.addAll(Arrays.asList(first.getActors()));
            this.actors.addAll(Arrays.asList(second.getActors()));
            this.players.addAll(Arrays.asList(first.getPlayers()));
            this.players.addAll(Arrays.asList(second.getPlayers()));
            this.table = Config.getWorldConfig((World)first.loc.getWorld()).table;
        }

        @Override
        public void setConnection(Connection connection) {
            this.connection = connection;
        }

        @Override
        public void executeStatements() throws SQLException {
            Statement ps = null;
            try {
                ps = this.connection.prepareStatement("INSERT INTO `" + this.table + "` (date, playerid, replaced, type, data, x, y, z) VALUES(FROM_UNIXTIME(?), ?, ?, ?, ?, ?, ?, ?)");
                for (BlockRow row : this.rows) {
                    ps.setLong(1, row.date);
                    ps.setInt(2, (Integer)Consumer.this.playerIds.get(row.actor));
                    ps.setInt(3, row.replaced);
                    ps.setInt(4, row.type);
                    ps.setInt(5, row.data);
                    ps.setInt(6, row.loc.getBlockX());
                    ps.setInt(7, Consumer.this.safeY(row.loc));
                    ps.setInt(8, row.loc.getBlockZ());
                    ps.addBatch();
                }
                ps.executeBatch();
            }
            catch (SQLException ex) {
                if (ps != null) {
                    Bukkit.getLogger().log(Level.SEVERE, "[Consumer] Troublesome query: " + ps.toString());
                }
                throw ex;
            }
            finally {
                if (ps != null) {
                    try {
                        ps.close();
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                    }
                }
            }
        }

        @Override
        public boolean isUnique() {
            return true;
        }

        @Override
        public boolean canMerge(MergeableRow row) {
            return !row.isUnique() && row instanceof BlockRow && this.table.equals(Config.getWorldConfig((World)((BlockRow)row).loc.getWorld()).table);
        }

        @Override
        public MergeableRow merge(MergeableRow second) {
            if (second.isUnique()) {
                throw new IllegalArgumentException("Can't merge a unique row");
            }
            this.rows.add((BlockRow)second);
            this.actors.addAll(Arrays.asList(second.getActors()));
            this.players.addAll(Arrays.asList(second.getPlayers()));
            return this;
        }

        @Override
        public String[] getInserts() {
            ArrayList<String> l = new ArrayList<String>();
            for (BlockRow row : this.rows) {
                l.addAll(Arrays.asList(row.getInserts()));
            }
            return (String[])l.toArray();
        }

        @Override
        public String[] getPlayers() {
            return (String[])this.players.toArray();
        }

        @Override
        public Actor[] getActors() {
            return (Actor[])this.actors.toArray();
        }
    }

    private class BlockRow
    extends BlockChange
    implements MergeableRow {
        private Connection connection;

        public BlockRow(Location loc, Actor actor, int replaced, int type, byte data, String signtext, ChestAccess ca) {
            super(System.currentTimeMillis() / 1000L, loc, actor, replaced, type, data, signtext, ca);
        }

        @Override
        public String[] getInserts() {
            String table = Config.getWorldConfig((World)this.loc.getWorld()).table;
            String[] inserts = new String[this.ca != null || this.signtext != null ? 2 : 1];
            inserts[0] = "INSERT INTO `" + table + "` (date, playerid, replaced, type, data, x, y, z) VALUES (FROM_UNIXTIME(" + this.date + "), " + Consumer.this.playerID(this.actor) + ", " + this.replaced + ", " + this.type + ", " + this.data + ", '" + this.loc.getBlockX() + "', " + Consumer.this.safeY(this.loc) + ", '" + this.loc.getBlockZ() + "');";
            if (this.signtext != null) {
                inserts[1] = "INSERT INTO `" + table + "-sign` (id, signtext) values (LAST_INSERT_ID(), '" + Utils.mysqlTextEscape(this.signtext) + "');";
            } else if (this.ca != null) {
                inserts[1] = "INSERT INTO `" + table + "-chest` (id, itemtype, itemamount, itemdata) values (LAST_INSERT_ID(), " + this.ca.itemType + ", " + this.ca.itemAmount + ", " + this.ca.itemData + ");";
            }
            return inserts;
        }

        @Override
        public String[] getPlayers() {
            return new String[]{this.actor.getName()};
        }

        @Override
        public Actor[] getActors() {
            return new Actor[]{this.actor};
        }

        @Override
        public void setConnection(Connection connection) {
            this.connection = connection;
        }

        @Override
        public void executeStatements() throws SQLException {
            String table = Config.getWorldConfig((World)this.loc.getWorld()).table;
            Statement ps1 = null;
            Statement ps = null;
            try {
                ps1 = this.connection.prepareStatement("INSERT INTO `" + table + "` (date, playerid, replaced, type, data, x, y, z) VALUES(FROM_UNIXTIME(?), " + Consumer.this.playerID(this.actor) + ", ?, ?, ?, ?, ?, ?)", 1);
                ps1.setLong(1, this.date);
                ps1.setInt(2, this.replaced);
                ps1.setInt(3, this.type);
                ps1.setInt(4, this.data);
                ps1.setInt(5, this.loc.getBlockX());
                ps1.setInt(6, Consumer.this.safeY(this.loc));
                ps1.setInt(7, this.loc.getBlockZ());
                ps1.executeUpdate();
                ResultSet rs = ps1.getGeneratedKeys();
                rs.next();
                int id = rs.getInt(1);
                if (this.signtext != null) {
                    ps = this.connection.prepareStatement("INSERT INTO `" + table + "-sign` (signtext, id) VALUES(?, ?)");
                    ps.setString(1, this.signtext);
                    ps.setInt(2, id);
                    ps.executeUpdate();
                } else if (this.ca != null) {
                    ps = this.connection.prepareStatement("INSERT INTO `" + table + "-chest` (itemtype, itemamount, itemdata, id) values (?, ?, ?, ?)");
                    ps.setInt(1, this.ca.itemType);
                    ps.setInt(2, this.ca.itemAmount);
                    ps.setInt(3, this.ca.itemData);
                    ps.setInt(4, id);
                    ps.executeUpdate();
                }
            }
            catch (SQLException ex) {
                if (ps1 != null) {
                    Bukkit.getLogger().log(Level.SEVERE, "[Consumer] Troublesome query: " + ps1.toString());
                }
                if (ps != null) {
                    Bukkit.getLogger().log(Level.SEVERE, "[Consumer] Troublesome query: " + ps.toString());
                }
                throw ex;
            }
            finally {
                if (ps1 != null) {
                    try {
                        ps1.close();
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                    }
                }
                if (ps != null) {
                    try {
                        ps.close();
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                    }
                }
            }
        }

        @Override
        public boolean isUnique() {
            return this.signtext != null || this.ca != null || !Consumer.this.playerIds.containsKey(this.actor);
        }

        @Override
        public boolean canMerge(MergeableRow row) {
            return !this.isUnique() && !row.isUnique() && row instanceof BlockRow && Config.getWorldConfig((World)this.loc.getWorld()).table.equals(Config.getWorldConfig((World)((BlockRow)row).loc.getWorld()).table);
        }

        @Override
        public MergeableRow merge(MergeableRow singleRow) {
            return new MultiBlockChangeRow(this, (BlockRow)singleRow);
        }
    }

    private static interface MergeableRow
    extends PreparedStatementRow {
        public boolean isUnique();

        public boolean canMerge(MergeableRow var1);

        public MergeableRow merge(MergeableRow var1);
    }

    private static interface PreparedStatementRow
    extends Row {
        public void setConnection(Connection var1);

        public void executeStatements() throws SQLException;
    }

    private static interface Row {
        public String[] getInserts();

        public String[] getPlayers();

        public Actor[] getActors();
    }
}

