/*
 * Decompiled with CFR 0.152.
 */
package de.cubeside.nmsutils.paper1_21_11;

import com.google.common.base.Preconditions;
import com.mojang.serialization.DynamicOps;
import de.cubeside.nmsutils.nbt.CompoundTag;
import de.cubeside.nmsutils.nbt.TagType;
import de.cubeside.nmsutils.paper1_21_11.ListTagImpl;
import io.papermc.paper.adventure.PaperAdventure;
import java.util.Collections;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.UUIDUtil;
import net.minecraft.nbt.ByteArrayTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongArrayTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.NumericTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.resources.RegistryOps;
import org.bukkit.craftbukkit.CraftRegistry;

public final class CompoundTagImpl
implements CompoundTag {
    final net.minecraft.nbt.CompoundTag handle;

    public CompoundTagImpl(net.minecraft.nbt.CompoundTag handle) {
        this.handle = handle;
    }

    @Override
    public boolean containsKey(String name) {
        return this.handle.contains(name);
    }

    @Override
    public boolean containsKey(String name, TagType type) {
        Tag value = this.handle.get(name);
        return value != null && value.getType() == TagTypes.getType((int)type.internalId());
    }

    @Override
    public void clear() {
        this.handle.keySet().clear();
    }

    @Override
    public void remove(String name) {
        this.handle.remove(name);
    }

    @Override
    public Set<String> getAllKeys() {
        return Collections.unmodifiableSet(this.handle.keySet());
    }

    @Override
    public int size() {
        return this.handle.size();
    }

    @Override
    public void merge(CompoundTag source) {
        this.handle.merge(((CompoundTagImpl)source).handle);
    }

    @Override
    public CompoundTagImpl getCompound(String name) {
        return this.getCompound(name, false);
    }

    @Override
    public CompoundTagImpl getCompound(String name, boolean createIfMissing) {
        Preconditions.checkNotNull((Object)name);
        Tag tag = this.handle.get(name);
        if (!(tag instanceof net.minecraft.nbt.CompoundTag)) {
            if (!createIfMissing) {
                return null;
            }
            tag = new net.minecraft.nbt.CompoundTag();
            this.handle.put(name, tag);
        }
        return new CompoundTagImpl((net.minecraft.nbt.CompoundTag)tag);
    }

    @Override
    public ListTagImpl getList(String name) {
        return this.getList(name, false);
    }

    @Override
    public ListTagImpl getList(String name, boolean createIfMissing) {
        Preconditions.checkNotNull((Object)name);
        Tag tag = this.handle.get(name);
        if (!(tag instanceof ListTag)) {
            if (!createIfMissing) {
                return null;
            }
            tag = new ListTag();
            this.handle.put(name, tag);
        }
        return new ListTagImpl((ListTag)tag);
    }

    @Override
    public byte getByte(String name) {
        return this.getByte(name, (byte)0);
    }

    @Override
    public byte getByte(String name, byte defaultValue) {
        Tag tag = this.handle.get(name);
        if (tag instanceof NumericTag) {
            NumericTag tag2 = (NumericTag)tag;
            return tag2.byteValue();
        }
        return defaultValue;
    }

    @Override
    public void setByte(String name, byte b2) {
        Preconditions.checkNotNull((Object)name);
        this.handle.putByte(name, b2);
    }

    @Override
    public short getShort(String name) {
        return this.getShort(name, (short)0);
    }

    @Override
    public short getShort(String name, short defaultValue) {
        Tag tag = this.handle.get(name);
        if (tag instanceof NumericTag) {
            NumericTag tag2 = (NumericTag)tag;
            return tag2.shortValue();
        }
        return defaultValue;
    }

    @Override
    public void setShort(String name, short s) {
        Preconditions.checkNotNull((Object)name);
        this.handle.putShort(name, s);
    }

    @Override
    public int getInt(String name) {
        return this.getInt(name, 0);
    }

    @Override
    public int getInt(String name, int defaultValue) {
        Tag tag = this.handle.get(name);
        if (tag instanceof NumericTag) {
            NumericTag tag2 = (NumericTag)tag;
            return tag2.intValue();
        }
        return defaultValue;
    }

    @Override
    public void setInt(String name, int v) {
        Preconditions.checkNotNull((Object)name);
        this.handle.putInt(name, v);
    }

    @Override
    public long getLong(String name) {
        return this.getLong(name, 0L);
    }

    @Override
    public long getLong(String name, long defaultValue) {
        Tag tag = this.handle.get(name);
        if (tag instanceof NumericTag) {
            NumericTag tag2 = (NumericTag)tag;
            return tag2.longValue();
        }
        return defaultValue;
    }

    @Override
    public void setLong(String name, long l) {
        Preconditions.checkNotNull((Object)name);
        this.handle.putLong(name, l);
    }

    @Override
    public float getFloat(String name) {
        return this.getFloat(name, 0.0f);
    }

    @Override
    public float getFloat(String name, float defaultValue) {
        Tag tag = this.handle.get(name);
        if (tag instanceof NumericTag) {
            NumericTag tag2 = (NumericTag)tag;
            return tag2.floatValue();
        }
        return defaultValue;
    }

    @Override
    public void setFloat(String name, float f2) {
        Preconditions.checkNotNull((Object)name);
        this.handle.putFloat(name, f2);
    }

    @Override
    public double getDouble(String name) {
        return this.getDouble(name, 0.0);
    }

    @Override
    public double getDouble(String name, double defaultValue) {
        Tag tag = this.handle.get(name);
        if (tag instanceof NumericTag) {
            NumericTag tag2 = (NumericTag)tag;
            return tag2.doubleValue();
        }
        return defaultValue;
    }

    @Override
    public void setDouble(String name, double d) {
        Preconditions.checkNotNull((Object)name);
        this.handle.putDouble(name, d);
    }

    @Override
    public byte[] getByteArray(String name) {
        return this.getByteArray(name, null);
    }

    @Override
    public byte[] getByteArray(String name, byte[] defaultValue) {
        Tag tag = this.handle.get(name);
        if (tag instanceof ByteArrayTag) {
            ByteArrayTag tag2 = (ByteArrayTag)tag;
            return tag2.getAsByteArray();
        }
        return defaultValue;
    }

    @Override
    public void setByteArray(String name, byte[] b2) {
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkNotNull((Object)b2);
        this.handle.putByteArray(name, b2);
    }

    @Override
    public int[] getIntArray(String name) {
        return this.getIntArray(name, null);
    }

    @Override
    public int[] getIntArray(String name, int[] defaultValue) {
        Tag tag = this.handle.get(name);
        if (tag instanceof IntArrayTag) {
            IntArrayTag tag2 = (IntArrayTag)tag;
            return tag2.getAsIntArray();
        }
        return defaultValue;
    }

    @Override
    public void setIntArray(String name, int[] v) {
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkNotNull((Object)v);
        this.handle.putIntArray(name, v);
    }

    @Override
    public long[] getLongArray(String name) {
        return this.getLongArray(name, null);
    }

    @Override
    public long[] getLongArray(String name, long[] defaultValue) {
        Tag tag = this.handle.get(name);
        if (tag instanceof LongArrayTag) {
            LongArrayTag tag2 = (LongArrayTag)tag;
            return tag2.getAsLongArray();
        }
        return defaultValue;
    }

    @Override
    public void setLongArray(String name, long[] v) {
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkNotNull((Object)v);
        this.handle.putLongArray(name, v);
    }

    @Override
    public String getString(String name) {
        return this.getString(name, null);
    }

    @Override
    public String getString(String name, String defaultValue) {
        Tag tag = this.handle.get(name);
        if (tag instanceof StringTag) {
            StringTag tag2 = (StringTag)tag;
            return tag2.value();
        }
        return defaultValue;
    }

    @Override
    public void setString(String name, String v) {
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkNotNull((Object)v);
        this.handle.putString(name, v);
    }

    @Override
    public UUID getUUID(String name) {
        return this.handle.read("UUID", UUIDUtil.CODEC).orElse(null);
    }

    @Override
    public boolean containsUUID(String name) {
        return this.handle.read("UUID", UUIDUtil.CODEC).isPresent();
    }

    @Override
    public void setUUID(String name, UUID v) {
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkNotNull((Object)v);
        this.handle.store(name, UUIDUtil.CODEC, (Object)v);
    }

    @Override
    public net.kyori.adventure.text.Component getTextComponent(String name) {
        Preconditions.checkNotNull((Object)name);
        Tag tag = this.handle.get(name);
        if (tag == null) {
            return null;
        }
        try {
            Component component = (Component)ComponentSerialization.CODEC.parse((DynamicOps)CraftRegistry.getMinecraftRegistry().createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)tag).getOrThrow();
            return PaperAdventure.asAdventure((Component)component);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public void setTextComponent(String name, net.kyori.adventure.text.Component value) {
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkNotNull((Object)value);
        Component component = PaperAdventure.asVanilla((net.kyori.adventure.text.Component)value);
        RegistryOps ops = CraftRegistry.getMinecraftRegistry().createSerializationContext((DynamicOps)NbtOps.INSTANCE);
        Tag result = (Tag)ComponentSerialization.CODEC.encodeStart((DynamicOps)ops, (Object)component).getOrThrow();
        this.handle.put(name, result);
    }

    @Override
    public int hashCode() {
        return this.handle.hashCode();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof CompoundTagImpl)) return false;
        CompoundTagImpl o = (CompoundTagImpl)obj;
        if (!this.handle.equals((Object)o.handle)) return false;
        return true;
    }

    @Override
    public CompoundTagImpl clone() {
        return new CompoundTagImpl(this.handle.copy());
    }
}

