/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.client.socket.impl;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import org.mariadb.jdbc.client.util.MutableInt;

public class CompressInputStream
extends InputStream {
    private final InputStream in;
    private final MutableInt sequence;
    private final byte[] header = new byte[7];
    private int end;
    private int pos;
    private byte[] buf;

    public CompressInputStream(InputStream in, MutableInt compressionSequence) {
        this.in = in;
        this.sequence = compressionSequence;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int copyLength;
        if (len == 0) {
            return 0;
        }
        int totalReads = 0;
        do {
            if (this.end - this.pos <= 0) {
                this.retrieveBuffer();
            }
            copyLength = Math.min(len - totalReads, this.end - this.pos);
            System.arraycopy(this.buf, this.pos, b, off + totalReads, copyLength);
            this.pos += copyLength;
        } while ((totalReads += copyLength) < len && super.available() > 0);
        return totalReads;
    }

    private void retrieveBuffer() throws IOException {
        int count;
        int count2;
        int remaining = 7;
        int readOffset = 0;
        do {
            if ((count2 = this.in.read(this.header, readOffset, remaining)) < 0) {
                throw new EOFException("unexpected end of stream, read " + readOffset + " bytes from 7 (socket was closed by server)");
            }
            readOffset += count2;
        } while ((remaining -= count2) > 0);
        int compressedPacketLength = (this.header[0] & 0xFF) + ((this.header[1] & 0xFF) << 8) + ((this.header[2] & 0xFF) << 16);
        this.sequence.set(this.header[3]);
        int packetLength = (this.header[4] & 0xFF) + ((this.header[5] & 0xFF) << 8) + ((this.header[6] & 0xFF) << 16);
        boolean compressed = packetLength != 0;
        remaining = compressedPacketLength;
        byte[] intermediaryBuf = new byte[remaining];
        readOffset = 0;
        do {
            if ((count = this.in.read(intermediaryBuf, readOffset, remaining)) < 0) {
                throw new EOFException("unexpected end of stream, read " + ((compressed ? compressedPacketLength : packetLength) - remaining) + " bytes from " + (compressed ? compressedPacketLength : packetLength) + " (socket was closed by server)");
            }
            readOffset += count;
        } while ((remaining -= count) > 0);
        if (compressed) {
            this.buf = new byte[packetLength];
            Inflater inflater = new Inflater();
            inflater.setInput(intermediaryBuf);
            try {
                int actualUncompressBytes = inflater.inflate(this.buf);
                if (actualUncompressBytes != packetLength) {
                    throw new IOException("Invalid exception length after decompression " + actualUncompressBytes + ",expected " + packetLength);
                }
            }
            catch (DataFormatException dfe) {
                throw new IOException(dfe);
            }
            inflater.end();
            this.end = packetLength;
        } else {
            this.buf = intermediaryBuf;
            this.end = compressedPacketLength;
        }
        this.pos = 0;
    }

    @Override
    public long skip(long n) throws IOException {
        throw new IOException("Skip from compress socket not implemented");
    }

    @Override
    public int available() throws IOException {
        return this.in.available();
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.in.mark(readlimit);
    }

    @Override
    public synchronized void reset() throws IOException {
        this.in.reset();
    }

    @Override
    public boolean markSupported() {
        return this.in.markSupported();
    }

    @Override
    public int read() throws IOException {
        throw new IOException("NOT IMPLEMENTED !");
    }
}

