/*
 * Decompiled with CFR 0.152.
 */
package com.Acrobot.ChestShop.Plugins;

import com.Acrobot.ChestShop.Events.Protection.ProtectionCheckEvent;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldguard.LocalPlayer;
import com.sk89q.worldguard.WorldGuard;
import com.sk89q.worldguard.bukkit.WorldGuardPlugin;
import com.sk89q.worldguard.protection.ApplicableRegionSet;
import com.sk89q.worldguard.protection.association.RegionAssociable;
import com.sk89q.worldguard.protection.flags.Flags;
import com.sk89q.worldguard.protection.flags.StateFlag;
import com.sk89q.worldguard.protection.managers.RegionManager;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;

public class WorldGuardProtection
implements Listener {
    private WorldGuardPlugin worldGuard;

    public WorldGuardProtection(WorldGuardPlugin worldGuard) {
        this.worldGuard = worldGuard;
    }

    @EventHandler
    public void onProtectionCheck(ProtectionCheckEvent event) {
        if (event.getResult() == Event.Result.DENY) {
            return;
        }
        Block block = event.getBlock();
        Player player = event.getPlayer();
        com.sk89q.worldedit.util.Location blockPos = BukkitAdapter.adapt((Location)block.getLocation());
        RegionManager manager = WorldGuard.getInstance().getPlatform().getRegionContainer().get(BukkitAdapter.adapt((World)block.getWorld()));
        ApplicableRegionSet set = manager.getApplicableRegions(blockPos.toVector().toBlockPoint());
        LocalPlayer localPlayer = this.worldGuard.wrapPlayer(player);
        if (!this.canAccess(localPlayer, block, set)) {
            event.setResult(Event.Result.DENY);
        }
    }

    private boolean canAccess(LocalPlayer player, Block block, ApplicableRegionSet set) {
        return this.hasBypass(player, block.getWorld()) || set.testState((RegionAssociable)player, new StateFlag[]{Flags.BUILD}) || set.testState((RegionAssociable)player, new StateFlag[]{Flags.CHEST_ACCESS});
    }

    private boolean hasBypass(LocalPlayer wgPlayer, World world) {
        return WorldGuard.getInstance().getPlatform().getSessionManager().hasBypass(wgPlayer, BukkitAdapter.adapt((World)world));
    }
}

