/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldguard.bukkit.session;

import com.sk89q.worldedit.world.World;
import com.sk89q.worldguard.LocalPlayer;
import com.sk89q.worldguard.WorldGuard;
import com.sk89q.worldguard.bukkit.BukkitPlayer;
import com.sk89q.worldguard.bukkit.WorldGuardPlugin;
import com.sk89q.worldguard.session.AbstractSessionManager;
import com.sk89q.worldguard.session.Session;
import java.util.Collection;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;

public class BukkitSessionManager
extends AbstractSessionManager
implements Runnable,
Listener {
    public void resetAllStates() {
        Collection players = Bukkit.getServer().getOnlinePlayers();
        for (Player player : players) {
            BukkitPlayer bukkitPlayer = new BukkitPlayer(WorldGuardPlugin.inst(), player);
            Session session = this.getIfPresent(bukkitPlayer);
            if (session == null) continue;
            session.resetState((LocalPlayer)bukkitPlayer);
        }
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        this.get(WorldGuardPlugin.inst().wrapPlayer(event.getPlayer()));
    }

    @Override
    public void run() {
        for (Player player : Bukkit.getServer().getOnlinePlayers()) {
            this.get(new BukkitPlayer(WorldGuardPlugin.inst(), player)).tick((LocalPlayer)new BukkitPlayer(WorldGuardPlugin.inst(), player));
        }
    }

    public boolean hasBypass(LocalPlayer player, World world) {
        if (player instanceof BukkitPlayer && ((BukkitPlayer)player).getPlayer().hasMetadata("NPC") && WorldGuard.getInstance().getPlatform().getGlobalStateManager().get((World)world).fakePlayerBuildOverride) {
            return true;
        }
        return super.hasBypass(player, world);
    }
}

