/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldguard.bukkit.commands;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.sk89q.worldguard.bukkit.commands.MessageTimerTask;
import java.util.Timer;
import java.util.TimerTask;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;

public class FutureProgressListener
implements Runnable {
    private static final Timer timer = new Timer();
    private static final int MESSAGE_DELAY = 1000;
    private final MessageTimerTask task;

    public FutureProgressListener(CommandSender sender, String message) {
        Preconditions.checkNotNull((Object)sender);
        Preconditions.checkNotNull((Object)message);
        this.task = new MessageTimerTask(sender, ChatColor.GRAY + message);
        timer.schedule((TimerTask)this.task, 1000L);
    }

    @Override
    public void run() {
        this.task.cancel();
    }

    public static void addProgressListener(ListenableFuture<?> future, CommandSender sender, String message) {
        future.addListener((Runnable)new FutureProgressListener(sender, message), MoreExecutors.directExecutor());
    }
}

